/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.dynclass;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynClass_v2;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.dynclass.DynClassControler;

public class DynClassesPanel
extends JPanel
implements org.gvsig.tools.swing.api.Component {
    private static final long serialVersionUID = 7210403463647012693L;
    private JList lstClasses;
    private final WindowManager_v2 windowManager;
    private List<DynClass> dynClasses;

    public DynClassesPanel(WindowManager_v2 windowManager) {
        this.windowManager = windowManager;
        this.iniComponents();
    }

    private void iniComponents() {
        this.setLayout(new BorderLayout());
        this.lstClasses = new JList();
        JScrollPane jscrollpane1 = new JScrollPane();
        jscrollpane1.setViewportView(this.lstClasses);
        jscrollpane1.setVerticalScrollBarPolicy(20);
        jscrollpane1.setHorizontalScrollBarPolicy(30);
        this.add((Component)jscrollpane1, "Center");
        this.lstClasses.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    DynClassesPanel.this.showCurrentClass();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public void set(Collection<DynClass> theDynClasses) {
        this.dynClasses = new ArrayList<DynClass>();
        this.dynClasses.addAll(theDynClasses);
        Collections.sort(this.dynClasses, new Comparator<DynClass>(){

            @Override
            public int compare(DynClass o1, DynClass o2) {
                return ((DynClass_v2)o1).getLabel().compareToIgnoreCase(((DynClass_v2)o2).getLabel());
            }
        });
        this.lstClasses.setModel(new ListModel(){

            @Override
            public int getSize() {
                return DynClassesPanel.this.dynClasses.size();
            }

            public Object getElementAt(int index) {
                DynClass_v2 dynClass = (DynClass_v2)DynClassesPanel.this.dynClasses.get(index);
                if (dynClass.getLabel().equalsIgnoreCase(dynClass.getName())) {
                    return dynClass.getLabel();
                }
                return dynClass.getLabel() + " (" + dynClass.getName() + ")";
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
    }

    public JComponent asJComponent() {
        return this;
    }

    public DynClass getCurrentClass() {
        int n = this.lstClasses.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.dynClasses.get(n);
    }

    private void showCurrentClass() {
        final DynClassControler panel = new DynClassControler(this.windowManager);
        final DynClass dynClass = this.getCurrentClass();
        panel.set((DynClass_v2)dynClass);
        final Dialog dialog = this.windowManager.createDialog((JComponent)panel, "Entity - " + dynClass.getName(), null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() == 1) {
                    panel.fetch(dynClass);
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }
}

