/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.hexeditor.swing;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteBuffer {
    private byte[] buffer;

    public ByteBuffer(int size) {
        this.buffer = new byte[size];
    }

    public ByteBuffer(String file) throws IOException {
        this(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer(File file) throws IOException {
        int size = (int)file.length();
        if (size < 0) {
            throw new IOException("Negative file length: " + size);
        }
        this.buffer = new byte[size];
        if (size > 0) {
            int count = 0;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                for (int pos = 0; pos < this.buffer.length && (count = in.read(this.buffer, pos, this.buffer.length - pos)) > -1; pos += count) {
                }
            }
        }
    }

    public ByteBuffer(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buffer = new byte[4096];
        int count = 0;
        while ((count = in.read(this.buffer, 0, this.buffer.length)) > -1) {
            baos.write(this.buffer, 0, count);
        }
        this.buffer = baos.toByteArray();
    }

    public byte getByte(int offset) {
        return this.buffer[offset];
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public void insertByte(int offset, byte b) {
        byte[] buf2 = new byte[this.buffer.length + 1];
        System.arraycopy(this.buffer, 0, buf2, 0, offset);
        buf2[offset] = b;
        System.arraycopy(this.buffer, offset, buf2, offset + 1, this.buffer.length - offset);
        this.buffer = buf2;
    }

    public void insertBytes(int offs, byte[] b) {
        if (b == null || b.length == 0) {
            return;
        }
        byte[] buf2 = new byte[this.buffer.length + b.length];
        System.arraycopy(this.buffer, 0, buf2, 0, offs);
        System.arraycopy(b, 0, buf2, offs, b.length);
        System.arraycopy(this.buffer, offs, buf2, offs + b.length, this.buffer.length - offs);
        this.buffer = buf2;
    }

    public int read(int offset, byte[] buf) {
        if (buf == null) {
            return -1;
        }
        int count = Math.min(buf.length, this.getSize() - offset);
        System.arraycopy(this.buffer, offset, buf, 0, count);
        return count;
    }

    public void remove(int offset, int len) {
        this.remove(offset, len, null);
    }

    public void remove(int offset, int len, byte[] removed) {
        if (removed != null) {
            System.arraycopy(this.buffer, offset, removed, 0, len);
        }
        byte[] buf = new byte[this.buffer.length - len];
        System.arraycopy(this.buffer, 0, buf, 0, offset);
        System.arraycopy(this.buffer, offset + len, buf, offset, buf.length - offset);
        this.buffer = buf;
    }

    public void setByte(int offset, byte b) {
        this.buffer[offset] = b;
    }
}

