/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.hexeditor.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.gvsig.tools.swing.impl.hexeditor.swing.ByteArrayTransferable;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexEditorComponent;

class HexEditorTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    HexEditorTransferHandler() {
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        HexEditorComponent editor = (HexEditorComponent)comp;
        if (!editor.isEnabled()) {
            return false;
        }
        return this.getImportFlavor(flavors, editor) != null;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        HexEditorComponent e = (HexEditorComponent)c;
        int start = e.getSmallestSelectionIndex();
        int end = e.getLargestSelectionIndex();
        byte[] array = new byte[end - start + 1];
        for (int i = end; i >= start; --i) {
            array[i - start] = e.getByte(i);
        }
        ByteArrayTransferable bat = new ByteArrayTransferable(start, array);
        return bat;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (action == 2) {
            ByteArrayTransferable bat = (ByteArrayTransferable)data;
            int offs = bat.getOffset();
            HexEditorComponent e = (HexEditorComponent)source;
            e.removeBytes(offs, bat.getLength());
        }
    }

    private DataFlavor getImportFlavor(DataFlavor[] flavors, HexEditorComponent e) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.stringFlavor)) continue;
            return flavors[i];
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        HexEditorComponent e = (HexEditorComponent)c;
        return e.isEnabled() ? 3 : 1;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        HexEditorComponent e = (HexEditorComponent)c;
        boolean imported = false;
        DataFlavor flavor = this.getImportFlavor(t.getTransferDataFlavors(), e);
        if (flavor != null) {
            try {
                Object data = t.getTransferData(flavor);
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    String text = (String)data;
                    byte[] bytes = text.getBytes();
                    e.replaceSelection(bytes);
                }
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return imported;
    }
}

