/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.icontheme;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.packageutils.PackageManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.impl.icontheme.BaseIconTheme;

public class IconThemeZip
extends BaseIconTheme {
    protected File resource = null;
    protected PackageInfo packageInfo = null;

    public IconThemeZip(IconTheme def) {
        super(def);
    }

    @Override
    public void load(Object resource) {
        if (!(resource instanceof File)) {
            throw new IllegalArgumentException();
        }
        File res = (File)resource;
        if (!res.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.resource = res;
        this.iconList = null;
        this.loadPackageInfo();
        this.setName(this.packageInfo.getName());
        this.setDescription(this.packageInfo.getDescription());
    }

    private void loadPackageInfo() {
        PackageManager manager = ToolsLocator.getPackageManager();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.resource);
            InputStream pkgstream = zipFile.getInputStream(zipFile.getEntry("packages.zip"));
            this.packageInfo = manager.createPackageInfo(pkgstream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected void deferredLoad() {
        if (this.iconList != null) {
            return;
        }
        this.iconList = new HashMap();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.resource);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            try {
                if (!this.isImage(entry.getName())) continue;
                String name = this.getNameOfEntry(entry);
                String group = this.getGroupOfEntry(entry);
                URL resource = this.getURLOfEntry(this.resource, entry);
                this.register(null, group, name, null, resource);
            }
            catch (Exception e) {
                logger.info("Can't register icon. Entry = " + entry.toString(), (Throwable)e);
            }
        }
    }

    private URL getURLOfEntry(File zip, ZipEntry entry) throws MalformedURLException, URISyntaxException {
        String s = "jar:" + zip.toString() + "!" + entry.getName();
        return new URI(s).toURL();
    }

    private String getGroupOfEntry(ZipEntry entry) {
        return "";
    }

    private String getNameOfEntry(ZipEntry entry) {
        return entry.getName();
    }

    private boolean isImage(String fileName) {
        String extension = "";
        int pointPos = fileName.lastIndexOf(".");
        if (pointPos > 0 && pointPos < fileName.length() - 1) {
            extension = fileName.substring(pointPos + 1).toLowerCase();
        }
        return extension.equals("jpg") || extension.equals("jpeg") || extension.equals("png") || extension.equals("gif");
    }

    @Override
    public boolean matchID(String id) {
        return this.packageInfo.matchID(id);
    }
}

