/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller.nullablespinner;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableEditor;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableTimeEditorFormatter;

public class NullableTimeEditor
extends NullableEditor {
    private static String getDefaultPattern(String pattern, Locale loc) {
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            return pattern;
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3, loc);
        return df.toPattern();
    }

    public NullableTimeEditor(JSpinner spinner) {
        this(spinner, "hh:mm a", null);
    }

    public NullableTimeEditor(JSpinner spinner, Locale locale) {
        this(spinner, "hh:mm a", locale);
    }

    public NullableTimeEditor(JSpinner spinner, String pattern) {
        this(spinner, "hh:mm a", null);
    }

    public NullableTimeEditor(JSpinner spinner, String pattern, Locale locale) {
        this(spinner, new SimpleDateFormat(NullableTimeEditor.getDefaultPattern(pattern, locale), locale == null ? Locale.getDefault() : locale));
    }

    private NullableTimeEditor(JSpinner spinner, DateFormat format) {
        super(spinner);
        if (!(spinner.getModel() instanceof SpinnerDateModel)) {
            throw new IllegalArgumentException("model not a SpinnerDateModel");
        }
        SpinnerDateModel model = (SpinnerDateModel)spinner.getModel();
        NullableTimeEditorFormatter formatter = new NullableTimeEditorFormatter(model, format, this.getTextField());
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
        JFormattedTextField ftf = this.getTextField();
        ftf.setEditable(true);
        ftf.setFormatterFactory(factory);
        try {
            String maxString = ((InternationalFormatter)formatter).valueToString(model.getStart());
            String minString = ((InternationalFormatter)formatter).valueToString(model.getEnd());
            ftf.setColumns(Math.max(maxString.length(), minString.length()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public SimpleDateFormat getFormat() {
        return (SimpleDateFormat)((DateFormatter)this.getTextField().getFormatter()).getFormat();
    }

    public SpinnerDateModel getModel() {
        return (SpinnerDateModel)this.getSpinner().getModel();
    }
}

