/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller.nullablespinner;

import java.awt.Color;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JFormattedTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.text.DateFormatter;

class NullableTimeEditorFormatter
extends DateFormatter {
    private final SpinnerDateModel model;
    private final JFormattedTextField textField;
    private final Color colorOk;
    private final Color colorErr;
    private final SimpleDateFormat[] parsers = new SimpleDateFormat[]{new SimpleDateFormat("h:m a"), new SimpleDateFormat("H:m")};

    NullableTimeEditorFormatter(SpinnerDateModel model, DateFormat format, JFormattedTextField textField) {
        super(format);
        this.model = model;
        this.textField = textField;
        this.colorOk = UIManager.getColor("TextField.background");
        this.colorErr = new Color(255, 225, 232);
    }

    public void setMinimum(Comparable min) {
        this.model.setStart(min);
    }

    public Comparable getMinimum() {
        return this.model.getStart();
    }

    public void setMaximum(Comparable max) {
        this.model.setEnd(max);
    }

    public Comparable getMaximum() {
        return this.model.getEnd();
    }

    private Calendar getCalendar() {
        Format f = this.getFormat();
        if (f instanceof DateFormat) {
            return ((DateFormat)f).getCalendar();
        }
        return Calendar.getInstance();
    }

    @Override
    protected void setEditValid(boolean valid) {
        super.setEditValid(valid);
        if (valid) {
            this.textField.setBackground(this.colorOk);
        } else {
            this.textField.setBackground(this.colorErr);
        }
    }

    private boolean isValidValue(Object value, boolean wantsCCE) {
        Comparable min = this.getMinimum();
        try {
            if (min != null && min.compareTo(value) > 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        Comparable max = this.getMaximum();
        try {
            if (max != null && max.compareTo(value) < 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        return true;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Object value = null;
        ParseException parseError = null;
        for (SimpleDateFormat parser : this.parsers) {
            try {
                parser.setLenient(false);
                value = this.stringToValue(text, parser);
                if (value == null) continue;
                parseError = null;
                break;
            }
            catch (ParseException ex) {
                parseError = ex;
            }
        }
        if (parseError != null) {
            throw parseError;
        }
        if (value != null && this.getValueClass() != null && !this.getValueClass().isInstance(value)) {
            value = super.stringToValue(value.toString());
        }
        try {
            if (!this.isValidValue(value, true)) {
                throw new ParseException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Class cast exception comparing values: " + cce, 0);
        }
        return value;
    }

    private Object stringToValue(String text, Format f) throws ParseException {
        if (f == null) {
            return text;
        }
        text = text.trim();
        ParsePosition pos = new ParsePosition(0);
        Object v = f.parseObject(text, pos);
        if (pos.getIndex() != text.length()) {
            throw new ParseException(text, pos.getIndex());
        }
        return v;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        Format f = this.getFormat();
        if (f == null) {
            return value.toString();
        }
        return f.format(value);
    }
}

