/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json.serializers;

import javax.json.JsonObject;
import javax.json.JsonValue;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.JsonObjectBuilderImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.impl.DefaultDynObject;
import org.gvsig.tools.util.IsApplicable;

public class DynObjectSerializer
implements JsonManager.JsonSerializer,
IsApplicable {
    public static final String ATTRIBUTE_NAME_DYNCLASS = "__dynclassname__";

    public Class getObjectClass() {
        return DefaultDynObject.class;
    }

    protected DynObject createDynObject(JsonObject json) {
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        JsonObject dynClassJson = json.getJsonObject(ATTRIBUTE_NAME_DYNCLASS);
        DynObject dynObject = manager.createDynObject(dynClassJson.getString("name"), dynClassJson.getString("namespace"));
        return dynObject;
    }

    public Object toObject(JsonObject json) {
        try {
            DynObject dynObject = this.createDynObject(json);
            this.addAll(dynObject, json);
            return dynObject;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public JsonObjectBuilder toJsonBuilder(Object value) {
        DynObject dynObject = (DynObject)value;
        DynClass dynClass = dynObject.getDynClass();
        JsonObjectBuilderImpl objBuilder = new JsonObjectBuilderImpl();
        objBuilder.add_class(value);
        JsonObjectBuilderImpl dynClassBuilder = new JsonObjectBuilderImpl();
        dynClassBuilder.add("name", dynClass.getName());
        dynClassBuilder.add("namespace", dynClass.getNamespace());
        objBuilder.add(ATTRIBUTE_NAME_DYNCLASS, (javax.json.JsonObjectBuilder)dynClassBuilder);
        this.addAll(objBuilder, value);
        return objBuilder;
    }

    public boolean isApplicable(Object ... args) {
        if (args[0] instanceof DynObject) {
            return true;
        }
        if (!(args[0] instanceof JsonObject)) {
            return false;
        }
        JsonObject json = (JsonObject)args[0];
        JsonObject dynClassJson = json.getJsonObject(ATTRIBUTE_NAME_DYNCLASS);
        if (dynClassJson == null) {
            return false;
        }
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        DynClass dynClass = manager.get(dynClassJson.getString("namespace"), dynClassJson.getString("name"));
        return dynClass != null;
    }

    private void addAll(Object target_o, JsonObject source) {
        JsonManager jsonManager = Json.getManager();
        DynObject target = (DynObject)target_o;
        DynClass dynClass = target.getDynClass();
        String name = null;
        try {
            for (DynField dynField : dynClass.getDynFields()) {
                name = dynField.getName();
                if (!source.containsKey((Object)name)) continue;
                target.setDynValue(name, jsonManager.toObject((JsonValue)source.get((Object)name)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't copy values from json to DynObject (class " + dynClass.getFullName() + ", field " + name + ").", ex);
        }
    }

    private void addAll(JsonObjectBuilder target, Object source_o) {
        DynObject source = (DynObject)source_o;
        DynClass dynClass = source.getDynClass();
        for (DynField dynField : dynClass.getDynFields()) {
            String name = dynField.getName();
            target.add(name, source.getDynValue(name));
        }
    }
}

