/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.unit;

import java.util.Objects;
import java.util.Set;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.UnitFormat;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.SystemOfUnits;
import org.gvsig.unit.MeasureFactory;
import org.gvsig.unit.MeasureTools;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.quantity.DefaultQuantityFactory;
import tech.units.indriya.unit.Units;

public class MeasureFactoryImpl
implements MeasureFactory {
    private SystemOfUnits systemOfUnits = null;

    public MeasureFactoryImpl(SystemOfUnits systemOfUnits) {
        this.systemOfUnits = systemOfUnits;
    }

    public SystemOfUnits getSystemOfUnits() {
        return this.systemOfUnits;
    }

    public Unit<?> getUnit(String name) {
        Objects.requireNonNull(name);
        return this.systemOfUnits.getUnits().stream().filter(u -> name.equals(u.toString())).findAny().orElse(null);
    }

    public Set<? extends Unit<?>> getUnits() {
        return this.systemOfUnits.getUnits();
    }

    public Set<? extends Unit<?>> getUnits(Dimension dmnsn) {
        return this.systemOfUnits.getUnits(dmnsn);
    }

    public QuantityFactory getQuantityFactory(Class<Quantity> quantity) {
        return DefaultQuantityFactory.getInstance(quantity);
    }

    public UnitFormat getUnitFormat() {
        return SimpleUnitFormat.getInstance();
    }

    public static void selfRegister() {
        MeasureTools.factory = new MeasureFactoryImpl(Units.getInstance());
        MeasureTools.METRE = Units.METRE;
        MeasureTools.RADIAN = Units.RADIAN;
        MeasureTools.DEGREE_ANGLE = Units.RADIAN.multiply(Math.PI / 180).asType(Angle.class);
        MeasureTools.INCH = Units.METRE.multiply(0.0254).asType(Length.class);
    }

    public static void main(String[] args) {
        System.out.println("prueba");
        MeasureFactoryImpl.selfRegister();
        UnitConverter converterInchToMetre = MeasureTools.INCH.getConverterTo(MeasureTools.METRE);
        System.out.println("1 pulgada == " + converterInchToMetre.convert(1.0) + " metros");
        UnitConverter converterMetreToInch = MeasureTools.METRE.getConverterTo(MeasureTools.INCH);
        System.out.println("1 metro == " + converterMetreToInch.convert(1.0) + " pulgadas");
        UnitConverter converterInchToCentimetre = MeasureTools.INCH.getConverterTo(Units.METRE.divide(100.0).asType(Length.class));
        System.out.println("1 pulgada == " + converterInchToCentimetre.convert(1.0) + " centimetros");
    }
}

