/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

import java.util.List;
import org.gvsig.raster.lib.legend.api.colorinterpretation.ColorInterpretation;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableNotification;
import org.gvsig.raster.lib.legend.impl.colorinterpretation.DefaultColorInterpretationNotification;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultColorInterpretation
extends BaseWeakReferencingObservable
implements ColorInterpretation {
    public static final String PERSISTENCE_DEFINITION = "ColorInterpretationPersistence";
    public static final String PERSISTENCE_DESCRIPTION = "Persistence color interpretation definition description";
    private static final String COLOR_INTERPRETATION_PERSISTENCE_FIELD = "colorInterpretation";
    private static final String COLOR_TABLE_PERSISTENCE_FIELD = "colorTable";
    private static final String PALETTE_BAND_PERSISTENCE_FIELD = "paletteBand";
    private String[] colorInterpretation = null;
    private ColorTable colorTable;
    private int paletteBand;

    public DefaultColorInterpretation() {
        this.colorInterpretation = new String[0];
        this.paletteBand = -1;
        this.colorTable = null;
    }

    public DefaultColorInterpretation(String[] bandColorInterpretations) {
        for (int i = 0; i < bandColorInterpretations.length; ++i) {
            if (this.isColorInterpretationValid(bandColorInterpretations[i])) continue;
            throw new IllegalArgumentException(String.format("%1s color interpretation is not valid", bandColorInterpretations[i]));
        }
        this.colorInterpretation = new String[bandColorInterpretations.length];
        System.arraycopy(bandColorInterpretations, 0, this.colorInterpretation, 0, this.colorInterpretation.length);
        this.paletteBand = -1;
        this.colorTable = null;
    }

    public DefaultColorInterpretation(int nBands) {
        this.colorInterpretation = new String[nBands];
        this.paletteBand = -1;
        this.colorTable = null;
    }

    public DefaultColorInterpretation(String bandColorInterpretation) {
        this.paletteBand = -1;
        this.colorTable = null;
        if (bandColorInterpretation.equals("RGB")) {
            this.colorInterpretation = new String[]{"Red", "Green", "Blue"};
        } else if (bandColorInterpretation.equals("BGR")) {
            this.colorInterpretation = new String[]{"Blue", "Green", "Red"};
        } else if (bandColorInterpretation.equals("ARGB")) {
            this.colorInterpretation = new String[]{"Red", "Green", "Blue", "Alpha"};
        } else if (bandColorInterpretation.equals("GRAYSCALE")) {
            this.colorInterpretation = new String[]{"Gray"};
        } else if (bandColorInterpretation.equals("PALETTE")) {
            this.colorInterpretation = new String[]{"Palette"};
            this.paletteBand = 0;
        } else if (bandColorInterpretation.equals("HSL")) {
            this.colorInterpretation = new String[]{"Hue", "Saturation", "Lightness"};
        } else if (bandColorInterpretation.equals("CMYK")) {
            this.colorInterpretation = new String[]{"Cyan", "Magenta", "Yellow", "Black"};
        } else if (bandColorInterpretation.equals("YCBCR")) {
            this.colorInterpretation = new String[]{"YCbCr_Y", "YCbCr_Cb", "YCbCr_Cr"};
        }
        if (this.colorInterpretation == null) {
            throw new IllegalArgumentException("Can not create color interpretation. Type is not recognised");
        }
    }

    public void setColorInterpValue(int band, String value) {
        String[] oldColorInterpretation = new String[this.colorInterpretation.length];
        System.arraycopy(this.colorInterpretation, 0, oldColorInterpretation, 0, this.colorInterpretation.length);
        if (band < 0 || band >= this.colorInterpretation.length) {
            throw new IllegalArgumentException("Band is out of color interpretation bands");
        }
        if (!this.isColorInterpretationValid(value)) {
            throw new IllegalArgumentException(String.format("%1s is not valid", value));
        }
        this.colorInterpretation[band] = value;
        this.notifyObservers((Object)new DefaultColorInterpretationNotification("changed_color_interpretation_value_notification", new Object[]{oldColorInterpretation, this.colorInterpretation}));
    }

    public int length() {
        return this.colorInterpretation.length;
    }

    private boolean isColorInterpretationValid(String bandColorInterpretation) {
        return bandColorInterpretation.equals("Red") || bandColorInterpretation.equals("Green") || bandColorInterpretation.equals("Blue") || bandColorInterpretation.equals("Gray") || bandColorInterpretation.equals("Palette") || bandColorInterpretation.equals("Hue") || bandColorInterpretation.equals("Saturation") || bandColorInterpretation.equals("Lightness") || bandColorInterpretation.equals("Cyan") || bandColorInterpretation.equals("Magenta") || bandColorInterpretation.equals("Yellow") || bandColorInterpretation.equals("Black") || bandColorInterpretation.equals("YCbCr_Y") || bandColorInterpretation.equals("YCbCr_Cb") || bandColorInterpretation.equals("YCbCr_Cr") || bandColorInterpretation.equals("Undefined") || bandColorInterpretation.equals("Alpha");
    }

    public boolean hasInterpretation() {
        if (this.colorInterpretation == null) {
            return false;
        }
        for (int i = 0; i < this.colorInterpretation.length; ++i) {
            if (!this.colorInterpretation[i].equals("Red") && !this.colorInterpretation[i].equals("Green") && !this.colorInterpretation[i].equals("Blue") && !this.colorInterpretation[i].equals("Palette") && !this.colorInterpretation[i].equals("Hue") && !this.colorInterpretation[i].equals("Saturation") && !this.colorInterpretation[i].equals("Lightness") && !this.colorInterpretation[i].equals("Cyan") && !this.colorInterpretation[i].equals("Magenta") && !this.colorInterpretation[i].equals("Yellow") && !this.colorInterpretation[i].equals("Black") && !this.colorInterpretation[i].equals("YCbCr_Y") && !this.colorInterpretation[i].equals("YCbCr_Cb") && !this.colorInterpretation[i].equals("YCbCr_Cr") && !this.colorInterpretation[i].equals("Gray")) continue;
            return true;
        }
        return false;
    }

    public boolean isBGR() {
        return this.colorInterpretation != null && this.colorInterpretation.length == 3 && this.colorInterpretation[0] == "Blue" && this.colorInterpretation[1] == "Green" && this.colorInterpretation[2] == "Red";
    }

    public boolean isRGB() {
        return this.colorInterpretation != null && this.colorInterpretation.length >= 3 && this.hasAnyBandWithThisColorInterpretation("Red") && this.hasAnyBandWithThisColorInterpretation("Green") && this.hasAnyBandWithThisColorInterpretation("Blue");
    }

    public boolean hasAnyRGBBand() {
        if (this.colorInterpretation != null) {
            boolean redFound = false;
            boolean greenFound = false;
            boolean bluefound = false;
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] == "Red") {
                    redFound = true;
                }
                if (this.colorInterpretation[i] == "Green") {
                    greenFound = true;
                }
                if (this.colorInterpretation[i] != "Blue") continue;
                bluefound = true;
            }
            if (redFound || greenFound || bluefound) {
                return true;
            }
        }
        return false;
    }

    public boolean isHSL() {
        return this.colorInterpretation != null && this.colorInterpretation.length >= 3 && this.hasAnyBandWithThisColorInterpretation("Hue") && this.hasAnyBandWithThisColorInterpretation("Lightness") && this.hasAnyBandWithThisColorInterpretation("Saturation");
    }

    private boolean hasAnyBandWithThisColorInterpretation(String interpretation) {
        if (this.colorInterpretation != null) {
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] != interpretation) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCMYK() {
        return this.colorInterpretation != null && this.colorInterpretation.length >= 4 && this.hasAnyBandWithThisColorInterpretation("Cyan") && this.hasAnyBandWithThisColorInterpretation("Magenta") && this.hasAnyBandWithThisColorInterpretation("Yellow") && this.hasAnyBandWithThisColorInterpretation("Black");
    }

    public boolean isYCBCR() {
        return this.colorInterpretation != null && this.colorInterpretation.length >= 3 && this.hasAnyBandWithThisColorInterpretation("YCbCr_Y") && this.hasAnyBandWithThisColorInterpretation("YCbCr_Cb") && this.hasAnyBandWithThisColorInterpretation("YCbCr_Cr");
    }

    public boolean isRGBA() {
        return this.colorInterpretation != null && this.colorInterpretation.length >= 4 && this.hasAnyBandWithThisColorInterpretation("Red") && this.hasAnyBandWithThisColorInterpretation("Green") && this.hasAnyBandWithThisColorInterpretation("Blue") && this.hasAnyBandWithThisColorInterpretation("Alpha");
    }

    public boolean isGray() {
        return this.colorInterpretation != null && this.length() >= 1 && this.hasAnyBandWithThisColorInterpretation("Gray");
    }

    public boolean hasAnyGrayBand() {
        if (this.colorInterpretation != null) {
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] != "Gray") continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyPaletteBand() {
        if (this.colorInterpretation != null) {
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] != "Palette") continue;
                return true;
            }
        }
        return false;
    }

    public boolean isColorInterpretation(int band) {
        return this.colorInterpretation[band].equals("Red") || this.colorInterpretation[band].equals("Green") || this.colorInterpretation[band].equals("Blue") || this.colorInterpretation[band].equals("Hue") || this.colorInterpretation[band].equals("Saturation") || this.colorInterpretation[band].equals("Lightness") || this.colorInterpretation[band].equals("Cyan") || this.colorInterpretation[band].equals("Magenta") || this.colorInterpretation[band].equals("Yellow") || this.colorInterpretation[band].equals("Black") || this.colorInterpretation[band].equals("YCbCr_Y") || this.colorInterpretation[band].equals("YCbCr_Cb") || this.colorInterpretation[band].equals("YCbCr_Cr");
    }

    public boolean hasAnyColorInterpretationBand() {
        if (this.colorInterpretation != null) {
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (!this.isColorInterpretation(i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGrayInterpretation(int band) {
        return this.colorInterpretation[band].equals("Gray");
    }

    public boolean isPaletteInterpretation(int band) {
        return this.colorInterpretation[band].equals("Palette");
    }

    public boolean isAlphaInterpretation(int band) {
        return this.colorInterpretation[band].equals("Alpha");
    }

    public String get(int i) {
        if (i < 0 || i >= this.colorInterpretation.length) {
            throw new IllegalArgumentException("Index out of defined color interpretation");
        }
        return this.colorInterpretation[i];
    }

    public int getBand(String id) {
        if (this.colorInterpretation != null && !id.equalsIgnoreCase("Undefined")) {
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] == null || !this.colorInterpretation[i].equals(id)) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean isUndefined() {
        for (int i = 0; i < this.colorInterpretation.length; ++i) {
            if (this.colorInterpretation[i] == null || this.colorInterpretation[i].equals("Alpha")) continue;
            return false;
        }
        return true;
    }

    public String[] getValues() {
        return this.colorInterpretation;
    }

    public boolean hasAlphaBand() {
        return this.getAlphaBand() >= 0;
    }

    public int getAlphaBand() {
        String[] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !values[i].equals("Alpha")) continue;
            return i;
        }
        return -1;
    }

    public void addColorInterpretation(ColorInterpretation ci) {
        int i;
        String[] oldColorInterpretation = this.colorInterpretation;
        String[] newCI = new String[this.colorInterpretation.length + ci.length()];
        for (i = 0; i < this.colorInterpretation.length; ++i) {
            newCI[i] = this.colorInterpretation[i];
        }
        for (i = 0; i < ci.length(); ++i) {
            newCI[this.colorInterpretation.length + i] = ci.get(i);
        }
        this.colorInterpretation = newCI;
        this.notifyObservers((Object)new DefaultColorInterpretationNotification("added_color_interpretation_notification", new Object[]{oldColorInterpretation, this.colorInterpretation}));
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENCE_DEFINITION);
        if (definition == null) {
            definition = manager.addDefinition(DefaultColorInterpretation.class, PERSISTENCE_DEFINITION, PERSISTENCE_DESCRIPTION, null, null);
            definition.addDynFieldList(COLOR_INTERPRETATION_PERSISTENCE_FIELD).setClassOfItems(String.class).setMandatory(false);
            definition.addDynFieldInt(PALETTE_BAND_PERSISTENCE_FIELD).setMandatory(false);
            definition.addDynFieldObject(COLOR_TABLE_PERSISTENCE_FIELD).setClassOfValue(ColorTable.class);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(COLOR_INTERPRETATION_PERSISTENCE_FIELD, this.colorInterpretation);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List descriptions = (List)state.get(COLOR_INTERPRETATION_PERSISTENCE_FIELD);
        this.colorInterpretation = descriptions.toArray(new String[descriptions.size()]);
        this.setPaletteBand(state.getInt(PALETTE_BAND_PERSISTENCE_FIELD, -1));
        this.setPalette((ColorTable)state.get(COLOR_TABLE_PERSISTENCE_FIELD));
    }

    public void copyFrom(ColorInterpretation colorInterpretation) {
        String[] oldColorInterpretation = new String[this.length()];
        System.arraycopy(this.colorInterpretation, 0, oldColorInterpretation, 0, this.length());
        this.colorInterpretation = new String[colorInterpretation.length()];
        System.arraycopy(colorInterpretation.getValues(), 0, this.colorInterpretation, 0, colorInterpretation.length());
        this.paletteBand = colorInterpretation.getPaletteBand();
        this.notifyObservers((Object)new DefaultColorInterpretationNotification("copied_from_color_interpretation_notification", new Object[]{oldColorInterpretation, this.colorInterpretation}));
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultColorInterpretation cloned = new DefaultColorInterpretation(this.length());
        cloned.copyFrom(this);
        if (this.colorTable != null) {
            cloned.setPalette((ColorTable)this.colorTable.clone());
        }
        return cloned;
    }

    public boolean hasAnyHSLBand() {
        if (this.colorInterpretation != null) {
            boolean hueFound = false;
            boolean saturationFound = false;
            boolean lightnessFound = false;
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] == "Hue") {
                    hueFound = true;
                }
                if (this.colorInterpretation[i] == "Saturation") {
                    saturationFound = true;
                }
                if (this.colorInterpretation[i] != "Lightness") continue;
                lightnessFound = true;
            }
            if (hueFound || saturationFound || lightnessFound) {
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyCMYKBand() {
        if (this.colorInterpretation != null) {
            boolean cyanFound = false;
            boolean magentaFound = false;
            boolean yellowFound = false;
            boolean blackFound = false;
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] == "Cyan") {
                    cyanFound = true;
                }
                if (this.colorInterpretation[i] == "Magenta") {
                    magentaFound = true;
                }
                if (this.colorInterpretation[i] == "Yellow") {
                    yellowFound = true;
                }
                if (this.colorInterpretation[i] != "Black") continue;
                blackFound = true;
            }
            if (cyanFound || magentaFound || yellowFound || blackFound) {
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyYCBCRBand() {
        if (this.colorInterpretation != null) {
            boolean cBFound = false;
            boolean cRFound = false;
            boolean yFound = false;
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] == "YCbCr_Cb") {
                    cBFound = true;
                }
                if (this.colorInterpretation[i] == "YCbCr_Cr") {
                    cRFound = true;
                }
                if (this.colorInterpretation[i] != "YCbCr_Y") continue;
                yFound = true;
            }
            if (cBFound || cRFound || yFound) {
                return true;
            }
        }
        return false;
    }

    public boolean isPalette() {
        return this.paletteBand >= 0 && this.paletteBand < this.length() && this.colorTable != null;
    }

    public void setPalette(ColorTable colorTable) {
        ColorTable oldColorTable = this.colorTable;
        if (colorTable != null && !colorTable.equals(oldColorTable)) {
            if (oldColorTable != null) {
                oldColorTable.deleteObserver((Observer)this);
            }
            this.colorTable = colorTable;
            this.colorTable.addObserver((Observer)this);
            this.notifyObservers((Object)new DefaultColorInterpretationNotification("setted_palette_notification", new Object[]{oldColorTable, colorTable}));
        }
    }

    public void setPaletteBand(int band) {
        if (band != this.paletteBand) {
            int oldPaletteBand = this.paletteBand;
            this.paletteBand = band >= 0 && band < this.length() ? band : -1;
            this.notifyObservers((Object)new DefaultColorInterpretationNotification("changed_palette_band_notification", new Object[]{oldPaletteBand, this.paletteBand}));
        }
    }

    public int getPaletteBand() {
        return this.paletteBand;
    }

    public ColorTable getPalette() {
        return this.colorTable;
    }

    public void update(Observable observable, Object notification) {
        Notification colorTableNotification;
        if (notification instanceof ColorTableNotification && observable instanceof ColorTable && ((colorTableNotification = (Notification)notification).getType().equals("changed_interpolated_color_table_notification") || colorTableNotification.getType().equals("compressed_color_table_notification") || colorTableNotification.getType().equals("copied_from_color_table_notification") || colorTableNotification.getType().equals("removed_duplicated_values_color_table_notification") || colorTableNotification.getType().equals("setted_class_values_color_table_notification"))) {
            this.notifyObservers((Object)new DefaultColorInterpretationNotification("changed_palette_notification", new Object[]{observable}));
        }
    }
}

