/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.colortable;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.spi.AbstractColoredOperation;
import org.gvsig.tools.locator.LocatorException;

public class ColorTableOperation
extends AbstractColoredOperation {
    private RowProcessor rowProcessor;

    public ColorTableOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        try {
            if (!this.getInputColorInterpretation().isPalette()) {
                throw new UnsupportedOperationException("The color interpretation of input buffer isn't Palette");
            }
            int bandType = this.getInputBuffer().getBand(this.getInputColorInterpretation().getPaletteBand()).getDataType();
            switch (bandType) {
                case 0: {
                    this.rowProcessor = new ByteRowProcessor();
                    break;
                }
                case 1: {
                    this.rowProcessor = new UShortRowProcessor();
                    break;
                }
                case 2: {
                    this.rowProcessor = new ShortRowProcessor();
                    break;
                }
                case 3: {
                    this.rowProcessor = new IntRowProcessor();
                    break;
                }
                case 4: {
                    this.rowProcessor = new FloatRowProcessor();
                    break;
                }
                case 5: {
                    this.rowProcessor = new DoubleRowProcessor();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknow type of band '" + this.getInputColorInterpretation().getPaletteBand() + "'");
                }
            }
            int sourceBands = this.getInputBuffer().getBandCount();
            NoData[] sourceNoDatas = this.getInputBuffer().getBandNoData();
            ArrayList<String> colorInterpretations = new ArrayList<String>();
            ArrayList<NoData> noDatas = new ArrayList<NoData>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            colorInterpretations.add("Red");
            colorInterpretations.add("Green");
            colorInterpretations.add("Blue");
            colorInterpretations.add("Alpha");
            types.add(0);
            types.add(0);
            types.add(0);
            types.add(0);
            noDatas.add(null);
            noDatas.add(null);
            noDatas.add(null);
            noDatas.add(null);
            if (this.mustCopyUnprocessedBands()) {
                for (int band = 0; band < sourceBands; ++band) {
                    if (this.isProcessableBand(band)) continue;
                    colorInterpretations.add("Undefined");
                    noDatas.add(sourceNoDatas[band]);
                    types.add(this.getInputBuffer().getBandTypes()[band]);
                }
            }
            this.setOutputColorInterpretation(legendManager.createColorInterpretation(colorInterpretations));
            this.setParameter("output_color_interpretation", this.getOutputColorInterpretation());
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getTypesAsArray(types), this.getNoDatasAsArray(noDatas), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new ProcessingOperationException(e);
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        try {
            if (this.mustCopyUnprocessedBands()) {
                int bands = this.getInputBuffer().getBandCount();
                int outBand = 4;
                for (int band = 0; band < bands; ++band) {
                    if (this.isProcessableBand(band)) continue;
                    this.getOutputBuffer().getBand(outBand).copyFrom(this.getInputBuffer().getBand(band));
                    ++outBand;
                }
            }
            for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                Band outputBufferBand;
                int band;
                Band bufferPaletteBand = this.getInputBuffer().getBand(this.getInputColorInterpretation().getPaletteBand());
                Object rowBandBuffer = bufferPaletteBand.createRowBuffer();
                bufferPaletteBand.fetchRow(row, rowBandBuffer);
                ArrayList<Object> outputRowBuffers = new ArrayList<Object>();
                for (band = 0; band < 4; ++band) {
                    outputBufferBand = this.getOutputBuffer().getBand(band);
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    outputRowBuffers.add(outputRowBuffer);
                }
                this.rowProcessor.processRow(rowBandBuffer, outputRowBuffers);
                for (band = 0; band < 4; ++band) {
                    outputBufferBand = this.getOutputBuffer().getBand(band);
                    outputBufferBand.putRow(row, outputRowBuffers.get(band));
                }
            }
        }
        catch (Exception e) {
            throw new ProcessingOperationException((Throwable)e);
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    protected boolean isProcessableBand(int band) {
        return this.isPaletteBand(band);
    }

    private boolean isPaletteBand(int band) {
        return this.getInputColorInterpretation().getPaletteBand() == band;
    }

    private class DoubleRowProcessor
    extends AbstractRowProcessor {
        @Override
        public void processRow(Object inputRow, List outputRows) {
            double[] inputByteRow = (double[])inputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                byte[] rgb = this.processValue(inputByteRow[i]);
                for (int band = 0; band < outputRows.size(); ++band) {
                    byte[] bs = (byte[])outputRows.get(band);
                    bs[i] = rgb[band];
                }
            }
        }

        @Override
        public byte[] processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                byte[] result = new byte[]{0, 0, 0, 0};
                return result;
            }
            return ColorTableOperation.this.getInputColorInterpretation().getPalette().getRGBA(value);
        }
    }

    private class FloatRowProcessor
    extends AbstractRowProcessor {
        @Override
        public void processRow(Object inputRow, List outputRows) {
            float[] inputByteRow = (float[])inputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                byte[] rgb = this.processValue(Float.valueOf(inputByteRow[i]));
                for (int band = 0; band < outputRows.size(); ++band) {
                    ((byte[])outputRows.get((int)band))[i] = rgb[band];
                }
            }
        }

        @Override
        public byte[] processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                byte[] result = new byte[]{0, 0, 0, 0};
                return result;
            }
            return ColorTableOperation.this.getInputColorInterpretation().getPalette().getRGBA(value);
        }
    }

    private class IntRowProcessor
    extends AbstractRowProcessor {
        @Override
        public void processRow(Object inputRow, List outputRows) {
            int[] inputByteRow = (int[])inputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                byte[] rgb = this.processValue(inputByteRow[i]);
                for (int band = 0; band < outputRows.size(); ++band) {
                    ((byte[])outputRows.get((int)band))[i] = rgb[band];
                }
            }
        }

        @Override
        public byte[] processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                byte[] result = new byte[]{0, 0, 0, 0};
                return result;
            }
            return ColorTableOperation.this.getInputColorInterpretation().getPalette().getRGBA(value);
        }
    }

    private class UShortRowProcessor
    extends AbstractRowProcessor {
        @Override
        public void processRow(Object inputRow, List outputRows) {
            short[] inputByteRow = (short[])inputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                byte[] rgb = this.processValue(inputByteRow[i]);
                for (int band = 0; band < outputRows.size(); ++band) {
                    ((byte[])outputRows.get((int)band))[i] = rgb[band];
                }
            }
        }

        @Override
        public byte[] processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                byte[] result = new byte[]{0, 0, 0, 0};
                return result;
            }
            return ColorTableOperation.this.getInputColorInterpretation().getPalette().getRGBA((Object)(0xFFFF & (Byte)value));
        }
    }

    private class ShortRowProcessor
    extends AbstractRowProcessor {
        @Override
        public void processRow(Object inputRow, List outputRows) {
            short[] inputByteRow = (short[])inputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                byte[] rgb = this.processValue(inputByteRow[i]);
                for (int band = 0; band < outputRows.size(); ++band) {
                    ((byte[])outputRows.get((int)band))[i] = rgb[band];
                }
            }
        }

        @Override
        public byte[] processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                byte[] result = new byte[]{0, 0, 0, 0};
                return result;
            }
            return ColorTableOperation.this.getInputColorInterpretation().getPalette().getRGBA(value);
        }
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        @Override
        public void processRow(Object inputRow, List outputRows) {
            byte[] inputByteRow = (byte[])inputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                byte[] rgb = this.processValue(inputByteRow[i]);
                for (int band = 0; band < outputRows.size(); ++band) {
                    ((byte[])outputRows.get((int)band))[i] = rgb[band];
                }
            }
        }

        @Override
        public byte[] processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                byte[] result = new byte[]{0, 0, 0, 0};
                return result;
            }
            return ColorTableOperation.this.getInputColorInterpretation().getPalette().getRGBA((Object)(0xFF & (Byte)value));
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        NoData noData;

        public AbstractRowProcessor() {
            this.noData = ColorTableOperation.this.getInputBuffer().getBand(ColorTableOperation.this.getInputColorInterpretation().getPaletteBand()).getNoData();
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, List var2);

        public byte[] processValue(Object var1);
    }
}

