/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.grayscale;

import java.util.ArrayList;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.spi.AbstractColoredOperation;

public class GrayScaleOperation
extends AbstractColoredOperation {
    public GrayScaleOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        try {
            if (!this.getInputColorInterpretation().hasAnyRGBBand() && !this.getInputColorInterpretation().hasAnyGrayBand()) {
                throw new UnsupportedOperationException("The color interpretation of input buffer isn't RGB nor GRAYSCALE");
            }
            int[] inputBandTypes = this.getInputBuffer().getBandTypes();
            if (this.getInputColorInterpretation().hasAnyRGBBand()) {
                if (this.getInputColorInterpretation().getBand("Red") >= 0 && inputBandTypes[this.getInputColorInterpretation().getBand("Red")] != 0 || this.getInputColorInterpretation().getBand("Green") >= 0 && inputBandTypes[this.getInputColorInterpretation().getBand("Green")] != 0 || this.getInputColorInterpretation().getBand("Blue") >= 0 && inputBandTypes[this.getInputColorInterpretation().getBand("Blue")] != 0) {
                    throw new UnsupportedOperationException("The type of bands isn't BYTE");
                }
            } else if (this.getInputColorInterpretation().hasAnyGrayBand()) {
                if (this.getInputColorInterpretation().getBand("Gray") >= 0 && inputBandTypes[this.getInputColorInterpretation().getBand("Gray")] != 0) {
                    throw new UnsupportedOperationException("The type of band gray isn't BYTE");
                }
            } else {
                throw new UnsupportedOperationException("The color interpretation of input buffer isn't RGB nor GRAYSCALE");
            }
            int sourceBands = this.getInputBuffer().getBandCount();
            NoData[] sourceNoDatas = this.getInputBuffer().getBandNoData();
            int[] sourceTypes = this.getInputBuffer().getBandTypes();
            ArrayList<String> colorInterpretations = new ArrayList<String>();
            ArrayList<NoData> noDatas = new ArrayList<NoData>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            colorInterpretations.add("Gray");
            types.add(0);
            noDatas.add(null);
            if (this.getInputColorInterpretation().hasAlphaBand()) {
                if (sourceTypes[this.getInputColorInterpretation().getAlphaBand()] != 0) {
                    throw new UnsupportedOperationException("The type of ALPHA band isn't BYTE");
                }
                colorInterpretations.add("Alpha");
                types.add(sourceTypes[this.getInputColorInterpretation().getAlphaBand()]);
                noDatas.add(sourceNoDatas[this.getInputColorInterpretation().getAlphaBand()]);
            }
            if (this.mustCopyUnprocessedBands()) {
                for (int band = 0; band < sourceBands; ++band) {
                    if (this.isProcessableBand(band) || this.getInputColorInterpretation().isAlphaInterpretation(band)) continue;
                    colorInterpretations.add(this.getInputColorInterpretation().get(band));
                    noDatas.add(sourceNoDatas[band]);
                    types.add(this.getInputBuffer().getBandTypes()[band]);
                }
            }
            this.setOutputColorInterpretation(legendManager.createColorInterpretation(colorInterpretations));
            this.setParameter("output_color_interpretation", this.getOutputColorInterpretation());
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getTypesAsArray(types), this.getNoDatasAsArray(noDatas), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (Exception e) {
            throw new ProcessingOperationException((Throwable)e);
        }
    }

    public void process() throws ProcessingOperationException {
        try {
            super.process();
            ArrayList<Integer> bandsToProcess = new ArrayList<Integer>();
            Band outputBufferBand = this.getOutputBuffer().getBand(0);
            boolean processed = false;
            if (this.mustCopyUnprocessedBands()) {
                int bands = this.getInputBuffer().getBandCount();
                int outBand = this.getInputColorInterpretation().hasAlphaBand() ? 2 : 1;
                for (int band = 0; band < bands; ++band) {
                    if (this.isProcessableBand(band)) {
                        if (this.getInputColorInterpretation().isGrayInterpretation(band)) {
                            outputBufferBand.copyFrom(this.getInputBuffer().getBand(band));
                            processed = true;
                            continue;
                        }
                        bandsToProcess.add(band);
                        continue;
                    }
                    if (this.getInputColorInterpretation().isAlphaInterpretation(band)) {
                        this.getOutputBuffer().getBand(this.getOutputColorInterpretation().getAlphaBand()).copyFrom(this.getInputBuffer().getBand(band));
                        continue;
                    }
                    this.getOutputBuffer().getBand(outBand).copyFrom(this.getInputBuffer().getBand(band));
                    ++outBand;
                }
            }
            if (!processed) {
                Object[] rowBandsBuffer = new Object[bandsToProcess.size()];
                for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                    for (int i = 0; i < bandsToProcess.size(); ++i) {
                        Integer band = (Integer)bandsToProcess.get(i);
                        if (!this.isProcessableBand(band)) continue;
                        Band bufferBand = this.getInputBuffer().getBand(band.intValue());
                        rowBandsBuffer[i] = bufferBand.createRowBuffer();
                        bufferBand.fetchRow(row, rowBandsBuffer[i]);
                    }
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    this.processRow(rowBandsBuffer, outputRowBuffer);
                    outputBufferBand.putRow(row, outputRowBuffer);
                }
            }
        }
        catch (Exception e) {
            throw new ProcessingOperationException((Throwable)e);
        }
    }

    protected boolean isProcessableBand(int band) {
        return this.isRGBorGrayBand(band) && this.getInputBuffer().getBandTypes()[band] == 0;
    }

    private boolean isRGBorGrayBand(int band) {
        String bandColorInterpretation = this.getInputColorInterpretation().get(band);
        return bandColorInterpretation.equals("Red") || bandColorInterpretation.equals("Green") || bandColorInterpretation.equals("Blue") || bandColorInterpretation.equals("Gray");
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private void processRow(Object[] inputRows, Object outputRow) {
        byte[][] inputByteRows = new byte[inputRows.length][((byte[])inputRows[0]).length];
        for (int i = 0; i < inputRows.length; ++i) {
            inputByteRows[i] = (byte[])inputRows[i];
        }
        byte[] outputByteRow = (byte[])outputRow;
        for (int i = 0; i < inputByteRows[0].length; ++i) {
            int tmp = 0;
            for (int band = 0; band < inputRows.length; ++band) {
                tmp += 0xFF & Byte.valueOf(inputByteRows[band][i]);
            }
            outputByteRow[i] = (byte)(tmp / inputRows.length);
        }
    }
}

