/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.lib.impl;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.xml2db.lib.impl.Xml2dbCommons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CopyXML2dbImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyXML2dbImpl.class);

    public void copyData(InputSource is, JDBCServerExplorerParameters dbparams, long countLines, final String tablesPrefix, final SimpleTaskStatus taskStatus) {
        if (is == null || is.getCharacterStream() == null) {
            throw new IllegalArgumentException("reader is null");
        }
        DataManager dataManager = DALLocator.getDataManager();
        JDBCServerExplorer explorer = null;
        try {
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(dbparams.getProviderName(), (DataServerExplorerParameters)dbparams);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't open target database", ex);
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        final MutableInt line = new MutableInt(0);
        final MutableInt column = new MutableInt(0);
        DataTransaction trans = dataManager.createTransaction();
        try {
            trans.add((DataServerExplorer)explorer);
            taskStatus.message(i18n.getTranslation("_Copying"));
            taskStatus.setRangeOfValues(0L, countLines);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            final ArrayList path = new ArrayList();
            final HashMap<String, TableInfo> tables = new HashMap<String, TableInfo>();
            for (DataStoreParameters openStoreParams0 : explorer.list()) {
                JDBCStoreParameters openStoreParams = (JDBCStoreParameters)openStoreParams0;
                TableInfo table = new TableInfo(tables, openStoreParams, trans);
                tables.put(table.getTableName().toLowerCase(), table);
            }
            saxParser.parse(is, new DefaultHandler(){
                private Locator locator;
                private StringBuilder valueBuilder;
                int refreshInterval = 1;

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    line.setValue(this.locator.getLineNumber());
                    column.setValue(this.locator.getColumnNumber() - 2 - localName.length());
                    if (line.intValue() % this.refreshInterval == 0) {
                        taskStatus.setCurValue((long)line.intValue());
                    }
                    if (line.intValue() > 100000) {
                        this.refreshInterval = 10000;
                    } else if (line.intValue() > 10000) {
                        this.refreshInterval = 1000;
                    } else if (line.intValue() > 1000) {
                        this.refreshInterval = 100;
                    } else if (line.intValue() > 100) {
                        this.refreshInterval = 10;
                    }
                    try {
                        path.add(localName);
                        String path_s = StringUtils.join((Iterable)path, (String)"/");
                        TableInfo table1 = CopyXML2dbImpl.this.getTableByPath(tablesPrefix, tables, path_s);
                        if (table1 != null) {
                            String parentPath_s = StringUtils.removeEnd((String)FilenameUtils.getPath((String)path_s), (String)"/");
                            TableInfo parentTable1 = CopyXML2dbImpl.this.getTableByPath(tablesPrefix, tables, parentPath_s);
                            table1.createRow();
                            if (parentTable1 != null && parentTable1.featureType.get(localName) != null) {
                                parentTable1.current_row().set(localName, table1.getPkValue());
                            }
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                String name = attributes.getLocalName(i);
                                String value = attributes.getValue(i);
                                table1.set(name, value);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't process startElement (line " + line + ", column " + column + ")", (Throwable)ex);
                    }
                    this.valueBuilder = null;
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    line.setValue(this.locator.getLineNumber());
                    column.setValue(this.locator.getColumnNumber() - 2 - localName.length());
                    try {
                        String path_s = StringUtils.join((Iterable)path, (String)"/");
                        TableInfo table1 = CopyXML2dbImpl.this.getTableByPath(tablesPrefix, tables, path_s);
                        if (table1 != null) {
                            String value;
                            if (this.valueBuilder != null && (value = StringUtils.trimToNull((String)this.valueBuilder.toString())) != null) {
                                table1.set(localName + "$v", value);
                            }
                            table1.insert();
                        } else if (path.size() > 1) {
                            String value;
                            List parentpath = path.subList(0, path.size() - 1);
                            String parentpath_s = StringUtils.join(parentpath, (String)"/");
                            String attrname = FilenameUtils.getBaseName((String)path_s);
                            TableInfo table2 = CopyXML2dbImpl.this.getTableByPath(tablesPrefix, tables, parentpath_s);
                            if (table2 != null && this.valueBuilder != null && (value = StringUtils.trimToNull((String)this.valueBuilder.toString())) != null) {
                                table2.set(attrname, value);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't process endElement (line " + line + ", column " + column + ")", (Throwable)ex);
                    }
                    this.valueBuilder = null;
                    path.remove(path.size() - 1);
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    line.setValue(this.locator.getLineNumber());
                    if (this.valueBuilder == null) {
                        this.valueBuilder = new StringBuilder();
                    }
                    this.valueBuilder.append(ch, start, length);
                }
            });
            for (TableInfo table : tables.values()) {
                table.close();
            }
            trans.commit();
        }
        catch (Exception ex) {
            DataTransaction.rollbackQuietly((DataTransaction)trans);
            throw new RuntimeException("Can't copy data (line " + line + ", column " + column + ").", ex);
        }
        finally {
            DataTransaction.close((DataTransaction)trans);
        }
    }

    private TableInfo getTableByPath(String tablesPrefix, Map<String, TableInfo> tables, String path) {
        for (TableInfo table : tables.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)tablesPrefix, (CharSequence)table.getTablePrefix()) || !StringUtils.equalsIgnoreCase((CharSequence)path, (CharSequence)table.getPath())) continue;
            return table;
        }
        return null;
    }

    public void copyData(File xml, Charset charset, JDBCServerExplorerParameters dbparams, String tablesPrefix, SimpleTaskStatus taskStatus) {
        long count = Xml2dbCommons.countLines(xml, charset, taskStatus);
        InputSource is = Xml2dbCommons.openReader(xml, charset);
        this.copyData(is, dbparams, count, tablesPrefix, taskStatus);
    }

    public void copyData(InputStream xml, Charset charset, JDBCServerExplorerParameters dbparams, String tablesPrefix, SimpleTaskStatus taskStatus) {
        long count = -1L;
        InputSource is = Xml2dbCommons.openReader(xml, charset);
        this.copyData(is, dbparams, count, tablesPrefix, taskStatus);
    }

    private static class TableInfo {
        private final Map<String, TableInfo> tables;
        private final JDBCStoreParameters openStoreParams;
        private final String tableName;
        private FeatureStore store;
        private EditableFeature current_row;
        private int pkcounter;
        private EditableFeature last_row;
        private FeatureType featureType;
        private DataTransaction transaction;

        private TableInfo(Map<String, TableInfo> tables, JDBCStoreParameters openStoreParams, DataTransaction transaction) {
            this.tables = tables;
            this.openStoreParams = openStoreParams;
            this.tableName = openStoreParams.getTable();
            this.pkcounter = -1;
            this.transaction = transaction;
            FeatureStore theStore = null;
            try {
                DataManager dataManager = DALLocator.getDataManager();
                theStore = (FeatureStore)dataManager.openStore(this.openStoreParams.getProviderName(), (DataStoreParameters)openStoreParams);
                this.featureType = theStore.getDefaultFeatureTypeQuietly();
            }
            catch (Throwable t) {
                try {
                    throw new RuntimeException("Can't get path from store '" + this.getTableName() + "'.", t);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(theStore);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)theStore);
        }

        private int getNextPkValue() {
            int n;
            FeatureStore theStore;
            block5: {
                Object x;
                theStore = null;
                DataManager dataManager = DALLocator.getDataManager();
                theStore = (FeatureStore)dataManager.openStore(this.openStoreParams.getProviderName(), (DataStoreParameters)this.openStoreParams);
                FeatureQuery query = theStore.createFeatureQuery();
                String pkName = this.featureType.getPrimaryKey()[0].getName();
                query.addAggregate("MAX", pkName);
                Feature f = theStore.findFirst(query);
                if (f == null || (x = f.get(pkName)) == null) break block5;
                int n2 = ((Number)x).intValue() + 1;
                DisposeUtils.disposeQuietly((Disposable)theStore);
                return n2;
            }
            try {
                n = 1;
            }
            catch (Throwable t) {
                try {
                    throw new RuntimeException("Can't get path from store '" + this.getTableName() + "'.", t);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(theStore);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)theStore);
            return n;
        }

        public void close() {
            try {
                this.insert();
                if (this.store != null) {
                    this.store.finishEditing();
                    DisposeUtils.dispose((Disposable)this.store);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Can't close table '" + this.getTableName() + "'.", t);
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public FeatureStore getStore() {
            if (this.store == null) {
                try {
                    DataManager dataManager = DALLocator.getDataManager();
                    this.store = (FeatureStore)dataManager.openStore(this.transaction, this.openStoreParams.getProviderName(), (DataStoreParameters)this.openStoreParams);
                    this.store.edit(2);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Can't open and start edit store '" + this.getTableName() + "'.", t);
                }
            }
            return this.store;
        }

        public EditableFeature current_row() {
            return this.current_row;
        }

        private void createRow() {
            try {
                if (this.pkcounter < 0) {
                    this.pkcounter = this.getNextPkValue();
                }
                FeatureStore theStore = this.getStore();
                this.last_row = this.current_row = theStore.createNewFeature();
                FeatureType ft = this.current_row.getType();
                for (FeatureAttributeDescriptor attrdesc : ft) {
                    ForeingKey fk;
                    TableInfo table;
                    if (attrdesc.isPrimaryKey()) {
                        this.set(attrdesc.getName(), this.pkcounter++);
                        continue;
                    }
                    if (!attrdesc.isForeingKey() || !StringUtils.startsWith((CharSequence)attrdesc.getName(), (CharSequence)"$ID_") || (table = this.tables.get((fk = attrdesc.getForeingKey()).getTableName().toLowerCase())) == null) continue;
                    this.set(attrdesc.getName(), table.getPkValue());
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Can't create feature of store '" + this.getTableName() + "'.", t);
            }
        }

        private void set(String name, Object value) {
            if (this.current_row != null) {
                try {
                    if (this.current_row.getType().get(name) == null) {
                        LOGGER.info("Not exists attribute '" + name + "' in " + this.getStore().getName());
                        throw new IllegalArgumentException("Not exists attribute '" + name + "' in " + this.getStore().getName());
                    }
                    this.current_row.set(name, value);
                }
                catch (RuntimeException ex) {
                    LOGGER.info("Can't set attribute '" + name + "' in " + this.getStore().getName());
                    throw ex;
                }
            }
        }

        private void insert() {
            if (this.store != null && this.current_row != null) {
                try {
                    this.store.insert(this.current_row);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Can't insert feature into store '" + this.getTableName() + "'.", t);
                }
            }
            this.current_row = null;
        }

        private Object getPkValue() {
            if (this.last_row == null) {
                return null;
            }
            FeatureAttributeDescriptor[] attrdescs = this.last_row.getType().getPrimaryKey();
            return this.last_row.get(attrdescs[0].getName());
        }

        public String getPath() {
            return this.featureType.getTags().getString("xml2db.path", null);
        }

        public String getTablePrefix() {
            return this.featureType.getTags().getString("xml2db.tableprefix", null);
        }

        public boolean containsAttr(String attrname) {
            return this.featureType.get(attrname) != null;
        }
    }
}

