/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.additionalResults;

import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.IteratorException;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TableTools {
    public static JScrollPane getScrollableTablePanelFromITable(IDataObject obj) {
        JScrollPane jScrollPane = new JScrollPane();
        JTable jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        TableModel model = TableTools.getTableModel(obj);
        if (model != null) {
            jTable.setModel(model);
        }
        jTable.setEnabled(false);
        return jScrollPane;
    }

    private static TableModel getTableModel(IDataObject obj) {
        Object[] fields;
        int iCount;
        DefaultTableModel model = new DefaultTableModel();
        if (obj instanceof ITable) {
            iCount = (int)((ITable)obj).getRecordCount();
            fields = ((ITable)obj).getFieldNames();
        } else if (obj instanceof IVectorLayer) {
            iCount = ((IVectorLayer)obj).getShapesCount();
            fields = ((IVectorLayer)obj).getFieldNames();
        } else {
            return null;
        }
        Object[][] data2 = new String[iCount][fields.length];
        if (obj instanceof ITable) {
            IRecordsetIterator iter = ((ITable)obj).iterator();
            int i = 0;
            while (iter.hasNext()) {
                try {
                    IRecord record = iter.next();
                    for (int j = 0; j < fields.length; ++j) {
                        data2[i][j] = record.getValue(j).toString();
                    }
                    ++i;
                }
                catch (IteratorException e) {
                    e.printStackTrace();
                }
            }
        } else {
            IFeatureIterator iter = ((IVectorLayer)obj).iterator();
            int i = 0;
            while (iter.hasNext()) {
                try {
                    IFeature feature = iter.next();
                    for (int j = 0; j < fields.length; ++j) {
                        data2[i][j] = feature.getRecord().getValue(j).toString();
                    }
                    ++i;
                }
                catch (IteratorException e) {
                    e.printStackTrace();
                }
            }
        }
        model.setDataVector(data2, fields);
        return model;
    }
}

