/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.gui.algorithm.GenericFileFilter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class FileSelectionComboPanel
extends JPanel {
    private JComboBox comboBox;
    private JButton button;
    private final String[] m_sExtensions;
    private boolean m_bFolder = false;
    private boolean m_bOpen = false;
    private final String m_sDescription;
    private String m_sSelected = null;

    public FileSelectionComboPanel(boolean bFolder, boolean bOpen, String[] sExts, String sDescription) {
        this.m_bFolder = bFolder;
        this.m_bOpen = bOpen;
        this.m_sExtensions = sExts;
        this.m_sDescription = sDescription;
        this.initGUI();
    }

    public FileSelectionComboPanel(boolean bFolder, boolean bOpen, String sExt, String sDescription) {
        this(bFolder, bOpen, new String[]{sExt}, sDescription);
    }

    public FileSelectionComboPanel(boolean bFolder, boolean bOpen, String sExt, String sDescription, String sSelection) {
        this(bFolder, bOpen, new String[]{sExt}, sDescription);
        this.m_sSelected = sSelection;
    }

    public FileSelectionComboPanel(boolean bFolder, boolean bOpen, String[] sExt, String sDescription, String sSelection) {
        this(bFolder, bOpen, sExt, sDescription);
        this.m_sSelected = sSelection;
    }

    private void initGUI() {
        this.button = new JButton("...");
        this.comboBox = new JComboBox();
        this.comboBox.setMaximumSize(new Dimension(340, 18));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectionComboPanel.this.btnActionPerformed();
            }
        });
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0, 25.0}, {-1.0}});
        this.setLayout((LayoutManager)thisLayout);
        this.add((Component)this.comboBox, "0,  0");
        this.add((Component)this.button, "1,  0");
    }

    public String getFilepath() {
        return (String)this.comboBox.getSelectedItem();
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public JButton getButton() {
        return this.button;
    }

    private void btnActionPerformed() {
        int returnVal;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(this.m_sDescription);
        if (this.m_bFolder) {
            fc.setFileSelectionMode(1);
        }
        if (this.m_sSelected != null) {
            fc.setSelectedFile(new File(this.m_sSelected));
        }
        if (this.m_sExtensions != null && !this.m_bFolder) {
            fc.setFileFilter(new GenericFileFilter(this.m_sExtensions, this.m_sDescription));
        }
        if ((returnVal = this.m_bOpen ? fc.showOpenDialog(this.getParent().getParent()) : fc.showSaveDialog(this.getParent().getParent())) == 0) {
            this.comboBox.setSelectedItem(fc.getSelectedFile().getAbsolutePath());
        }
    }

    public void setFilepath(String sFilepath) {
        this.comboBox.setSelectedItem(sFilepath);
    }

    @Override
    public void setToolTipText(String sText) {
        this.comboBox.setToolTipText(sText);
    }
}

