/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.WrongAnalysisExtentException;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.gui.algorithm.GenericFileFilter;
import es.unex.sextante.gui.batch.AnalysisExtentPanel;
import es.unex.sextante.gui.batch.BatchProcessMonitorableTask;
import es.unex.sextante.gui.batch.ParametersPanel;
import es.unex.sextante.gui.batch.ParametersTableModel;
import es.unex.sextante.gui.batch.TridimensionalAnalysisExtentPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.TooLargeGridExtentException;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class BatchProcessDialog
extends JDialog {
    private final GeoAlgorithm m_Algorithm;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonHelp;
    private ParametersPanel jParametersPanel;
    private JButton jButtonSave;
    private JButton jButtonOpen;
    private AnalysisExtentPanel jRasterExtentPanel;
    private JTabbedPane jTabbedPanel;
    private JLabel jLabelName;
    private final JDialog m_Parent;

    public BatchProcessDialog(GeoAlgorithm alg, JDialog parent) {
        super(parent, Sextante.getText((String)"Batch_processing"), true);
        this.m_Algorithm = alg;
        this.m_Parent = parent;
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    public BatchProcessDialog(GeoAlgorithm alg) {
        super(SextanteGUI.getMainFrame(), Sextante.getText((String)"Batch_processing"), true);
        this.setLocationRelativeTo(null);
        this.m_Algorithm = alg;
        this.m_Parent = null;
        this.initGUI();
    }

    private void initGUI() {
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{5.0, 70.0, -1.0, 100.0, 100.0, -1.0, 5.0, 100.0, 100.0, 5.0}, {5.0, 20.0, 5.0, -1.0, 5.0, 25.0, 5.0}});
            this.getContentPane().setLayout((LayoutManager)thisLayout);
            this.setPreferredSize(new Dimension(800, 600));
            this.setSize(new Dimension(800, 600));
            this.jButtonHelp = new JButton();
            this.getContentPane().add((Component)this.jButtonHelp, "1, 5");
            this.jButtonHelp.setText(Sextante.getText((String)"Help"));
            this.jButtonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BatchProcessDialog.this.showHelp();
                }
            });
            this.jTabbedPanel = new JTabbedPane();
            this.getContentPane().add((Component)this.jTabbedPanel, "1, 3, 8, 3");
            this.jParametersPanel = new ParametersPanel(this.m_Algorithm);
            this.jTabbedPanel.addTab(Sextante.getText((String)"Parameters"), null, this.jParametersPanel, null);
            this.jParametersPanel.setPreferredSize(new Dimension(446, 225));
            if (this.m_Algorithm.getUserCanDefineAnalysisExtent()) {
                this.jRasterExtentPanel = this.m_Algorithm.is3D() ? new TridimensionalAnalysisExtentPanel(this.m_Algorithm) : new AnalysisExtentPanel(this.m_Algorithm);
                this.jTabbedPanel.addTab(Sextante.getText((String)"Raster_output"), null, this.jRasterExtentPanel, null);
            }
            this.jButtonOK = new JButton();
            this.getContentPane().add((Component)this.jButtonOK, "7, 5");
            this.jButtonOK.setText(Sextante.getText((String)"OK"));
            this.jButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BatchProcessDialog.this.executeBatchProcess();
                }
            });
            this.jButtonCancel = new JButton();
            this.getContentPane().add((Component)this.jButtonCancel, "8, 5");
            this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BatchProcessDialog.this.cancel();
                }
            });
            this.jLabelName = new JLabel(this.m_Algorithm.getName().toUpperCase());
            this.jLabelName.setFont(new Font("Tahoma", 1, 12));
            this.getContentPane().add((Component)this.jLabelName, "1, 1, 7, 1");
            this.jButtonOpen = new JButton();
            this.getContentPane().add((Component)this.jButtonOpen, "3, 5");
            this.jButtonOpen.setText(Sextante.getText((String)"Open"));
            this.jButtonOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BatchProcessDialog.this.open();
                }
            });
            this.jButtonSave = new JButton();
            this.getContentPane().add((Component)this.jButtonSave, "4, 5");
            this.jButtonSave.setText(Sextante.getText((String)"Save"));
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BatchProcessDialog.this.save();
                }
            });
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        ParametersTableModel table = this.jParametersPanel.getTableModel();
        JFileChooser fc = new JFileChooser();
        GenericFileFilter filter = new GenericFileFilter("csv", "Comma-Separated Values");
        fc.setFileFilter(filter);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            Writer output = null;
            try {
                output = new BufferedWriter(new FileWriter(file));
                int iRows = table.getRowCount();
                int iCols = table.getColumnCount();
                for (int iRow = 0; iRow < iRows; ++iRow) {
                    for (int iCol = 0; iCol < iCols; ++iCol) {
                        String s = table.getValueAt(iRow, iCol).toString();
                        output.write(s);
                        if (iCol >= iCols - 1) continue;
                        output.write("|");
                    }
                    output.write("\n");
                }
            }
            catch (IOException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
            }
        }
    }

    private void open() {
        try {
            JFileChooser fc = new JFileChooser();
            GenericFileFilter filter = new GenericFileFilter("csv", "Comma-Separated Values");
            fc.setFileFilter(filter);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                BufferedReader input = null;
                ParametersTableModel table = this.jParametersPanel.getTableModel();
                int iRows = table.getRowCount();
                input = new BufferedReader(new FileReader(file));
                String sLine = null;
                int i = 1;
                while ((sLine = input.readLine()) != null) {
                    if (i > iRows) {
                        table.addRow();
                    }
                    this.processLine(sLine, table, i - 1);
                    ++i;
                }
                input.close();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Sextante.getText((String)"Could_not_open_selected_file"), Sextante.getText((String)"Error"), 0);
        }
    }

    private void processLine(String line, ParametersTableModel table, int iRow) {
        try {
            String[] tokens = line.split("\\|");
            for (int i = 0; i < tokens.length; ++i) {
                table.setValueAt(tokens[i], iRow, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showHelp() {
        SextanteGUI.getGUIFactory().showHelpDialog("batch");
    }

    private void executeBatchProcess() {
        ArrayList param = new ArrayList();
        ArrayList output = new ArrayList();
        try {
            block6: {
                try {
                    this.assignParameters(param, output);
                }
                catch (TooLargeGridExtentException e) {
                    int iRet = JOptionPane.showConfirmDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 0);
                    if (iRet == 0) break block6;
                    this.jTabbedPanel.setSelectedIndex(1);
                    return;
                }
            }
            AnalysisExtent extent2 = null;
            if (this.jRasterExtentPanel != null) {
                extent2 = this.jRasterExtentPanel.getExtent();
            }
            BatchProcessMonitorableTask task = new BatchProcessMonitorableTask(this.m_Algorithm, param, output, extent2, this.m_Parent);
            Thread th = new Thread(task);
            th.start();
            this.cancel();
        }
        catch (WrongInputException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 2);
            this.jTabbedPanel.setSelectedIndex(0);
        }
        catch (WrongAnalysisExtentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 2);
            this.jTabbedPanel.setSelectedIndex(1);
        }
    }

    private void assignParameters(ArrayList param, ArrayList output) throws WrongInputException, WrongAnalysisExtentException, TooLargeGridExtentException {
        if (!this.jParametersPanel.assignParameters(param, output)) {
            throw new WrongInputException(Sextante.getText((String)"Wrong_or_missing_parameters_definition"));
        }
        if (this.m_Algorithm.getUserCanDefineAnalysisExtent()) {
            this.jRasterExtentPanel.adjustExtent();
        }
    }

    private void cancel() {
        this.dispose();
        this.setVisible(false);
    }
}

