/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch.nonFileBased;

import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.algorithm.FixedTableDialog;
import es.unex.sextante.gui.algorithm.GenericFileFilter;
import es.unex.sextante.gui.algorithm.MultipleInputSelectionDialog;
import es.unex.sextante.gui.batch.nonFileBased.AutoCompletePanel;
import es.unex.sextante.gui.batch.nonFileBased.ParameterCellPanelEditor;
import es.unex.sextante.gui.batch.nonFileBased.PointSelectionDialog;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ParameterCellPanel
extends JPanel {
    private JTextField textField;
    private JButton button;
    private final Object m_Object;
    private final JTable m_Table;
    private JComboBox comboBox;
    private Object m_Value;

    public ParameterCellPanel(Object obj, JTable table) {
        this.m_Object = obj;
        this.m_Table = table;
        this.initGUI();
    }

    private void initGUI() {
        this.button = new JButton("...");
        this.textField = new JTextField("");
        this.textField.setMaximumSize(new Dimension(340, 18));
        this.textField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                ParameterCellPanel.this.m_Value = ParameterCellPanel.this.textField.getText();
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                ParameterCellPanel.this.m_Value = ParameterCellPanel.this.textField.getText();
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterCellPanel.this.btnActionPerformed(evt);
            }
        });
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0, 25.0}, {-1.0}});
        this.setLayout((LayoutManager)thisLayout);
        if (this.m_Object instanceof ParameterString || this.m_Object instanceof ParameterNumericalValue || this.m_Object instanceof ParameterTableField) {
            this.add((Component)this.textField, "0, 0, 1, 0");
        } else if (this.m_Object instanceof ParameterDataObject) {
            this.comboBox = this.getDataObjectComboBox();
            this.add((Component)this.comboBox, "0, 0, 1, 0");
        } else {
            this.add((Component)this.textField, "0,  0");
            this.add((Component)this.button, "1,  0");
        }
    }

    private JComboBox getDataObjectComboBox() {
        IRasterLayer[] objs = null;
        try {
            if (this.m_Object instanceof ParameterRasterLayer) {
                objs = SextanteGUI.getInputFactory().getRasterLayers();
            } else if (this.m_Object instanceof Parameter3DRasterLayer) {
                objs = SextanteGUI.getInputFactory().get3DRasterLayers();
            } else if (this.m_Object instanceof ParameterVectorLayer) {
                AdditionalInfoVectorLayer ai = (AdditionalInfoVectorLayer)((ParameterVectorLayer)this.m_Object).getParameterAdditionalInfo();
                objs = SextanteGUI.getInputFactory().getVectorLayers(ai.getShapeType());
            } else if (this.m_Object instanceof ParameterTable) {
                objs = SextanteGUI.getInputFactory().getTables();
            }
        }
        catch (Exception ai) {
            // empty catch block
        }
        final JComboBox combo = new JComboBox(objs);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ParameterCellPanel.this.m_Table.getModel().setValueAt(combo.getSelectedItem(), ParameterCellPanel.this.m_Table.getSelectedRow(), ParameterCellPanel.this.m_Table.getSelectedColumn());
                ParameterCellPanel.this.m_Value = combo.getSelectedItem();
                ParameterCellPanel.this.textField.setText(combo.getSelectedItem().toString());
            }
        });
        return combo;
    }

    private void btnActionPerformed(ActionEvent e) {
        if (this.m_Object instanceof ParameterBand) {
            this.assignBand();
        } else if (this.m_Object instanceof ParameterPoint) {
            this.assignPoint();
        } else if (this.m_Object instanceof ParameterBoolean) {
            this.assignBoolean();
        } else if (this.m_Object instanceof ParameterFixedTable) {
            this.assignFixedTable();
        } else if (this.m_Object instanceof ParameterSelection) {
            this.assignSelection();
        } else if (this.m_Object instanceof ParameterMultipleInput) {
            this.assignMultipleInput();
        } else if (this.m_Object instanceof Output) {
            this.assignOutput();
        }
    }

    private void assignOutput() {
        String sDesc;
        String[] sExt;
        JFileChooser fc = new JFileChooser();
        if (this.m_Object instanceof OutputRasterLayer) {
            sExt = SextanteGUI.getOutputFactory().getRasterLayerOutputExtensions();
            sDesc = Sextante.getText((String)"Raster_layers");
        } else if (this.m_Object instanceof Output3DRasterLayer) {
            sExt = SextanteGUI.getOutputFactory().get3DRasterLayerOutputExtensions();
            sDesc = Sextante.getText((String)Sextante.getText((String)"3D_Raster_layers"));
        } else if (this.m_Object instanceof OutputVectorLayer) {
            sExt = SextanteGUI.getOutputFactory().getVectorLayerOutputExtensions();
            sDesc = Sextante.getText((String)"Vector_layer");
        } else if (this.m_Object instanceof OutputTable) {
            sExt = SextanteGUI.getOutputFactory().getTableOutputExtensions();
            sDesc = Sextante.getText((String)"Tables");
        } else {
            return;
        }
        fc.setFileFilter(new GenericFileFilter(sExt, sDesc));
        String[] sColumnNames = new String[this.m_Table.getColumnCount() - 1];
        int j = 0;
        for (int i = 0; i < sColumnNames.length; ++i) {
            if (i == this.m_Table.getSelectedColumn()) continue;
            sColumnNames[j] = this.m_Table.getColumnName(i);
            ++j;
        }
        fc.setAccessory(new AutoCompletePanel(sColumnNames));
        int returnVal = fc.showSaveDialog(this.getParent().getParent());
        if (returnVal == 0) {
            int i;
            String sFile = fc.getSelectedFile().getAbsolutePath();
            for (i = 0; i < sExt.length && !sFile.endsWith(sExt[i]); ++i) {
            }
            if (i == sExt.length) {
                sFile = sFile + "." + sExt[0];
            }
            int iRow = this.m_Table.getSelectedRow();
            int iCol = this.m_Table.getSelectedColumn();
            int iAutoFill = ((AutoCompletePanel)fc.getAccessory()).getAutoFill();
            if (iAutoFill == 1) {
                int iCount = 1;
                for (i = iRow; i < this.m_Table.getRowCount(); ++i) {
                    String sFile2 = sFile.substring(0, sFile.lastIndexOf(".")) + Integer.toString(iCount) + sFile.substring(sFile.lastIndexOf("."), sFile.length());
                    this.m_Table.setValueAt(sFile2, i, iCol);
                    ++iCount;
                    if (i != iRow) continue;
                    this.textField.setText(sFile2);
                }
            } else if (iAutoFill == 2) {
                int iField = ((AutoCompletePanel)fc.getAccessory()).getField();
                ParameterCellPanelEditor ce = (ParameterCellPanelEditor)this.m_Table.getCellEditor(0, iField);
                for (i = iRow; i < this.m_Table.getRowCount(); ++i) {
                    String sCellValue = this.m_Table.getValueAt(i, iField).toString();
                    if (ce.isFilenameCell() && !sCellValue.trim().equals("")) {
                        File f = new File(sCellValue);
                        sCellValue = f.getName().substring(0, f.getName().lastIndexOf("."));
                    }
                    String sFile2 = sFile.substring(0, sFile.lastIndexOf(".")) + sCellValue + sFile.substring(sFile.lastIndexOf("."), sFile.length());
                    this.m_Table.setValueAt(sFile2, i, iCol);
                    if (i != iRow) continue;
                    this.textField.setText(sFile2);
                }
            } else {
                this.textField.setText(sFile);
            }
            this.m_Table.setValueAt(this.textField.getText(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
            this.m_Value = this.textField.getText();
        }
    }

    private void assignMultipleInput() {
        ParameterMultipleInput parameter = (ParameterMultipleInput)this.m_Object;
        try {
            Object[] objs;
            AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
            switch (additionalInfo.getDataType()) {
                case 1: {
                    objs = SextanteGUI.getInputFactory().getRasterLayers();
                    break;
                }
                case 5: {
                    objs = SextanteGUI.getInputFactory().getVectorLayers(-1);
                    break;
                }
                case 2: {
                    objs = SextanteGUI.getInputFactory().getVectorLayers(0);
                    break;
                }
                case 3: {
                    objs = SextanteGUI.getInputFactory().getVectorLayers(0);
                    break;
                }
                case 4: {
                    objs = SextanteGUI.getInputFactory().getVectorLayers(0);
                    break;
                }
                case 6: {
                    objs = SextanteGUI.getInputFactory().getTables();
                    break;
                }
                case 7: {
                    objs = SextanteGUI.getInputFactory().getBands();
                    break;
                }
                default: {
                    return;
                }
            }
            ArrayList selectedIndices = new ArrayList();
            MultipleInputSelectionDialog dialog = new MultipleInputSelectionDialog(SextanteGUI.getMainFrame(), objs, selectedIndices);
            dialog.pack();
            dialog.setVisible(true);
            StringBuffer sText = new StringBuffer();
            int iCount = selectedIndices.size();
            sText.append(Integer.toString(iCount));
            if (iCount == 1) {
                sText.append(" " + Sextante.getText((String)"element_selected"));
            } else {
                sText.append(" " + Sextante.getText((String)"elements_selected"));
            }
            ArrayList<Object> selected = new ArrayList<Object>();
            for (int i = 0; i < selectedIndices.size(); ++i) {
                int iIndex = (Integer)selectedIndices.get(i);
                selected.add(objs[iIndex]);
            }
            this.m_Table.getModel().setValueAt(selected, this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
            this.m_Value = selected;
            this.textField.setText(sText.toString());
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void assignFixedTable() {
        FixedTableModel model = this.getTableModelFromString();
        FixedTableDialog dialog = new FixedTableDialog(SextanteGUI.getMainFrame(), model);
        dialog.pack();
        dialog.setVisible(true);
        this.textField.setText(model.getAsCSV());
        this.m_Table.setValueAt(this.textField.getText(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
        this.m_Value = this.textField.getText();
    }

    public FixedTableModel getTableModelFromString() {
        int iToken = 0;
        FixedTableModel tableModel = null;
        StringTokenizer st = new StringTokenizer(this.textField.getText(), ",");
        Parameter parameter = (Parameter)this.m_Object;
        try {
            AdditionalInfoFixedTable ai = (AdditionalInfoFixedTable)parameter.getParameterAdditionalInfo();
            int iCols = ai.getColsCount();
            int iRows = ai.getRowsCount();
            boolean bIsNumberOfRowsFixed = ai.isNumberOfRowsFixed();
            tableModel = new FixedTableModel(ai.getCols(), iCols, bIsNumberOfRowsFixed);
            if (bIsNumberOfRowsFixed ? st.countTokens() != iCols * iRows : iToken % iCols != 0) {
                return tableModel;
            }
            while (st.hasMoreTokens()) {
                int iCol = (int)Math.floor((double)iToken / (double)iCols);
                int iRow = iToken % iCols;
                String sToken = st.nextToken().trim();
                tableModel.setValueAt((Object)sToken, iCol, iRow);
                ++iToken;
            }
            return tableModel;
        }
        catch (Exception e) {
            return tableModel;
        }
    }

    private void assignBand() {
        int MAX_BANDS = 250;
        Object[] possibilities = new String[250];
        for (int i = 0; i < possibilities.length; ++i) {
            possibilities[i] = Integer.toString(i + 1);
        }
        String s = (String)JOptionPane.showInputDialog(null, Sextante.getText((String)"Band"), Sextante.getText((String)"Band"), -1, null, possibilities, possibilities[0]);
        if (s != null) {
            this.textField.setText(s);
            this.m_Table.setValueAt(this.textField.getText(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
            this.m_Value = this.textField.getText();
        }
    }

    private void assignPoint() {
        Frame window = new Frame();
        Point2D.Double pt = new Point2D.Double();
        PointSelectionDialog dialog = new PointSelectionDialog(window, pt);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getOK()) {
            this.textField.setText(Double.toString(((Point2D)pt).getX()) + "," + Double.toString(((Point2D)pt).getY()));
            this.m_Table.setValueAt(this.textField.getText(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
            this.m_Value = this.textField.getText();
        }
    }

    private void assignSelection() {
        Parameter parameter = (Parameter)this.m_Object;
        try {
            AdditionalInfoSelection ai = (AdditionalInfoSelection)parameter.getParameterAdditionalInfo();
            Object[] possibilities = ai.getValues();
            String s = (String)JOptionPane.showInputDialog(null, parameter.getParameterDescription(), parameter.getParameterDescription(), -1, null, possibilities, possibilities[0]);
            if (s != null) {
                this.textField.setText(s);
                this.m_Table.setValueAt(this.textField.getText(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
                this.m_Value = this.textField.getText();
            }
        }
        catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
            // empty catch block
        }
    }

    private void assignBoolean() {
        Parameter parameter = (Parameter)this.m_Object;
        Object[] possibilities = new String[]{Sextante.getText((String)"Yes"), Sextante.getText((String)"No")};
        String s = (String)JOptionPane.showInputDialog(null, parameter.getParameterDescription(), parameter.getParameterDescription(), -1, null, possibilities, Sextante.getText((String)"Yes"));
        if (s != null) {
            if (s.equals(Sextante.getText((String)"Yes"))) {
                this.textField.setText("true");
            } else {
                this.textField.setText("false");
            }
            this.m_Table.setValueAt(this.textField.getText(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
            this.m_Value = this.textField.getText();
        }
    }

    public Object getValue() {
        return this.m_Value;
    }

    public void setValue(Object obj) {
        this.m_Value = obj;
        this.textField.setText(obj.toString());
    }

    public boolean isFilenameCell() {
        return this.m_Object instanceof ParameterDataObject || !(this.m_Object instanceof Parameter);
    }
}

