/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.gui.history.History;
import es.unex.sextante.gui.modeler.AlgorithmCellRenderer;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.gui.modeler.ModelerPanel;
import es.unex.sextante.gui.toolbox.AlgorithmGroupConfiguration;
import es.unex.sextante.gui.toolbox.AlgorithmGroupsOrganizer;
import es.unex.sextante.modeler.elements.ModelElement3DRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementPoint;
import es.unex.sextante.modeler.elements.ModelElementRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementTable;
import es.unex.sextante.modeler.elements.ModelElementVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterMultipleInput;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AlgorithmsPanel
extends JPanel {
    private int m_iAlgorithm = 0;
    private final HashMap m_DataObjects;
    private ModelAlgorithm m_Algorithm;
    private JTree jTree;
    private JScrollPane jScrollPane;
    private JButton jButtonSearch;
    private JTextField jTextFieldSearch;
    private final ModelerPanel m_ModelerPanel;
    private final JDialog m_Parent;

    public AlgorithmsPanel(ModelerPanel modelerPanel, JDialog parent) {
        this.m_DataObjects = modelerPanel.getDataObjects();
        this.m_ModelerPanel = modelerPanel;
        this.m_Parent = parent;
        this.initGUI();
    }

    private void initGUI() {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{3.0, -1.0, 65.0, 3.0}, {-1.0, -3.0, 3.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setLayout((LayoutManager)thisLayout);
        this.jTree = new JTree();
        this.jTree.setCellRenderer(new AlgorithmCellRenderer(this));
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path = AlgorithmsPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                if (e.getClickCount() == 2) {
                    AlgorithmsPanel.this.addSelectedProcess(path);
                }
            }
        };
        this.jTree.addMouseListener(ml);
        this.fillTree(null, false);
        this.jScrollPane = new JScrollPane(this.jTree, 20, 30);
        this.jScrollPane.setPreferredSize(new Dimension(200, 294));
        this.add((Component)this.jScrollPane, "0, 0, 3, 0");
        this.add((Component)this.getJTextFieldSearch(), "1, 1");
        this.add((Component)this.getJButtonSearch(), "2, 1");
    }

    public void fillTree(String sSearchString, boolean bSearchInHelpFiles) {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"Algorithms"));
        HashMap groups = new HashMap();
        HashMap algs2 = Sextante.getAlgorithms();
        Set groupKeys = algs2.keySet();
        for (String groupKey : groupKeys) {
            HashMap groupAlgs = (HashMap)algs2.get(groupKey);
            Set keys = groupAlgs.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                HashMap<String, DefaultMutableTreeNode> subgroup;
                String sSubgroup;
                String sGroup;
                GeoAlgorithm alg = (GeoAlgorithm)groupAlgs.get(iter.next());
                if (!alg.isSuitableForModelling() || (!bSearchInHelpFiles ? sSearchString != null && !alg.getName().toLowerCase().contains(sSearchString) : !HelpIO.containsStringInHelpFile(alg, sSearchString))) continue;
                AlgorithmGroupConfiguration conf = AlgorithmGroupsOrganizer.getGroupConfiguration(alg);
                if (conf != null) {
                    if (!conf.isShow()) continue;
                    sGroup = conf.getGroup();
                    sSubgroup = conf.getSubgroup();
                } else {
                    sGroup = groupKey;
                    sSubgroup = alg.getGroup();
                }
                HashMap<String, HashMap<String, DefaultMutableTreeNode>> group = (HashMap<String, HashMap<String, DefaultMutableTreeNode>>)groups.get(sGroup);
                if (group == null) {
                    group = new HashMap<String, HashMap<String, DefaultMutableTreeNode>>();
                    groups.put(sGroup, group);
                }
                if ((subgroup = (HashMap<String, DefaultMutableTreeNode>)group.get(sSubgroup)) == null) {
                    subgroup = new HashMap<String, DefaultMutableTreeNode>();
                    group.put(sSubgroup, subgroup);
                }
                subgroup.put(alg.getName(), new DefaultMutableTreeNode(alg));
            }
        }
        Set set = groups.keySet();
        for (String sKey : set) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(sKey);
            this.addNodeInSortedOrder(mainNode, node);
            HashMap g = (HashMap)groups.get(sKey);
            Set set2 = g.keySet();
            for (String sKey2 : set2) {
                DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(sKey2);
                this.addNodeInSortedOrder(node, node2);
                HashMap g2 = (HashMap)g.get(sKey2);
                Set set3 = g2.keySet();
                for (String sKey3 : set3) {
                    DefaultMutableTreeNode node3 = (DefaultMutableTreeNode)g2.get(sKey3);
                    this.addNodeInSortedOrder(node2, node3);
                }
            }
        }
        boolean bShowMostRecent = new Boolean(SextanteGUI.getSettingParameterValue("ShowMostRecent"));
        if (bShowMostRecent) {
            GeoAlgorithm[] recent = History.getRecentlyUsedAlgs();
            DefaultMutableTreeNode recentNode = new DefaultMutableTreeNode(Sextante.getText((String)"RecentAlgorithms"));
            for (int i = 0; i < recent.length; ++i) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(recent[i]);
                recentNode.add(node);
            }
            mainNode.insert(recentNode, 0);
        }
        this.jTree.setModel(new DefaultTreeModel(mainNode));
        this.collapseAll();
    }

    public JTree getTree() {
        return this.jTree;
    }

    private void addNodeInSortedOrder(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int n = parent.getChildCount();
        if (n == 0) {
            parent.add(child);
            return;
        }
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        DefaultMutableTreeNode node = null;
        for (int i = 0; i < n; ++i) {
            node = (DefaultMutableTreeNode)parent.getChildAt(i);
            try {
                if (collator.compare(node.toString(), child.toString()) <= 0) continue;
                parent.insert(child, i);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        parent.add(child);
    }

    public void setAlgorithm(ModelAlgorithm alg) {
        this.m_Algorithm = alg;
    }

    private void addSelectedProcess(TreePath path) {
        block6: {
            if (path == null) {
                return;
            }
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof String)) {
                    GeoAlgorithm alg = (GeoAlgorithm)node.getUserObject();
                    if (this.isAlgorithmEnabled(alg)) {
                        String sName = this.getValidName();
                        String sDescription = Sextante.getText((String)"Algorithm") + " " + Integer.toString(this.m_iAlgorithm) + ": " + alg.getName();
                        int iRet = SextanteGUI.getGUIFactory().showAlgorithmDialogForModeler(alg, sName, sDescription, this.m_Algorithm, this.m_DataObjects, this.m_Parent);
                        if (iRet == 1) {
                            ++this.m_iAlgorithm;
                            this.m_ModelerPanel.setHasChanged(true);
                            this.m_ModelerPanel.getGraph().storeCoords();
                            this.m_ModelerPanel.getGraph().addAlgorithm(sName);
                            this.m_ModelerPanel.updatePanel(true);
                        }
                    }
                    break block6;
                }
                return;
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    public boolean isAlgorithmEnabled(GeoAlgorithm alg) {
        boolean bAllRequirementsMet;
        boolean bRequiresRasterLayers = alg.requiresRasterLayers();
        boolean bRequires3DRasterLayers = alg.requires3DRasterLayers();
        boolean bRequiresVectorLayers = alg.requiresVectorLayers();
        boolean bRequiresTables = alg.requiresTables();
        boolean bRequiresPoints = alg.requiresPoints();
        boolean bRequiresPointLayers = alg.requiresPointVectorLayers();
        boolean bRequiresLineLayers = alg.requiresLineVectorLayers();
        boolean bRequiresPolygonLayers = alg.requiresPolygonVectorLayers();
        boolean bTableRequirementsMet = !bRequiresTables;
        boolean bRasterRequirementsMet = !bRequiresRasterLayers;
        boolean b3DRasterRequirementsMet = !bRequires3DRasterLayers;
        boolean bVectorRequirementsMet = !bRequiresVectorLayers;
        boolean bPointRequirementsMet = !bRequiresPoints;
        boolean bPolygonLayerRequirementsMet = !bRequiresPolygonLayers;
        boolean bLineLayerRequirementsMet = !bRequiresLineLayers;
        boolean bPointLayerRequirementsMet = !bRequiresPointLayers;
        Set set = this.m_DataObjects.keySet();
        Iterator iter = set.iterator();
        boolean bl = bAllRequirementsMet = bRasterRequirementsMet && b3DRasterRequirementsMet && bVectorRequirementsMet && bTableRequirementsMet && bPointRequirementsMet && bPolygonLayerRequirementsMet && bLineLayerRequirementsMet && bPointLayerRequirementsMet;
        while (iter.hasNext() && !bAllRequirementsMet) {
            String sKey = (String)iter.next();
            ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
            if (oad.getObject() != null) {
                Class<?> dataClass = oad.getObject().getClass();
                if (dataClass == ModelElementRasterLayer.class && this.isParameterMandatory(sKey)) {
                    bRasterRequirementsMet = true;
                }
                if (dataClass == ModelElement3DRasterLayer.class && this.isParameterMandatory(sKey)) {
                    b3DRasterRequirementsMet = true;
                }
                if (dataClass == ModelElementPoint.class) {
                    bPointRequirementsMet = true;
                }
                if (dataClass == ModelElementVectorLayer.class) {
                    if (this.isParameterMandatory(sKey)) {
                        ModelElementVectorLayer mevl = (ModelElementVectorLayer)oad.getObject();
                        bVectorRequirementsMet = true;
                        switch (mevl.getShapeType()) {
                            case 1: {
                                bLineLayerRequirementsMet = true;
                                break;
                            }
                            case 0: {
                                bPointLayerRequirementsMet = true;
                                break;
                            }
                            case 2: {
                                bPolygonLayerRequirementsMet = true;
                                break;
                            }
                        }
                    }
                } else if (dataClass == ModelElementTable.class && this.isParameterMandatory(sKey)) {
                    bTableRequirementsMet = true;
                }
                bAllRequirementsMet = bRasterRequirementsMet && bVectorRequirementsMet && bTableRequirementsMet && bPointRequirementsMet && bPolygonLayerRequirementsMet && bLineLayerRequirementsMet && bPointLayerRequirementsMet;
                continue;
            }
            System.out.println("SEXTANTE: AlgorithmsPanel.java: isAlgorithmEnabled(): Got NULL object.");
            bAllRequirementsMet = false;
        }
        return bAllRequirementsMet;
    }

    private boolean isParameterMandatory(String sKey) {
        Parameter param;
        ParametersSet ps = this.m_Algorithm.getParameters();
        try {
            param = ps.getParameter(sKey);
        }
        catch (WrongParameterIDException e) {
            return true;
        }
        if (param != null) {
            if (param instanceof ParameterDataObject) {
                try {
                    AdditionalInfoDataObject additionalInfo = (AdditionalInfoDataObject)((ParameterDataObject)param).getParameterAdditionalInfo();
                    return additionalInfo.getIsMandatory();
                }
                catch (NullParameterAdditionalInfoException e) {
                    return false;
                }
            }
            if (param instanceof ParameterMultipleInput) {
                try {
                    AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)((ParameterMultipleInput)param).getParameterAdditionalInfo();
                    return additionalInfo.getIsMandatory();
                }
                catch (NullParameterAdditionalInfoException e) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    public String getValidName() {
        String sName;
        boolean bFound;
        int i = 0;
        do {
            sName = "PROC" + Integer.toString(i);
            if (this.m_Algorithm.getAlgorithmKeys().contains(sName)) {
                ++i;
                bFound = false;
                continue;
            }
            bFound = true;
        } while (!bFound);
        return sName;
    }

    public void addSelectedProcess() {
        this.addSelectedProcess(this.jTree.getSelectionPath());
    }

    public void setAlgorithmCount(int iCount) {
        this.m_iAlgorithm = iCount;
    }

    private JTextField getJTextFieldSearch() {
        if (this.jTextFieldSearch == null) {
            this.jTextFieldSearch = new JTextField();
            this.jTextFieldSearch.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent event) {
                    AlgorithmsPanel.this.processKeyPresssed(event);
                }
            });
        }
        return this.jTextFieldSearch;
    }

    protected void processKeyPresssed(KeyEvent event) {
        switch (event.getKeyChar()) {
            case '\n': {
                String sString = this.escape(this.jTextFieldSearch.getText().trim().toLowerCase());
                this.searchString(sString, true);
                break;
            }
            default: {
                String sString = this.jTextFieldSearch.getText() + event.getKeyChar();
                sString = this.escape(sString.trim().toLowerCase());
                this.searchString(sString, false);
            }
        }
    }

    private JButton getJButtonSearch() {
        if (this.jButtonSearch == null) {
            this.jButtonSearch = new JButton();
            this.jButtonSearch.setText(Sextante.getText((String)"Search"));
            this.jButtonSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String sString = AlgorithmsPanel.this.escape(AlgorithmsPanel.this.jTextFieldSearch.getText().trim().toLowerCase());
                    AlgorithmsPanel.this.searchString(sString, true);
                }
            });
        }
        return this.jButtonSearch;
    }

    protected void searchString(String sString, boolean bSearchInHelpFiles) {
        this.fillTree(sString, bSearchInHelpFiles);
        if (sString == null || sString.trim().equals("")) {
            this.collapseAll();
        } else {
            this.expandAll();
        }
    }

    public void collapseAll() {
        TreeNode root = (TreeNode)this.jTree.getModel().getRoot();
        TreePath path = new TreePath(root);
        this.expandAll(this.jTree, path, false);
        this.jTree.expandPath(path);
        int iChildCount = root.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeNode node = root.getChildAt(i);
            TreePath subpath = path.pathByAddingChild(node);
            this.jTree.expandPath(subpath);
        }
    }

    public void expandAll() {
        TreeNode root = (TreeNode)this.jTree.getModel().getRoot();
        this.expandAll(this.jTree, new TreePath(root), true);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private StringWriter createStringWriter(String str) {
        return new StringWriter((int)((double)str.length() + (double)str.length() * 0.1));
    }

    private String escape(String str) {
        StringWriter stringWriter = this.createStringWriter(str);
        try {
            this.escape(stringWriter, str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private void escape(Writer writer, String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c > '\u007f') {
                writer.write("&#");
                writer.write(Integer.toString(c, 10));
                writer.write(59);
                continue;
            }
            writer.write(c);
        }
    }
}

