/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.algorithm.FixedTableDialog;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.modeler.elements.ModelElementFixedTable;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterFixedTable;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FixedTableSelectionPanel
extends JPanel {
    private FixedTableModel m_FixedTableModel;
    private JComboBox jComboBox;
    private JButton button;
    private final ObjectAndDescription[] m_Tables;
    private final HashMap m_DataObjects;
    private final ModelAlgorithm m_Algorithm;

    public FixedTableSelectionPanel(AdditionalInfoFixedTable addInfo, ObjectAndDescription[] tables, HashMap dataObjects, ModelAlgorithm algorithm) {
        this.m_Tables = tables;
        this.m_DataObjects = dataObjects;
        this.m_FixedTableModel = new FixedTableModel(addInfo.getCols(), addInfo.getRowsCount(), addInfo.isNumberOfRowsFixed());
        this.m_Algorithm = algorithm;
        this.initGUI(tables);
    }

    private void initGUI(ObjectAndDescription[] tables) {
        this.button = new JButton("...");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixedTableSelectionPanel.this.btnActionPerformed(evt);
            }
        });
        this.jComboBox = new JComboBox<ObjectAndDescription>(this.getValidTables());
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0, 25.0}, {-1.0}});
        this.setLayout((LayoutManager)thisLayout);
        this.add((Component)this.jComboBox, "0,  0");
        this.add((Component)this.button, "1,  0");
    }

    private ObjectAndDescription[] getValidTables() {
        int i;
        ArrayList<ObjectAndDescription> array = new ArrayList<ObjectAndDescription>();
        for (i = 0; i < this.m_Tables.length; ++i) {
            String sKey = (String)this.m_Tables[i].getObject();
            String sDescription = this.m_Tables[i].getDescription();
            Object obj = ((ObjectAndDescription)this.m_DataObjects.get(sKey)).getObject();
            if (obj == null || !(obj instanceof ModelElementFixedTable)) continue;
            ModelElementFixedTable meft = (ModelElementFixedTable)obj;
            ParametersSet ps = this.m_Algorithm.getParameters();
            try {
                boolean bValid;
                Parameter param = ps.getParameter(sKey);
                if (!(param instanceof ParameterFixedTable)) continue;
                AdditionalInfoFixedTable addInfo = (AdditionalInfoFixedTable)((ParameterFixedTable)param).getParameterAdditionalInfo();
                boolean bl = bValid = this.m_FixedTableModel.getColumnCount() == meft.getColsCount();
                if (this.m_FixedTableModel.isNumberOfRowsFixed()) {
                    boolean bl2 = bValid = bValid && this.m_FixedTableModel.getRowCount() == addInfo.getRowsCount();
                }
                if (!bValid) continue;
                array.add(new ObjectAndDescription(sDescription, (Object)sKey));
                continue;
            }
            catch (WrongParameterIDException e) {
                Sextante.addErrorToLog((Throwable)e);
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        StringBuffer sText = new StringBuffer(Sextante.getText((String)"Fixed_table") + "(");
        sText.append(this.m_FixedTableModel.getDimensionsAsString());
        sText.append(")");
        ObjectAndDescription[] validTables = new ObjectAndDescription[array.size() + 1];
        validTables[0] = new ObjectAndDescription(sText.toString(), null);
        for (i = 0; i < array.size(); ++i) {
            validTables[i + 1] = (ObjectAndDescription)array.get(i);
        }
        return validTables;
    }

    public FixedTableModel getTableModel() {
        return this.m_FixedTableModel;
    }

    private void btnActionPerformed(ActionEvent e) {
        Frame window = new Frame();
        FixedTableDialog dialog = new FixedTableDialog(window, this.m_FixedTableModel);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.accepted()) {
            this.jComboBox.setSelectedIndex(0);
        }
    }

    public String getTableKey() {
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBox.getSelectedItem();
        String sKey = (String)oad.getObject();
        return sKey;
    }

    public void setTable(Object ob) {
        if (ob instanceof FixedTableModel) {
            this.m_FixedTableModel = (FixedTableModel)ob;
        } else if (ob instanceof String) {
            String sKey = (String)ob;
            for (int i = 1; i < this.jComboBox.getModel().getSize(); ++i) {
                ObjectAndDescription oad = (ObjectAndDescription)this.jComboBox.getModel().getElementAt(i);
                if (!oad.getObject().equals(sKey)) continue;
                this.jComboBox.setSelectedIndex(i);
            }
        }
    }
}

