/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.additionalInfo.AdditionalInfoBand;
import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.modeler.elements.IModelElement;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ModelAlgorithm
extends GeoAlgorithm {
    private HashMap m_Inputs;
    private ArrayList m_Algorithms = new ArrayList();
    private ArrayList m_AlgorithmKeys = new ArrayList();
    private ArrayList m_InputAssignments = new ArrayList();
    private String m_sFilename;
    private int m_iGeometryTypeRestriction;

    public ModelAlgorithm() {
        this.m_Inputs = new HashMap();
        this.setName(Sextante.getText((String)"[New_model]"));
    }

    public void defineCharacteristics() {
    }

    public void setValues(ArrayList algs2, ArrayList algKeys, ArrayList assignments, HashMap inputs, OutputObjectsSet outputs) {
        this.m_Algorithms = algs2;
        this.m_AlgorithmKeys = algKeys;
        this.m_InputAssignments = assignments;
        this.m_Inputs = inputs;
        this.m_OutputObjects = outputs;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        boolean bHasChanged;
        int iExecuted = 0;
        boolean[] bExecuted = new boolean[this.m_Algorithms.size()];
        this.setInputs();
        do {
            bHasChanged = false;
            for (int i = 0; i < this.m_Algorithms.size() && !this.m_Task.isCanceled(); ++i) {
                boolean bSuccess;
                GeoAlgorithm alg;
                if (bExecuted[i] || !this.prepareAlgorithm(i) || !(alg = (GeoAlgorithm)this.m_Algorithms.get(i)).preprocessForModeller((Object)this)) continue;
                bExecuted[i] = true;
                ++iExecuted;
                String sAlgKey = (String)this.m_AlgorithmKeys.get(i);
                if (this.m_bIsAutoExtent) {
                    alg.setAnalysisExtent(null);
                } else {
                    alg.setAnalysisExtent(this.getAnalysisExtent());
                }
                OutputObjectsSet oldOOSet = alg.getOutputObjects().getNewInstance();
                this.m_Task.setProcessDescription(alg.getName());
                this.m_Task.setProgress(0);
                this.m_Task.setDeterminate(alg.isDeterminatedProcess());
                try {
                    bSuccess = alg.execute(this.m_Task, this.m_OutputFactory);
                }
                catch (GeoAlgorithmExecutionException e) {
                    GeoAlgorithm wrongAlg = (GeoAlgorithm)this.m_Algorithms.get(i);
                    Sextante.addErrorToLog((String)(Sextante.getText((String)"error_en_algoritmo ") + Integer.toString(i + 1) + ":" + wrongAlg.getName()));
                    throw e;
                }
                if (bSuccess) {
                    bHasChanged = true;
                    OutputObjectsSet ooset = alg.getOutputObjects();
                    for (int j = 0; j < ooset.getOutputObjectsCount(); ++j) {
                        Output output = ooset.getOutput(j);
                        Object object = output.getOutputObject();
                        if (object == null) {
                            object = this.getDataObjectFromOutputChannel(output);
                            ((IDataObject)object).setName(output.getName());
                        }
                        String sKey = output.getName();
                        if (this.m_OutputObjects.containsKey(sKey = sKey + sAlgKey)) {
                            Output out = this.m_OutputObjects.getOutput(sKey);
                            out.setOutputObject(object);
                        }
                        if (!(output instanceof OutputRasterLayer || output instanceof OutputVectorLayer || output instanceof OutputTable || output instanceof Output3DRasterLayer)) {
                            this.m_OutputObjects.add(output.getNewInstance());
                        }
                        this.m_Inputs.put(sKey, object);
                    }
                    alg.setOutputObjects(oldOOSet);
                    continue;
                }
                return false;
            }
        } while (bHasChanged && !this.m_Task.isCanceled());
        return !this.m_Task.isCanceled();
    }

    private IDataObject getDataObjectFromOutputChannel(Output output) throws GeoAlgorithmExecutionException {
        String sFilename = ((FileOutputChannel)output.getOutputChannel()).getFilename();
        IDataObject obj = SextanteGUI.getInputFactory().openDataObjectFromFile(sFilename);
        if (obj == null) {
            throw new GeoAlgorithmExecutionException("Could not open intermediate layer");
        }
        return obj;
    }

    private void setInputs() {
        Parameter param;
        int i;
        String sFieldName = "";
        int iCount = this.m_Parameters.getNumberOfParameters();
        for (i = 0; i < iCount; ++i) {
            param = this.m_Parameters.getParameter(i);
            this.m_Inputs.put(param.getParameterName(), param.getParameterValueAsObject());
        }
        for (i = 0; i < iCount; ++i) {
            param = this.m_Parameters.getParameter(i);
            if (!(param instanceof ParameterTableField)) continue;
            try {
                AdditionalInfoTableField aitf = (AdditionalInfoTableField)param.getParameterAdditionalInfo();
                String sParent = aitf.getParentParameterName();
                Parameter parent = this.m_Parameters.getParameter(sParent);
                int iField = param.getParameterValueAsInt();
                if (parent instanceof ParameterVectorLayer) {
                    IVectorLayer layer = parent.getParameterValueAsVectorLayer();
                    sFieldName = layer.getFieldName(iField);
                } else if (parent instanceof ParameterTable) {
                    ITable table = parent.getParameterValueAsTable();
                    sFieldName = table.getFieldName(iField);
                }
                this.m_Inputs.put(param.getParameterName(), sFieldName);
                continue;
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    private boolean prepareAlgorithm(int iAlgorithm) throws GeoAlgorithmExecutionException {
        GeoAlgorithm alg = (GeoAlgorithm)this.m_Algorithms.get(iAlgorithm);
        ParametersSet ps = alg.getParameters();
        int iCount = ps.getNumberOfParameters();
        HashMap map = (HashMap)this.m_InputAssignments.get(iAlgorithm);
        for (int i = 0; i < iCount; ++i) {
            boolean bMandatory;
            Object input;
            Parameter param = ps.getParameter(i);
            Object asignment = map.get(param.getParameterName());
            if (param instanceof ParameterMultipleInput) {
                if (asignment == null) continue;
                ArrayList inputArray = (ArrayList)this.m_Inputs.get(asignment);
                if (inputArray == null) {
                    return false;
                }
                input = new ArrayList();
                if (this.createMultipleInputFromArray(inputArray, (ArrayList)input, param)) {
                    param.setParameterValue(input);
                    bMandatory = ((AdditionalInfoMultipleInput)param.getParameterAdditionalInfo()).getIsMandatory();
                    if (!bMandatory || ((ArrayList)input).size() != 0) continue;
                    return false;
                }
                return false;
            }
            if (param instanceof ParameterDataObject) {
                try {
                    bMandatory = ((AdditionalInfoDataObject)param.getParameterAdditionalInfo()).getIsMandatory();
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog((Throwable)e);
                    return false;
                }
            } else {
                bMandatory = false;
            }
            if (asignment == null) {
                if (!bMandatory) continue;
                return false;
            }
            input = this.m_Inputs.get(asignment);
            if (input instanceof IModelElement) {
                return false;
            }
            if (param instanceof ParameterTableField) continue;
            param.setParameterValue(input);
        }
        this.setOutputs(iAlgorithm);
        this.checkVectorLayers(iAlgorithm);
        this.checkTableFields(iAlgorithm);
        this.checkRasterBands(iAlgorithm);
        this.checkNumericalValues(iAlgorithm);
        return true;
    }

    private void setOutputs(int iIndex) {
        GeoAlgorithm alg = (GeoAlgorithm)this.m_Algorithms.get(iIndex);
        String sAlgKey = (String)this.m_AlgorithmKeys.get(iIndex);
        OutputObjectsSet ooset = alg.getOutputObjects();
        for (int j = 0; j < ooset.getOutputObjectsCount(); ++j) {
            Output output = ooset.getOutput(j);
            String sKey = output.getName();
            if (!this.m_OutputObjects.containsKey(sKey = sKey + sAlgKey)) continue;
            output.setOutputChannel(this.getOutputChannel(sKey));
        }
    }

    private void checkNumericalValues(int iAlgorithm) throws GeoAlgorithmExecutionException {
        GeoAlgorithm alg = (GeoAlgorithm)this.m_Algorithms.get(iAlgorithm);
        ParametersSet ps = alg.getParameters();
        HashMap map = (HashMap)this.m_InputAssignments.get(iAlgorithm);
        int iCount = ps.getNumberOfParameters();
        for (int i = 0; i < iCount; ++i) {
            try {
                Parameter param = ps.getParameter(i);
                Object asignment = map.get(param.getParameterName());
                if (!(param instanceof ParameterNumericalValue)) continue;
                double dValue = (Double)this.m_Inputs.get(asignment);
                AdditionalInfoNumericalValue ainv = (AdditionalInfoNumericalValue)param.getParameterAdditionalInfo();
                double dMax = ainv.getMaxValue();
                double dMin = ainv.getMinValue();
                if (!(dMax < dValue) && !(dValue < dMin)) continue;
                String sError = "Valor_fuera_rango" + Double.toString(dValue);
                throw new GeoAlgorithmExecutionException(sError);
            }
            catch (Exception e) {
                throw new GeoAlgorithmExecutionException(e.getMessage());
            }
        }
    }

    private void checkVectorLayers(int iAlgorithm) throws GeoAlgorithmExecutionException {
        GeoAlgorithm alg = (GeoAlgorithm)this.m_Algorithms.get(iAlgorithm);
        ParametersSet ps = alg.getParameters();
        HashMap map = (HashMap)this.m_InputAssignments.get(iAlgorithm);
        int iCount = ps.getNumberOfParameters();
        for (int i = 0; i < iCount; ++i) {
            try {
                int iTypeLayer;
                Parameter param = ps.getParameter(i);
                Object asignment = map.get(param.getParameterName());
                if (!(param instanceof ParameterVectorLayer)) continue;
                IVectorLayer layer = (IVectorLayer)this.m_Inputs.get(asignment);
                AdditionalInfoVectorLayer aivl = (AdditionalInfoVectorLayer)param.getParameterAdditionalInfo();
                int iType = aivl.getShapeType();
                if (iType == (iTypeLayer = layer.getShapeType()) || iType == -1) continue;
                String sError = "ERROR: Layer " + layer.getName() + ". Wrong layer type";
                throw new GeoAlgorithmExecutionException(sError);
            }
            catch (Exception e) {
                throw new GeoAlgorithmExecutionException(e.getMessage());
            }
        }
    }

    private void checkTableFields(int iAlgorithm) throws GeoAlgorithmExecutionException {
        GeoAlgorithm alg = (GeoAlgorithm)this.m_Algorithms.get(iAlgorithm);
        ParametersSet ps = alg.getParameters();
        HashMap map = (HashMap)this.m_InputAssignments.get(iAlgorithm);
        int iCount = ps.getNumberOfParameters();
        for (int i = 0; i < iCount; ++i) {
            try {
                int iField;
                Parameter param = ps.getParameter(i);
                Object asignment = map.get(param.getParameterName());
                if (!(param instanceof ParameterTableField)) continue;
                String sFieldName = (String)this.m_Inputs.get(asignment);
                AdditionalInfoTableField aitf = (AdditionalInfoTableField)param.getParameterAdditionalInfo();
                if (sFieldName.trim().equals("") && !aitf.getIsMandatory()) continue;
                String sParent = aitf.getParentParameterName();
                Parameter parentParam = ps.getParameter(sParent);
                if (parentParam instanceof ParameterVectorLayer) {
                    IVectorLayer layer = ps.getParameterValueAsVectorLayer(sParent);
                    iField = layer.getFieldIndexByName(sFieldName);
                    if (iField != -1) {
                        param.setParameterValue((Object)new Integer(iField));
                        continue;
                    }
                    String sError = "ERROR: Field " + sFieldName + " not found in layer " + layer.getName();
                    throw new GeoAlgorithmExecutionException(sError);
                }
                ITable table = ps.getParameterValueAsTable(sParent);
                iField = table.getFieldIndexByName(sFieldName);
                if (iField != -1) {
                    param.setParameterValue((Object)new Integer(iField));
                    continue;
                }
                String sError = "ERROR: Field " + sFieldName + " not found in layer " + table.getName();
                throw new GeoAlgorithmExecutionException(sError);
            }
            catch (Exception e) {
                throw new GeoAlgorithmExecutionException(e.getMessage());
            }
        }
    }

    private void checkRasterBands(int iAlgorithm) throws GeoAlgorithmExecutionException {
        GeoAlgorithm alg = (GeoAlgorithm)this.m_Algorithms.get(iAlgorithm);
        ParametersSet ps = alg.getParameters();
        HashMap map = (HashMap)this.m_InputAssignments.get(iAlgorithm);
        int iCount = ps.getNumberOfParameters();
        for (int i = 0; i < iCount; ++i) {
            try {
                Parameter param = ps.getParameter(i);
                Object asignment = map.get(param.getParameterName());
                if (!(param instanceof ParameterBand)) continue;
                int iBand = (Integer)this.m_Inputs.get(asignment);
                AdditionalInfoBand aib = (AdditionalInfoBand)param.getParameterAdditionalInfo();
                String sParent = aib.getParentParameterName();
                IRasterLayer layer = ps.getParameterValueAsRasterLayer(sParent);
                if (layer.getBandsCount() > iBand) {
                    param.setParameterValue((Object)new Integer(iBand));
                    continue;
                }
                String sError = "ERROR: Band " + Integer.toString(iBand + 1) + " not found in layer " + layer.getName();
                throw new GeoAlgorithmExecutionException(sError);
            }
            catch (Exception e) {
                throw new GeoAlgorithmExecutionException(e.getMessage());
            }
        }
    }

    private boolean createMultipleInputFromArray(ArrayList array, ArrayList paramInput, Parameter param) {
        ArrayList paramInputUnprocessed = new ArrayList();
        boolean bReturn = this.createMultipleInputFromArray(array, paramInputUnprocessed);
        if (bReturn) {
            try {
                AdditionalInfoMultipleInput ai = (AdditionalInfoMultipleInput)param.getParameterAdditionalInfo();
                if (ai.getDataType() == 7) {
                    this.createArrayOfBands(paramInput, paramInputUnprocessed);
                } else {
                    for (int i = 0; i < paramInputUnprocessed.size(); ++i) {
                        paramInput.add(paramInputUnprocessed.get(i));
                    }
                }
                return true;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
                return false;
            }
        }
        return false;
    }

    private void createArrayOfBands(ArrayList array, ArrayList unprocessed) {
        for (int i = 0; i < unprocessed.size(); ++i) {
            Object obj = unprocessed.get(i);
            if (obj instanceof RasterLayerAndBand) {
                array.add(obj);
                continue;
            }
            IRasterLayer lyr = (IRasterLayer)obj;
            for (int j = 0; j < lyr.getBandsCount(); ++j) {
                array.add(new RasterLayerAndBand(lyr, j));
            }
        }
    }

    private boolean createMultipleInputFromArray(ArrayList array, ArrayList paramInput) {
        int iParams = array.size();
        for (int i = 0; i < iParams; ++i) {
            String sName = (String)array.get(i);
            Object item = this.m_Inputs.get(sName);
            if (item == null) {
                return false;
            }
            if (item instanceof ArrayList) {
                if (this.createMultipleInputFromArray((ArrayList)item, paramInput)) continue;
                return false;
            }
            paramInput.add(item);
        }
        return true;
    }

    public void addAlgorithm(GeoAlgorithm alg, String sName) {
        if (!this.m_AlgorithmKeys.contains(sName)) {
            this.m_Algorithms.add(alg);
            this.m_AlgorithmKeys.add(sName);
            this.m_InputAssignments.add(new HashMap());
            this.checkUserCanDefineOutputExtent();
        }
    }

    public void removeAlgorithm(String sKey) {
        for (int i = 0; i < this.m_AlgorithmKeys.size(); ++i) {
            String sAlgKey = (String)this.m_AlgorithmKeys.get(i);
            if (!sAlgKey.equals(sKey)) continue;
            this.m_Algorithms.remove(i);
            this.m_AlgorithmKeys.remove(i);
            this.m_InputAssignments.remove(i);
            this.checkUserCanDefineOutputExtent();
            return;
        }
    }

    private void checkUserCanDefineOutputExtent() {
        this.setUserCanDefineAnalysisExtent(false);
        for (int i = 0; i < this.m_Algorithms.size(); ++i) {
            if (!((GeoAlgorithm)this.m_Algorithms.get(i)).getUserCanDefineAnalysisExtent()) continue;
            this.setUserCanDefineAnalysisExtent(true);
            return;
        }
    }

    public boolean addInputAsignment(String sParamName, String sInputName, String alg) {
        for (int i = 0; i < this.m_Algorithms.size(); ++i) {
            String alg2 = (String)this.m_AlgorithmKeys.get(i);
            if (!alg.equals(alg2)) continue;
            HashMap map = (HashMap)this.m_InputAssignments.get(i);
            map.put(sParamName, sInputName);
            return true;
        }
        return false;
    }

    public void addInput(Parameter param) throws RepeatedParameterNameException {
        this.m_Parameters.addParameter(param);
    }

    public void removeInput(Parameter param) {
        try {
            this.m_Parameters.removeParameter(param);
        }
        catch (WrongParameterIDException wrongParameterIDException) {
            // empty catch block
        }
    }

    public void removeInput(String sKey) {
        try {
            this.unassign(sKey);
            this.m_Parameters.removeParameter(sKey);
            this.m_InputAssignments.remove(sKey);
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void unassign(String sAssignmentKey) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (int i = 0; i < this.m_InputAssignments.size(); ++i) {
            HashMap assignments = (HashMap)this.m_InputAssignments.get(i);
            Set set = assignments.keySet();
            for (String sKey : set) {
                String sInput = (String)assignments.get(sKey);
                if (sInput == null || !sInput.equals(sAssignmentKey)) continue;
                toRemove.add(sKey);
            }
            for (int j = 0; j < toRemove.size(); ++j) {
                String sKey;
                sKey = (String)toRemove.get(j);
                assignments.remove(sKey);
            }
        }
    }

    public ArrayList getAlgorithmKeys() {
        return this.m_AlgorithmKeys;
    }

    public ArrayList getAlgorithms() {
        return this.m_Algorithms;
    }

    public ArrayList getInputAssignments() {
        return this.m_InputAssignments;
    }

    public HashMap getInputs() {
        return this.m_Inputs;
    }

    public GeoAlgorithm getAlgorithm(String sKey) {
        for (int i = 0; i < this.m_AlgorithmKeys.size(); ++i) {
            String sAlgKey = (String)this.m_AlgorithmKeys.get(i);
            if (!sAlgKey.equals(sKey)) continue;
            return (GeoAlgorithm)this.m_Algorithms.get(i);
        }
        return null;
    }

    public HashMap getInputAssignments(String sKey) {
        for (int i = 0; i < this.m_AlgorithmKeys.size(); ++i) {
            String sAlgKey = (String)this.m_AlgorithmKeys.get(i);
            if (!sAlgKey.equals(sKey)) continue;
            return (HashMap)this.m_InputAssignments.get(i);
        }
        return null;
    }

    public String getInputAsignment(String sParamName, GeoAlgorithm alg) {
        for (int i = 0; i < this.m_Algorithms.size(); ++i) {
            GeoAlgorithm alg2 = (GeoAlgorithm)this.m_Algorithms.get(i);
            if (!alg.equals(alg2)) continue;
            HashMap map = (HashMap)this.m_InputAssignments.get(i);
            return (String)map.get(sParamName);
        }
        return null;
    }

    public GeoAlgorithm getNewInstance() throws InstantiationException, IllegalAccessException {
        ModelAlgorithm alg = (ModelAlgorithm)((Object)((Object)((Object)this)).getClass().newInstance());
        OutputObjectsSet ooSet = this.m_OutputObjects.getNewInstance();
        alg.setOutputObjects(ooSet);
        alg.setName(this.getName());
        alg.setValues(this.m_Algorithms, this.m_AlgorithmKeys, this.m_InputAssignments, this.m_Inputs, ooSet);
        alg.setParameters(this.m_Parameters);
        alg.setIsDeterminatedProcess(false);
        alg.checkUserCanDefineOutputExtent();
        alg.setAnalysisExtent(this.m_AnalysisExtent);
        alg.setFilename(this.m_sFilename);
        if (this.m_bIsAutoExtent) {
            alg.setAnalysisExtent(null);
            alg.m_bIsAutoExtent = true;
        }
        return alg;
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public void setFilename(String sFilename) {
        this.m_sFilename = sFilename;
    }

    public String getCommandLineName() {
        return "model:" + new File(this.m_sFilename).getName();
    }

    public boolean canDefineOutputExtentFromInput() {
        for (int i = 0; i < this.m_Algorithms.size(); ++i) {
            if (((GeoAlgorithm)this.m_Algorithms.get(i)).canDefineOutputExtentFromInput()) continue;
            return false;
        }
        return true;
    }

    public void setGeometryTypeRestriction(int iRestriction) {
        this.m_iGeometryTypeRestriction = iRestriction;
    }

    public int getGeometryTypeRestriction() {
        return this.m_iGeometryTypeRestriction;
    }
}

