/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.modeler.ModelerPanel;
import es.unex.sextante.gui.modeler.SelectionAndChoices;
import es.unex.sextante.gui.modeler.parameters.ParameterPanel;
import es.unex.sextante.gui.modeler.parameters.SelectionTreePanel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterSelection;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SelectionPanel
extends ParameterPanel {
    private SelectionTreePanel tree;
    private String searchArgument;
    private TreePath selectedPath = null;

    public SelectionPanel(JDialog parent, ModelerPanel panel) {
        super(parent, panel);
    }

    public SelectionPanel(ModelerPanel panel) {
        super(panel);
    }

    @Override
    public String getParameterDescription() {
        return Sextante.getText((String)"option_setting");
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        super.setTitle(Sextante.getText((String)"modeler_add_par_selection"));
        super.setPreferredSize(new Dimension(400, 540));
        super.setResizable(true);
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.jPanelMiddle.setLayout((LayoutManager)thisLayout);
        try {
            this.tree = new SelectionTreePanel();
            this.jButtonOk.setEnabled(false);
            final JButton jButtonOk = this.jButtonOk;
            final ModelerPanel jPanel = this.m_ModelerPanel;
            this.tree.getTree().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)SelectionPanel.this.tree.getTree().getLastSelectedPathComponent();
                    if (node == null) {
                        jButtonOk.setEnabled(false);
                    } else {
                        Object nodeInfo = node.getUserObject();
                        if (node.isLeaf()) {
                            jButtonOk.setEnabled(true);
                        } else {
                            jButtonOk.setEnabled(false);
                        }
                    }
                    jPanel.repaint();
                }
            });
            this.jPanelMiddle.add((Component)this.tree, "0, 0");
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    @Override
    protected boolean prepareParameter() {
        String sDescription = this.jTextFieldDescription.getText();
        if (sDescription.length() != 0) {
            this.m_Parameter = new ParameterSelection();
            SelectionAndChoices sac = this.tree.getSelectedList();
            if (sac != null) {
                AdditionalInfoSelection ai = new AdditionalInfoSelection(sac.getChoices());
                String sSelPath = this.tree.getTree().getSelectionPath().toString();
                ai.setSelectionPath(sSelPath);
                this.m_Parameter.setParameterAdditionalInfo((AdditionalInfo)ai);
                if (sDescription.trim().equals("")) {
                    this.m_Parameter.setParameterDescription(sac.getDescription());
                } else {
                    this.m_Parameter.setParameterDescription(sDescription);
                }
                this.m_Parameter.setColorR(this.m_Color.getRed());
                this.m_Parameter.setColorG(this.m_Color.getGreen());
                this.m_Parameter.setColorB(this.m_Color.getBlue());
                this.m_Parameter.setColorAlpha(this.m_Color.getAlpha());
                return true;
            }
            return false;
        }
        JOptionPane.showMessageDialog(null, Sextante.getText((String)"Invalid_description"), Sextante.getText((String)"Warning"), 2);
        return false;
    }

    private void walk(DefaultTreeModel model, Object o) {
        if (this.searchArgument == null) {
            return;
        }
        int cc = model.getChildCount(o);
        for (int i = 0; i < cc; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(o, i);
            if (model.isLeaf(child)) {
                String path = Arrays.toString(child.getPath());
                if (!this.searchArgument.equals(path.substring(1, path.length() - 1))) continue;
                this.selectedPath = new TreePath(model.getPathToRoot(child));
                this.searchArgument = null;
                break;
            }
            this.walk(model, child);
        }
    }

    @Override
    public void setParameter(Parameter param) {
        super.setParameter(param);
        try {
            AdditionalInfoSelection ai;
            if (param != null && (ai = (AdditionalInfoSelection)param.getParameterAdditionalInfo()) != null && ai.getSelectionPath() != null && ai.getSelectionPath().length() > 0) {
                this.searchArgument = ai.getSelectionPath();
                this.searchArgument = this.searchArgument.replace("[", "");
                this.searchArgument = this.searchArgument.replace("]", "");
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getTree().getModel();
                this.selectedPath = null;
                this.walk(model, model.getRoot());
                if (this.selectedPath != null) {
                    this.jButtonOk.setEnabled(true);
                    this.tree.getTree().expandPath(this.selectedPath);
                    this.tree.getTree().makeVisible(this.selectedPath);
                    this.tree.getTree().setSelectionPath(this.selectedPath);
                    this.tree.getTree().scrollPathToVisible(this.selectedPath.getParentPath());
                }
            }
        }
        catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
            // empty catch block
        }
    }

    @Override
    public boolean parameterCanBeAdded() {
        return true;
    }
}

