/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.modeler.SelectionAndChoices;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class SelectionTreePanel
extends JPanel {
    private JTree jTree;
    private JScrollPane jScrollPane;

    public SelectionTreePanel() {
        this.initGUI();
    }

    private void initGUI() {
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.jTree = new JTree();
        this.jTree.setCellRenderer(new MyCellRenderer());
        this.fillTree();
        this.jScrollPane = new JScrollPane(this.jTree, 22, 32);
        this.add((Component)this.jScrollPane, "Center");
    }

    public JTree getTree() {
        return this.jTree;
    }

    private void fillTree() {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"Algorithms"));
        HashMap algs2 = Sextante.getAlgorithms();
        Set setGroups = algs2.keySet();
        Iterator iterGroups = setGroups.iterator();
        while (iterGroups.hasNext()) {
            DefaultMutableTreeNode node;
            HashMap<String, DefaultMutableTreeNode> map = new HashMap<String, DefaultMutableTreeNode>();
            String sKeyGroups = (String)iterGroups.next();
            DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(sKeyGroups);
            HashMap group = (HashMap)algs2.get(sKeyGroups);
            Set set = group.keySet();
            for (String sKey : set) {
                GeoAlgorithm alg = (GeoAlgorithm)group.get(sKey);
                if (!alg.isSuitableForModelling()) continue;
                boolean bHasSelection = false;
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(alg);
                ParametersSet ps = alg.getParameters();
                int iParCount = ps.getNumberOfParameters();
                for (int j = 0; j < iParCount; ++j) {
                    Parameter parameter = ps.getParameter(j);
                    if (!(parameter instanceof ParameterSelection)) continue;
                    bHasSelection = true;
                    try {
                        AdditionalInfoSelection ai = (AdditionalInfoSelection)parameter.getParameterAdditionalInfo();
                        DefaultMutableTreeNode subchild = new DefaultMutableTreeNode(new SelectionAndChoices(parameter.getParameterDescription(), ai.getValues()));
                        this.addNodeInSortedOrder(child, subchild);
                        continue;
                    }
                    catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
                        // empty catch block
                    }
                }
                if (!bHasSelection) continue;
                String sGroup = alg.getGroup();
                if (map.containsKey(sGroup)) {
                    node = (DefaultMutableTreeNode)map.get(sGroup);
                } else {
                    node = new DefaultMutableTreeNode(sGroup);
                    map.put(sGroup, node);
                }
                this.addNodeInSortedOrder(node, child);
            }
            set = map.keySet();
            for (String sKey : set) {
                node = (DefaultMutableTreeNode)map.get(sKey);
                this.addNodeInSortedOrder(groupNode, node);
            }
            if (map.size() == 0) continue;
            this.addNodeInSortedOrder(mainNode, groupNode);
        }
        this.jTree.setModel(new DefaultTreeModel(mainNode));
    }

    private void addNodeInSortedOrder(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int n = parent.getChildCount();
        if (n == 0) {
            parent.add(child);
            return;
        }
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        DefaultMutableTreeNode node = null;
        for (int i = 0; i < n; ++i) {
            node = (DefaultMutableTreeNode)parent.getChildAt(i);
            try {
                if (collator.compare(node.toString(), child.toString()) <= 0) continue;
                parent.insert(child, i);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        parent.add(child);
    }

    public SelectionAndChoices getSelectedList() {
        TreePath path = this.jTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            SelectionAndChoices sac = (SelectionAndChoices)node.getUserObject();
            return sac;
        }
        catch (Exception e) {
            return null;
        }
    }

    static class MyCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setFont(tree.getFont());
            String sName = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            this.setText(sName);
            try {
                if (!leaf) {
                    this.setFont(new Font("Tahoma", 1, 11));
                    this.setForeground(Color.black);
                } else if (sel) {
                    this.setForeground(Color.blue);
                } else {
                    this.setForeground(Color.black);
                }
            }
            catch (ClassCastException e) {
                this.setForeground(Color.black);
            }
            return this;
        }
    }
}

