/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.settings;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.WrongSettingValuesException;
import es.unex.sextante.gui.settings.Setting;
import es.unex.sextante.gui.settings.SettingPanel;
import es.unex.sextante.gui.settings.SextanteGeneralSettings;
import es.unex.sextante.gui.toolbox.ToolboxPanel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SextanteConfigurationDialog
extends JDialog {
    private final Setting[] m_Settings;
    private SettingPanel m_CurrentPanel;
    private TreePath m_Path;
    private final HashMap<String, String> m_Values;
    private JButton jButtonCancel;
    private JTree jTree;
    private JSplitPane jSplitPane;
    private JButton jButtonOk;
    private JLabel jLabelVersion;
    public static final double SPACER_SMALL = 3.0;
    public static final double SPACER_MEDIUM = 6.0;
    public static final double SPACER_LARGE = 9.0;

    public SextanteConfigurationDialog(ToolboxPanel panel, JDialog parent) {
        super(parent, Sextante.getText((String)"Toolbox") + " - " + Sextante.getText((String)"Settings"), true);
        Setting[] settings = new Setting[]{new SextanteGeneralSettings()};
        ArrayList<IAlgorithmProvider> providers = SextanteGUI.getAlgorithmProviders();
        this.m_Settings = new Setting[settings.length + providers.size()];
        System.arraycopy(settings, 0, this.m_Settings, 0, settings.length);
        for (int i = 0; i < providers.size(); ++i) {
            this.m_Settings[i + settings.length] = providers.get(i).getSettings();
        }
        this.m_Values = new HashMap();
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    public SextanteConfigurationDialog(ToolboxPanel panel) {
        super(SextanteGUI.getMainFrame(), Sextante.getText((String)"Toolbox") + " - " + Sextante.getText((String)"Settings"), true);
        Setting[] settings = new Setting[]{new SextanteGeneralSettings()};
        ArrayList<IAlgorithmProvider> providers = SextanteGUI.getAlgorithmProviders();
        this.m_Settings = new Setting[settings.length + providers.size()];
        System.arraycopy(settings, 0, this.m_Settings, 0, settings.length);
        for (int i = 0; i < providers.size(); ++i) {
            this.m_Settings[i + settings.length] = providers.get(i).getSettings();
        }
        this.m_Values = new HashMap();
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    protected void changeSetting() {
        DefaultMutableTreeNode node;
        Object obj;
        if (this.m_Path != null && (obj = (node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent()).getUserObject()) instanceof Setting) {
            Setting setting = (Setting)obj;
            try {
                HashMap<String, String> values = this.m_CurrentPanel.getValues();
                this.jSplitPane.remove(this.m_CurrentPanel);
                this.m_CurrentPanel = setting.getPanel();
                this.jSplitPane.add((Component)this.m_CurrentPanel, "right");
                this.m_CurrentPanel.setPreferredSize(new Dimension(389, 211));
                Set<String> set = values.keySet();
                for (String key : set) {
                    this.m_Values.put(key, values.get(key));
                }
            }
            catch (WrongSettingValuesException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "", 2);
            }
        }
    }

    private void fillTree() {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"Settings"));
        for (Setting element : this.m_Settings) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(element);
            mainNode.add(node);
        }
        DefaultTreeModel model = new DefaultTreeModel(mainNode);
        this.jTree.setModel(model);
    }

    private void initGUI() {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{3.0, 160.0, -1.0, 170.0, 3.0, 170.0, 3.0}, {-1.0, 3.0, 30.0, 3.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.getContentPane().setLayout((LayoutManager)thisLayout);
        this.setResizable(false);
        this.jLabelVersion = new JLabel();
        this.jLabelVersion.setText("<html><i>" + Sextante.getText((String)"version") + " " + Sextante.getVersionNumber() + "</i></html>");
        this.getContentPane().add((Component)this.jLabelVersion, "1, 2");
        this.jButtonCancel = new JButton();
        this.getContentPane().add((Component)this.jButtonCancel, "3, 2");
        this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SextanteConfigurationDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk = new JButton();
        this.getContentPane().add((Component)this.jButtonOk, "5, 2");
        this.jButtonOk.setText(Sextante.getText((String)"OK"));
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SextanteConfigurationDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jSplitPane = new JSplitPane();
        this.getContentPane().add((Component)this.jSplitPane, "0, 0, 6, 1");
        this.jTree = new JTree();
        this.jTree.setPreferredSize(new Dimension(164, 422));
        this.jSplitPane.add((Component)this.jTree, "left");
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SextanteConfigurationDialog.this.m_Path = SextanteConfigurationDialog.this.jTree.getPathForLocation(e.getX(), e.getY());
                SextanteConfigurationDialog.this.changeSetting();
            }
        };
        this.jTree.addMouseListener(ml);
        this.fillTree();
        this.setSize(634, 466);
        this.m_CurrentPanel = this.m_Settings[0].getPanel();
        this.jSplitPane.add((Component)this.m_CurrentPanel, "right");
        this.jTree.setSelectionRow(1);
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        try {
            HashMap<String, String> values = this.m_CurrentPanel.getValues();
            Set<String> set = values.keySet();
            for (String key : set) {
                this.m_Values.put(key, values.get(key));
            }
            SextanteGUI.setSettings(this.m_Values);
            SextanteGUI.saveSettings();
            this.dispose();
            this.setVisible(false);
            SextanteGUI.getGUIFactory().updateToolbox();
        }
        catch (WrongSettingValuesException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "", 2);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
        this.setVisible(false);
    }
}

