/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.splitlines;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.geoprocess.algorithm.splitlines.SplitLinesOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class SplitLinesAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";
    public static final String DISTANCE = "DISTANCE";
    public static final String SELECTGEOM_INPUT = "SELECTGEOM_INPUT";
    public static final String MULTIGEOMETRY = "MULTIGEOMETRY";
    private FlyrVectIVectorLayer sextanteInputLayer = null;
    protected FeatureStore inputStore = null;
    protected FeatureStore outputStore = null;

    public void defineCharacteristics() {
        this.setName(this.getTranslation("split_lines"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), 1, true);
            this.m_Parameters.addBoolean(SELECTGEOM_INPUT, this.getTranslation("Selected_geometries"), false);
            this.m_Parameters.addNumericalValue(DISTANCE, this.getTranslation("distance_section"), 0.0, 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer(RESULT, this.getTranslation("SplitLines_line"), 1);
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        this.sextanteInputLayer = (FlyrVectIVectorLayer)this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        boolean selectedGeomInput = this.m_Parameters.getParameter(SELECTGEOM_INPUT).getParameterValueAsBoolean();
        double distanceValue = this.m_Parameters.getParameter(DISTANCE).getParameterValueAsDouble();
        boolean multigeometry = false;
        if (!(this.sextanteInputLayer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        this.inputStore = this.sextanteInputLayer.getFeatureStore();
        SplitLinesOperation operation = new SplitLinesOperation(distanceValue, this.inputStore, this, multigeometry);
        operation.setGeoProcess(this, 100);
        operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
        FeatureType featureType = null;
        try {
            featureType = this.inputStore.getDefaultFeatureType();
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        this.outputStore = this.buildOutPutStore(featureType, 5, this.getTranslation("split_lines"), RESULT);
        try {
            operation.computesGeometryOperation(this.inputStore, this.outputStore, this.attrNames, selectedGeomInput, false, true);
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return true;
    }
}

