/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportServices;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.FileTools;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppReportServices
implements ReportServices {
    private static Logger LOG = LoggerFactory.getLogger(AppReportServices.class);
    private File rootFolder;

    public FeatureStore getFeatureStore(final ReportDataSet dataSet) {
        MutableObject store = new MutableObject(null);
        ApplicationManager application = ApplicationLocator.getManager();
        Project project = application.getCurrentProject();
        ArrayList<Document> views = new ArrayList<Document>();
        views.add(project.getActiveDocument(ViewManager.TYPENAME));
        views.addAll(project.getDocuments(ViewManager.TYPENAME));
        for (Document view : views) {
            if (view == null) continue;
            FLayers layers = ((ViewDocument)view).getMapContext().getLayers();
            try {
                layers.accept(new Visitor((Mutable)store){
                    final /* synthetic */ Mutable val$store;
                    {
                        this.val$store = mutable;
                    }

                    public void visit(Object o) throws VisitCanceledException, BaseException {
                        FLyrVect layer;
                        if (o instanceof FLyrVect && dataSet.hasThisStore((layer = (FLyrVect)o).getFeatureStore())) {
                            this.val$store.setValue((Object)layer.getFeatureStore());
                            throw new VisitCanceledException();
                        }
                    }
                });
            }
            catch (VisitCanceledException ex) {
                break;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (FeatureStore)store.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getViewImage(String viewName, Dimension dimension, Envelope envelope) {
        ApplicationManager application = ApplicationLocator.getManager();
        Project project = application.getCurrentProject();
        ViewDocument view = (ViewDocument)project.getDocument(viewName, ViewManager.TYPENAME);
        if (view == null) {
            LOG.warn("Can't locate view name '" + viewName + "'.");
            return null;
        }
        MapContext mapContext = view.getMapContext().cloneFMap();
        ViewPort viewPort = mapContext.getViewPort();
        Envelope previousEnvelope = viewPort.getEnvelope();
        Graphics g = null;
        BufferedImage image = null;
        try {
            if (envelope != null) {
                viewPort.setEnvelope(envelope);
            }
            if (dimension != null) {
                viewPort.setImageSize(dimension);
            }
            image = new BufferedImage(viewPort.getImageWidth(), viewPort.getImageHeight(), 2);
            g = (Graphics2D)image.getGraphics();
            try {
                mapContext.draw(image, (Graphics2D)g, mapContext.getScaleView());
            }
            catch (Exception ex) {
                LOG.warn("Can't draw image for view '" + viewName + "'.", (Throwable)ex);
                BufferedImage bufferedImage = null;
                if (g != null) {
                    g.dispose();
                }
                viewPort.setEnvelope(previousEnvelope);
                return bufferedImage;
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            viewPort.setEnvelope(previousEnvelope);
        }
        return image;
    }

    public List<String> getViewNames() {
        ArrayList<String> names = new ArrayList<String>();
        ApplicationManager application = ApplicationLocator.getManager();
        Project project = application.getCurrentProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (Document view : views) {
            names.add(view.getName());
        }
        return names;
    }

    public void setRootFolder(File rootFolder) {
        this.rootFolder = rootFolder;
    }

    public File relativizeFile(File file) {
        if (this.rootFolder == null) {
            return file;
        }
        return FileTools.relativizeFile((File)this.rootFolder, (File)file);
    }

    public File derelativizeFile(File file) {
        if (this.rootFolder == null) {
            return file;
        }
        return FileTools.derelativizeFile((File)this.rootFolder, (File)file);
    }
}

