/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypePanel;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.propertypage.PropertiesPageFactory;
import org.gvsig.propertypage.PropertiesPageManager;
import org.gvsig.report.app.mainplugin.AddDatasetFromCatalogAction;
import org.gvsig.report.app.mainplugin.ReportState;
import org.gvsig.report.app.mainplugin.document.ReportDocumentsManager;
import org.gvsig.report.app.mainplugin.document.gui.projectpanel.ProjectReportPanelPageFactory;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.report.lib.api.ReportDataSets;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.swing.api.JReport;
import org.gvsig.report.swing.api.ReportSwingLocator;
import org.gvsig.report.swing.api.ReportSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class ReportExtension
extends Extension {
    private ReportState reportState;

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"report-publish-layer", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"report-publish-table", (Object)((Object)this));
        this.reportState = ReportState.get();
    }

    public void postInitialize() {
        new ReportDocumentsManager().selfRegister();
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        viewManager.addTOCContextAction("report-publish-layer");
        PropertiesPageManager propertiesManager = ToolsUtilLocator.getPropertiesPageManager();
        propertiesManager.registerFactory((PropertiesPageFactory)new ProjectReportPanelPageFactory());
        this.registerInCatalog();
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        cfgActionsManager.addConfigurableAction("FeatureTypePanel", (Action)new ShowReportAction());
    }

    private void registerInCatalog() {
        final ApplicationManager application = ApplicationLocator.getApplicationManager();
        application.addPropertiesObserver(new Observer(){

            public void update(Observable observable, Object notification) {
                if (!(notification instanceof Notification)) {
                    return;
                }
                String propertyName = (String)((Notification)notification).getValue(0);
                if (!StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Catalog.Manager")) {
                    return;
                }
                DynObject catalogManager = (DynObject)application.getProperty("Catalog.Manager");
                if (catalogManager == null) {
                    return;
                }
                try {
                    String[] catalogNodes;
                    for (String catalogNode : catalogNodes = new String[]{"STORES_REPOSITORY_TABLE", "DATABASE_TABLE", "FOLDERS_FILE", "BOOKMARKS_BOOKMARK"}) {
                        Object action = catalogManager.invokeDynMethod("getAction", new Object[]{"PublishForReportDesigner", catalogNode});
                        if (action != null) continue;
                        catalogManager.invokeDynMethod("addAction", new Object[]{"PublishForReportDesigner", catalogNode, new AddDatasetFromCatalogAction()});
                    }
                }
                catch (Exception ex) {
                    logger.warn("Can't add action to catalog", (Throwable)ex);
                }
            }
        });
    }

    public void execute(String action) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        ReportSwingManager reportSwingManager = ReportSwingLocator.getReportSwingManager();
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"report-publish-layer")) {
            ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (view == null) {
                return;
            }
            final ArrayList layers = new ArrayList();
            try {
                view.getMapContext().getLayers().accept(new Visitor(){

                    public void visit(Object o) throws VisitCanceledException, BaseException {
                        FLayer layer = (FLayer)o;
                        if (layer instanceof FLyrVect && layer.isActive()) {
                            layers.add((FLyrVect)layer);
                        }
                    }
                });
            }
            catch (Exception ex) {
                logger.warn("Can't publish layers.", (Throwable)ex);
            }
            if (!layers.isEmpty()) {
                ReportServerConfig config = this.reportState.getConfig();
                ReportDataSets datasets = config.getDatasets();
                for (FLyrVect layer : layers) {
                    if (datasets.contains(layer.getFeatureStore())) {
                        // empty if block
                    }
                    datasets.add(layer.getName(), layer.getFeatureStore());
                }
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"report-publish-table")) {
            TableDocument doc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
            if (doc == null) {
                return;
            }
            FeatureTableDocumentPanel tablePanel = (FeatureTableDocumentPanel)doc.getMainComponent();
            FeatureStore store = tablePanel.getFeatureStore();
            ReportServerConfig config = this.reportState.getConfig();
            ReportDataSets datasets = config.getDatasets();
            datasets.add(doc.getName(), store);
        }
    }

    public boolean canQueryByAction() {
        return true;
    }

    public boolean isEnabled(String action) {
        ApplicationManager application = ApplicationLocator.getManager();
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"report-publish-layer")) {
            ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (view == null) {
                return false;
            }
            return view.getMapContext().hasActiveVectorLayers();
        }
        return StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"report-publish-table");
    }

    public boolean isVisible(String action) {
        ApplicationManager application = ApplicationLocator.getManager();
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"report-publish-layer")) {
            ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            return view != null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"report-publish-table")) {
            TableDocument doc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
            return doc != null;
        }
        return false;
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    private class ShowReportAction
    extends AbstractAction {
        public ShowReportAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Show_report"));
            this.putValue("ActionCommandKey", "ShowReport");
            this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("report-select-reports"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FeatureTypePanel panel = (FeatureTypePanel)ae.getSource();
            EditableFeatureType featureType = panel.fetch(null);
            FeatureStore store = featureType.getAsFeatureStore();
            ReportManager reportManager = ReportLocator.getReportManager();
            FilesResourcesStorage resourceStorage = new FilesResourcesStorage(FileUtils.getFile((File)ReportExtension.this.getPlugin().getPluginDirectory(), (String[])new String[]{"reports"}).getAbsolutePath());
            ReportConfig reportConfig = reportManager.createReportConfig();
            reportConfig.setReportResourcesStorage((ResourcesStorage)resourceStorage);
            reportConfig.setDataSet(reportManager.createDataSet(store));
            reportConfig.setReportTemplate("featuretype.jasper");
            Report report = reportManager.createReport(reportConfig);
            I18nManager i18n = ToolsLocator.getI18nManager();
            WindowManager winManager = ToolsSwingLocator.getWindowManager();
            ReportSwingManager reportSwingManager = ReportSwingLocator.getReportSwingManager();
            JReport reportPanel = reportSwingManager.createJReport(report);
            reportPanel.asJComponent().setPreferredSize(new Dimension(800, 500));
            winManager.showWindow(reportPanel.asJComponent(), ToolsSwingUtils.makeTitle((String)"_Report", (String)report.getName(), null), WindowManager.MODE.WINDOW);
        }
    }
}

