/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin.document.gui.properties;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.report.app.mainplugin.document.ReportDocument;
import org.gvsig.report.app.mainplugin.document.gui.properties.LocationReportPropertiesPageView;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;

public class LocationReportPropertiesPage
extends LocationReportPropertiesPageView
implements PropertiesPage {
    private final ReportDocument reportDocument;
    private final PickerController<File> file;

    public LocationReportPropertiesPage(ReportDocument reportDocument) {
        this.file = ToolsSwingLocator.getToolsSwingManager().createFilePickerController((JTextComponent)this.txtLocation, this.btnLocation);
        this.reportDocument = reportDocument;
        this.initComponents();
    }

    public void setData(Object data) {
    }

    private void initComponents() {
        this.file.setEditable(false);
        ReportConfig config = this.reportDocument.getReportConfig();
        URL location = config.getReportTemplateAsURL();
        if (StringUtils.equalsIgnoreCase((CharSequence)location.getProtocol(), (CharSequence)"file")) {
            try {
                this.file.set((Object)new File(location.toURI()));
            }
            catch (URISyntaxException ex) {
                this.file.set(null);
            }
        } else {
            this.file.set(null);
        }
        this.txtDataSet.setText(this.reportDocument.getReportConfig().getDataSetName());
        this.txtDataSet.setEditable(false);
    }

    public boolean whenAccept() {
        return this.whenApply();
    }

    public boolean whenApply() {
        return true;
    }

    public boolean whenCancel() {
        return true;
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Location");
    }

    public int getPriority() {
        return 990;
    }

    public JComponent asJComponent() {
        return this;
    }

    public ReportDocument getDocument() {
        return this.reportDocument;
    }
}

