/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonObject;
import javax.servlet.http.HttpServlet;
import org.apache.commons.io.output.CloseShieldWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.Factory;
import org.gvsig.tools.util.HasAFile;
import org.gvsig.tools.util.ListBuilder;
import org.gvsig.vcsgis.lib.RandomCodeGenerator;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisCodeGenerator;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisIdentityManager;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisPreparedWorkingCopyInformation;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatusImpl;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserIdentificationRequester;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisIdentityController;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisAuthenticateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisListWCRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisPrepareWCRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.VCSGisServerController;
import org.gvsig.vcsgis.lib.server.VCSGisServerControllerImpl;
import org.gvsig.vcsgis.lib.server.servlets.HookTestServlet;
import org.gvsig.vcsgis.lib.server.servlets.RepoInfoServlet;
import org.gvsig.vcsgis.lib.server.servlets.SimpleWFSServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisAuthenticateServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisCheckoutServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisCommitServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisDownloadWCServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisEntitiesServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisHistoryServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisListWCServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisLogServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisPrepareWCServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisRowCreateServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisRowDeleteServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisRowIsOutofdateServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisRowUpdateServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisTopologyPlansServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisUpdateServlet;
import org.gvsig.vcsgis.lib.server.servlets.VCSGisUsersServlet;
import org.gvsig.vcsgis.lib.workspace.FeatureStoreObserver;
import org.gvsig.vcsgis.lib.workspace.StoreProperties;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceDescriptor;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceDescriptorImpl;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceImpl;
import org.gvsig.vcsgis.lib.workspace.tables.EntitiesTable;
import org.gvsig.vcsgis.lib.workspace.tables.LocalRevisionsTable;
import org.gvsig.vcsgis.lib.workspace.tables.RemoteChangesTable;
import org.gvsig.vcsgis.lib.workspace.tables.TopologyplanTable;
import org.gvsig.vcsgis.lib.workspace.tables.UsersTable;
import org.gvsig.vcsgis.lib.workspace.tables.VarsTable;
import org.gvsig.vcsgis.lib.workspace.tables.WorkspaceChangesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisManagerImpl
implements VCSGisManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisManagerImpl.class);
    public static final List<String> INTERNAL_WORKSPACE_TABLES = ListBuilder.create((Object[])new Object[]{"VCSGIS_ENTITIES", "VCSGIS_LOCALREVISIONS", "VCSGIS_REMOTECHANGES", "VCSGIS_CONFIG", "VCSGIS_WSCHANGES", "VCSGIS_USERS", "VCSGIS_TOPOLOGYPLANS", "GVSIGD_RESOURCES", "GVSIGD_CONFIG", "GVSIGD_REPOSITORY"});
    public static final List<String> INTERNAL_REPOSITORY_TABLES = ListBuilder.create((Object[])new Object[]{"VCSGISREPO_DATA", "VCSGISREPO_ENTITIES", "VCSGISREPO_HOOKS", "VCSGISREPO_REVISIONS", "VCSGISREPO_CONFIG", "VCSGISREPO_TOPOLOGYPLANS", "VCSGISREPO_USERS", "GVSIGD_RESOURCES", "GVSIGD_CONFIG", "GVSIGD_REPOSITORY"});
    private Map<String, VCSGisWorkspaceDescriptor> workspaces = new HashMap<String, VCSGisWorkspaceDescriptor>();
    private VCSGisCodeGenerator codeGenerator = new RandomCodeGenerator();
    private VCSGisUserIdentificationRequester userIdentificationRequester = null;
    private Factory<VCSGisAuthenticateRequest> authenticateRequestFactory;
    private Factory<VCSGisIdentityController> identityControllerFactory;
    private Writer writerForProtocolDebugging;

    public VCSGisManagerImpl() {
        ToolsLocator.registerIdentityManager(VCSGisIdentityManager.class);
    }

    public synchronized void clean() {
        for (VCSGisWorkspaceDescriptor workspace : this.workspaces.values()) {
            DisposeUtils.disposeQuietly((Disposable)workspace);
        }
        this.workspaces = new HashMap<String, VCSGisWorkspaceDescriptor>();
        this.codeGenerator = new RandomCodeGenerator();
        this.userIdentificationRequester = null;
    }

    public Map<String, VCSGisWorkspaceDescriptor> getWorkspaces() {
        return Collections.unmodifiableMap(this.workspaces);
    }

    public synchronized void restoreWorkspaces(Map<String, VCSGisWorkspaceDescriptor> descriptors) {
        this.workspaces = new HashMap<String, VCSGisWorkspaceDescriptor>();
        if (descriptors != null) {
            this.workspaces.putAll(descriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initWorkspace(File wsfile, VCSGisRepository repo, String label, SimpleTaskStatus status) {
        int n;
        int err = 0;
        if (wsfile == null) {
            return 1;
        }
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("vcsgis init_workingcopy");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        DataManager dataManager = DALLocator.getDataManager();
        JDBCServerExplorer explorer = null;
        try {
            wsfile = this.removeH2FileExtension(wsfile);
            if (StringUtils.isBlank((CharSequence)label)) {
                label = wsfile.getName();
            }
            err = 4;
            JDBCServerExplorerParameters explorerParams = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)explorerParams).setFile(wsfile);
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParams.getProviderName(), (DataServerExplorerParameters)explorerParams);
            n = this.initWorkspace(explorer, repo, label, status);
        }
        catch (Exception ex) {
            int n2;
            try {
                status.abort();
                LOGGER.warn("Can't init workspace in '" + wsfile.getAbsolutePath() + "'.", (Throwable)ex);
                status.message(ex.getMessage());
                n2 = err;
            }
            catch (Throwable throwable) {
                status.pop();
                DisposeUtils.disposeQuietly(explorer);
                throw throwable;
            }
            status.pop();
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return n2;
        }
        status.pop();
        DisposeUtils.disposeQuietly((Disposable)explorer);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int initWorkspace(JDBCServerExplorer wsexplorer, VCSGisRepository repository, String label, SimpleTaskStatus status) {
        int n;
        int err = 0;
        if (wsexplorer == null) {
            return 2;
        }
        if (StringUtils.isBlank((CharSequence)label)) {
            return 6;
        }
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("vcsgis init_workingcopy");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        LOGGER.info("Initializing workspace " + Objects.toString(wsexplorer.getParameters().toJson()).replace('\n', ' ').replaceAll("\"password\":\"[^\"]*\"", "\"password\":\"****\""));
        DataManager dataManager = DALLocator.getDataManager();
        VCSGisWorkspaceImpl workspace = null;
        try {
            status.setTitle("vcsgis init_workingcopy");
            DatabaseWorkspaceManager databaseWorkspaceManager = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)wsexplorer.getParameters());
            if (!databaseWorkspaceManager.existsTable(2)) {
                databaseWorkspaceManager.createTable(2);
            }
            if (!databaseWorkspaceManager.existsTable(0)) {
                databaseWorkspaceManager.createTable(0);
            }
            if (!databaseWorkspaceManager.existsTable(1)) {
                databaseWorkspaceManager.createTable(1);
                databaseWorkspaceManager.set("StoresRepository.id", "VCSGIS");
            }
            databaseWorkspaceManager.connect();
            FeatureType[] tables = new FeatureType[]{VarsTable.featureType(), EntitiesTable.featureType(), WorkspaceChangesTable.featureType(), RemoteChangesTable.featureType(), LocalRevisionsTable.featureType(), UsersTable.featureType(), TopologyplanTable.featureType()};
            status.setRangeOfValues(0L, (long)tables.length);
            int step = 1;
            for (FeatureType table : tables) {
                status.message(table.getLabel());
                status.setCurValue((long)step++);
                err = 100 + step;
                JDBCNewStoreParameters table_params = wsexplorer.getAddParameters();
                table_params.setDefaultFeatureType((FeatureType)table.getEditable());
                String tableName = table.getTags().getString("ID");
                table_params.setTable(tableName);
                wsexplorer.add(wsexplorer.getProviderName(), (NewDataStoreParameters)table_params, false);
                JDBCStoreParameters openParams = wsexplorer.get(tableName);
                databaseWorkspaceManager.writeStoresRepositoryEntry(tableName, (DataStoreParameters)openParams);
            }
            try {
                wsexplorer.execute(VCSGisUtils.getSqlTemplate(wsexplorer.getProviderName(), "createWorkspaceIndex1", new Object[0]));
                wsexplorer.execute(VCSGisUtils.getSqlTemplate(wsexplorer.getProviderName(), "createWorkspaceIndex2", new Object[0]));
                wsexplorer.execute(VCSGisUtils.getSqlTemplate(wsexplorer.getProviderName(), "createWorkspaceIndex3", new Object[0]));
            }
            catch (Exception ex) {
                LOGGER.warn("Can't create index in workspace", (Throwable)ex);
            }
            status.setTitle("vcsgis retrieving entities");
            workspace = new VCSGisWorkspaceImpl(wsexplorer, this.codeGenerator, repository, label);
            if (workspace.getUserIdentificationRequester() == null) {
                workspace.setUserIdentificationRequester(this.userIdentificationRequester);
            }
            workspace.initialize();
            LOGGER.info("Workspace initialized " + workspace.getCode());
            this.registerWorkspace(workspace);
            status.terminate();
            n = 0;
            status.pop();
        }
        catch (UserCancelledException ex) {
            status.cancel();
            LOGGER.warn("Cancelled by user (" + this.getMessageLabel(wsexplorer) + ").", (Throwable)ex);
            status.message("Cancelled by user.");
            throw ex;
            catch (Exception ex2) {
                status.abort();
                LOGGER.warn("Can't init workspace in '" + this.getMessageLabel(wsexplorer) + "'.", (Throwable)ex2);
                status.message(ex2.getMessage());
                int n2 = err;
                return n2;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)workspace);
        return n;
        finally {
            status.pop();
            DisposeUtils.disposeQuietly(workspace);
        }
    }

    private String getMessageLabel(JDBCServerExplorer explorer) {
        return explorer.getParameters().getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized VCSGisWorkspace openWorkspace(File wsfile) {
        if (wsfile == null) {
            return null;
        }
        JDBCServerExplorer explorer = null;
        try {
            VCSGisWorkspace workspace;
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters explorerParams = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)explorerParams).setFile(wsfile);
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParams.getProviderName(), (DataServerExplorerParameters)explorerParams);
            VCSGisWorkspace vCSGisWorkspace = workspace = this.openWorkspace(explorer);
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return vCSGisWorkspace;
        }
        catch (Exception ex) {
            VCSGisWorkspace vCSGisWorkspace = null;
            return vCSGisWorkspace;
        }
        finally {
            DisposeUtils.disposeQuietly(explorer);
        }
    }

    public VCSGisWorkspace openWorkspace(JDBCServerExplorer wsexplorer) {
        return this.openWorkspace(wsexplorer, true);
    }

    public synchronized VCSGisWorkspace openWorkspace(JDBCServerExplorer wsexplorer, boolean useCache) {
        if (wsexplorer == null) {
            LOGGER.warn("Can't open workspace, explorer is null");
            return null;
        }
        JDBCServerExplorerParameters params = null;
        try {
            VCSGisWorkspaceImpl workspace;
            LOGGER.info("openWorkspace(" + wsexplorer.getParameters().getUrl() + ")");
            if (useCache) {
                params = wsexplorer.getParameters();
                String url = params.getUrl();
                Iterator<VCSGisWorkspaceDescriptor> iterator = this.workspaces.values().iterator();
                while (iterator.hasNext()) {
                    VCSGisWorkspaceDescriptorImpl value = (VCSGisWorkspaceDescriptorImpl)iterator.next();
                    if (value.isDisposed()) {
                        iterator.remove();
                        continue;
                    }
                    LOGGER.info("openWorkspace: check " + value.getDebugInfo());
                    if (!value.isWorkspaceInitialized() || !StringUtils.equals((CharSequence)url, (CharSequence)value.getExplorerParameters().getUrl())) continue;
                    LOGGER.info("openWorkspace: reuse the workspace from the descriptor");
                    VCSGisWorkspace workspace2 = value.getWorkspace();
                    if (workspace2.getUserIdentificationRequester() == null) {
                        workspace2.setUserIdentificationRequester(this.userIdentificationRequester);
                    }
                    this.dropExpiredCaches();
                    return workspace2;
                }
                LOGGER.info("openWorkspace: open new workspace");
                workspace = new VCSGisWorkspaceImpl(wsexplorer, this.codeGenerator);
                workspace.setUserIdentificationRequester(this.userIdentificationRequester);
                this.registerWorkspace(workspace);
            } else {
                LOGGER.info("openWorkspace: open new workspace (don't use cache)");
                workspace = new VCSGisWorkspaceImpl(wsexplorer, this.codeGenerator);
                workspace.setUserIdentificationRequester(this.userIdentificationRequester);
            }
            this.dropExpiredCaches();
            return workspace;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get workspace from " + Objects.toString(params) + ".", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized VCSGisWorkspace openWorkspace(File wsfile, String label) {
        if (wsfile == null) {
            return null;
        }
        JDBCServerExplorer explorer = null;
        try {
            VCSGisWorkspace workspace;
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters explorerParams = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)explorerParams).setFile(wsfile);
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParams.getProviderName(), (DataServerExplorerParameters)explorerParams);
            VCSGisWorkspace vCSGisWorkspace = workspace = this.openWorkspace(explorer, label);
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return vCSGisWorkspace;
        }
        catch (Exception ex) {
            VCSGisWorkspace vCSGisWorkspace = null;
            return vCSGisWorkspace;
        }
        finally {
            DisposeUtils.disposeQuietly(explorer);
        }
    }

    public synchronized VCSGisWorkspace openWorkspace(JDBCServerExplorer wsexplorer, String label) {
        if (wsexplorer == null) {
            return null;
        }
        JDBCServerExplorerParameters params = null;
        try {
            params = wsexplorer.getParameters();
            VCSGisWorkspaceImpl workspace = new VCSGisWorkspaceImpl(wsexplorer, this.codeGenerator, label);
            workspace.setUserIdentificationRequester(this.userIdentificationRequester);
            this.registerWorkspace(workspace);
            this.dropExpiredCaches();
            return workspace;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get workspace from " + Objects.toString(params) + ".", (Throwable)ex);
            return null;
        }
    }

    public synchronized void registerWorkspace(VCSGisWorkspace workspace) {
        LOGGER.info("registerWorkspace(" + ((VCSGisWorkspaceImpl)workspace).getDebugInfo() + ")");
        VCSGisWorkspaceDescriptorImpl descriptor = (VCSGisWorkspaceDescriptorImpl)this.workspaces.get(workspace.getCode());
        if (descriptor == null) {
            LOGGER.info("Descriptor not found, create and register");
            descriptor = new VCSGisWorkspaceDescriptorImpl(workspace);
            this.workspaces.put(workspace.getCode(), descriptor);
        } else if (descriptor.isDisposed()) {
            LOGGER.info("Descriptor is disposed, create and replace. " + descriptor.getDebugInfo());
            descriptor = new VCSGisWorkspaceDescriptorImpl(workspace);
            this.workspaces.put(workspace.getCode(), descriptor);
        } else {
            LOGGER.info("Found descriptor, update your workspace. " + descriptor.getDebugInfo());
            descriptor.setWorkspace(workspace);
        }
    }

    public synchronized void deregisterWorkspace(File dbfile) {
        Path dbpath = dbfile.toPath();
        ArrayList<String> wscodes = new ArrayList<String>();
        Iterator<VCSGisWorkspaceDescriptor> iterator = this.workspaces.values().iterator();
        while (iterator.hasNext()) {
            VCSGisWorkspaceDescriptorImpl descriptor = (VCSGisWorkspaceDescriptorImpl)iterator.next();
            if (descriptor.isDisposed()) {
                iterator.remove();
                continue;
            }
            JDBCServerExplorerParameters explorerParams = descriptor.getExplorerParameters();
            if (!(explorerParams instanceof HasAFile)) continue;
            try {
                Path p = ((HasAFile)explorerParams).getFile().toPath();
                if (!Files.isSameFile(dbpath, p)) continue;
                wscodes.add(descriptor.getCode());
            }
            catch (IOException ex) {
                LOGGER.debug("Can't deregister workspace '" + dbfile.getAbsolutePath() + "'.", (Throwable)ex);
            }
        }
        for (String wscode : wscodes) {
            this.deregisterWorkspace(wscode);
        }
    }

    public void deregisterWorkspace(VCSGisWorkspace workspace) {
        if (workspace == null) {
            LOGGER.info("deregisterWorkspace NULL");
            return;
        }
        LOGGER.info("deregisterWorkspace " + ((VCSGisWorkspaceImpl)workspace).getDebugInfo());
        this.deregisterWorkspace(workspace.getCode());
    }

    public synchronized void deregisterWorkspace(String workspaceCode) {
        VCSGisWorkspaceDescriptor descriptor = this.workspaces.get(workspaceCode);
        if (descriptor == null) {
            LOGGER.info("deregisterWorkspace(" + workspaceCode + ", NULL)");
            return;
        }
        LOGGER.info("deregisterWorkspace(" + workspaceCode + ", " + ((VCSGisWorkspaceDescriptorImpl)descriptor).getDebugInfo() + ")");
        DisposeUtils.disposeQuietly((Disposable)descriptor);
        this.workspaces.remove(workspaceCode);
        this.dropExpiredCaches();
    }

    private void dropExpiredCaches() {
        Iterator<VCSGisWorkspaceDescriptor> iterator = this.workspaces.values().iterator();
        while (iterator.hasNext()) {
            VCSGisWorkspaceDescriptorImpl value = (VCSGisWorkspaceDescriptorImpl)iterator.next();
            if (value.isDisposed()) {
                iterator.remove();
                continue;
            }
            value.dropExpiredCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized VCSGisWorkspace getWorkspace(FeatureStore store) {
        try {
            VCSGisWorkspaceImpl workspace;
            switch (StoreProperties.getVCSMode(store)) {
                case 2: {
                    return null;
                }
                case 1: {
                    String workspace_code = StoreProperties.getWorkspaceCode(store);
                    VCSGisWorkspaceDescriptor workspaceDescriptor = this.workspaces.get(workspace_code);
                    if (workspaceDescriptor == null || (workspace = (VCSGisWorkspaceImpl)workspaceDescriptor.getWorkspace()) == null) break;
                    if (workspace.isInStoreIgnoreChanges(store)) {
                        return workspace;
                    }
                    String entity_name = StoreProperties.getEntityName(store);
                    EntitiesTable.EntityRow entity = workspace.getWorkspaceEntityByName(entity_name);
                    if (entity == null) {
                        StoreProperties.setNotVCSMode(store);
                        DisposeUtils.dispose((Disposable)workspace);
                        return null;
                    }
                    if (!workspace.isCorrupt((VCSGisEntity)entity, store, 0)) return workspace;
                    return workspace;
                }
            }
            DataStoreParameters params = store.getParameters();
            if (!(params instanceof JDBCStoreParameters)) {
                StoreProperties.setNotVCSMode(store);
                return null;
            }
            String entity_name = ((JDBCStoreParameters)params).getTable();
            if (INTERNAL_WORKSPACE_TABLES.contains(entity_name) || INTERNAL_REPOSITORY_TABLES.contains(entity_name)) {
                StoreProperties.setNotVCSMode(store);
                return null;
            }
            String storeUrl = ((JDBCStoreParameters)params).getUrl();
            ArrayList<VCSGisWorkspaceDescriptor> descriptors = new ArrayList<VCSGisWorkspaceDescriptor>(this.workspaces.values());
            for (VCSGisWorkspaceDescriptor value : descriptors) {
                JDBCServerExplorerParameters explorerParams;
                if (value == null || (explorerParams = value.getExplorerParameters()) == null || !StringUtils.equals((CharSequence)storeUrl, (CharSequence)explorerParams.getUrl()) || (workspace = (VCSGisWorkspaceImpl)value.getWorkspace()) == null) continue;
                EntitiesTable.EntityRow entity = workspace.getWorkspaceEntityByName(entity_name);
                if (entity == null) {
                    StoreProperties.setNotVCSMode(store);
                    DisposeUtils.dispose((Disposable)workspace);
                    return null;
                }
                StoreProperties.set(store, workspace, entity_name);
                if (!workspace.isCorrupt((VCSGisEntity)entity, store, 0)) return workspace;
                return workspace;
            }
            JDBCServerExplorer explorer = null;
            try {
                explorer = (JDBCServerExplorer)store.getExplorer();
                if (!this.isWorkspace(explorer.getParameters())) {
                    VCSGisWorkspaceDescriptor value;
                    StoreProperties.setNotVCSMode(store);
                    value = null;
                    return value;
                }
                workspace = (VCSGisWorkspaceImpl)this.openWorkspace(explorer);
            }
            catch (Exception e) {
                workspace = null;
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)explorer);
            }
            if (workspace == null) {
                StoreProperties.setNotVCSMode(store);
                return null;
            }
            this.registerWorkspace(workspace);
            EntitiesTable.EntityRow entity = workspace.getWorkspaceEntityByName(entity_name);
            if (entity == null) {
                StoreProperties.setNotVCSMode(store);
                return null;
            }
            StoreProperties.set(store, workspace, entity_name);
            this.addToIdentityManager(workspace);
            return workspace;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get '" + store.getName() + "'store's workspace ", (Throwable)ex);
            StoreProperties.setUnknownVCSMode(store);
            throw new RuntimeException("Can't get '" + store.getName() + "'store's workspace ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepository(JDBCServerExplorerParameters params) {
        boolean bl;
        DataServerExplorer explorer = null;
        try {
            DataManager dataManager = DALLocator.getDataManager();
            explorer = dataManager.openServerExplorer(params.getProviderName(), (DataServerExplorerParameters)params);
            DataStoreParameters x = explorer.get("VCSGISREPO_CONFIG");
            if (x == null) {
                boolean bl2 = false;
                DisposeUtils.disposeQuietly((Disposable)explorer);
                return bl2;
            }
            bl = explorer.exists(x);
            DisposeUtils.disposeQuietly((Disposable)explorer);
        }
        catch (Exception ex) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            DisposeUtils.disposeQuietly(explorer);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorkspace(JDBCServerExplorerParameters params) {
        boolean bl;
        DataServerExplorer explorer = null;
        try {
            DataManager dataManager = DALLocator.getDataManager();
            explorer = dataManager.openServerExplorer(params.getProviderName(), (DataServerExplorerParameters)params);
            DataStoreParameters x = explorer.get("VCSGIS_CONFIG");
            if (x == null) {
                boolean bl2 = false;
                DisposeUtils.disposeQuietly((Disposable)explorer);
                return bl2;
            }
            bl = explorer.exists(x);
            DisposeUtils.disposeQuietly((Disposable)explorer);
        }
        catch (Exception ex) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            DisposeUtils.disposeQuietly(explorer);
        }
        return bl;
    }

    public boolean isWorkspace(File dbfile) {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters params = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)params).setFile(dbfile);
            return this.isWorkspace(params);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private File removeH2FileExtension(File f) {
        if (f == null) {
            return null;
        }
        String pathname = f.getAbsolutePath();
        String lpathname = pathname.toLowerCase();
        for (String ext : new String[]{".mv.db", ".mv", ".trace.db", ".trace"}) {
            if (!lpathname.endsWith(ext)) continue;
            pathname = pathname.substring(0, pathname.length() - ext.length());
            return new File(pathname);
        }
        return f;
    }

    public static String hexId(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        return Integer.toHexString(obj.hashCode()).toUpperCase();
    }

    public synchronized VCSGisWorkspaceDescriptor getWorkspaceDescriptor(String code) {
        VCSGisWorkspaceDescriptor descriptor = this.workspaces.get(code);
        if (descriptor != null) {
            DisposeUtils.bind((Disposable)descriptor);
            return descriptor;
        }
        for (VCSGisWorkspaceDescriptor descriptor2 : this.workspaces.values()) {
            if (descriptor2 == null || !StringUtils.equalsIgnoreCase((CharSequence)descriptor2.getLabel(), (CharSequence)code)) continue;
            DisposeUtils.bind((Disposable)descriptor2);
            return descriptor2;
        }
        return null;
    }

    public int initRepository(JDBCServerExplorerParameters repositoryParameters, SimpleTaskStatus status) {
        return VCSGisRepositoryLocaldbImpl.create(repositoryParameters, this.codeGenerator, CRSFactory.getCRS((String)"EPSG:25830"), null, true, status);
    }

    public int initRepository(JDBCServerExplorerParameters repositoryParameters, IProjection crs, Envelope tablebbox, boolean indexGeometries, SimpleTaskStatus status) {
        return VCSGisRepositoryLocaldbImpl.create(repositoryParameters, this.codeGenerator, crs, tablebbox, indexGeometries, status);
    }

    public VCSGisRepositoryLocaldbImpl openRepository(JDBCServerExplorerParameters repositoryParameters) {
        return new VCSGisRepositoryLocaldbImpl(repositoryParameters, this.codeGenerator);
    }

    public VCSGisRepository openRepository(URL repository) {
        return new VCSGisRepositoryClientImpl(repository, this.authenticateRequestFactory);
    }

    public VCSGisRepository openRepository(JsonObject jsonrepo) {
        String klassName = jsonrepo.getString("__classname__", null);
        if (StringUtils.equals((CharSequence)klassName, (CharSequence)VCSGisRepositoryClientImpl.class.getName())) {
            VCSGisRepositoryClientImpl repo = new VCSGisRepositoryClientImpl();
            repo.fromJson(jsonrepo);
            return repo;
        }
        if (StringUtils.equals((CharSequence)klassName, (CharSequence)VCSGisRepositoryLocaldbImpl.class.getName())) {
            VCSGisRepositoryLocaldbImpl repo = new VCSGisRepositoryLocaldbImpl();
            repo.fromJson(jsonrepo);
            return repo;
        }
        throw new IllegalArgumentException("Illegal jsonrepo");
    }

    public VCSGisServerController createServerController(VCSGisRepository repository) {
        return new VCSGisServerControllerImpl(repository);
    }

    public void setCodeGenerator(VCSGisCodeGenerator generator) {
        this.codeGenerator = generator;
    }

    public VCSGisCodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public String getErrorMessage(int errcode) {
        return VCSGisUtils.getErrorMessage(errcode);
    }

    public void setUserIdentificationRequester(VCSGisUserIdentificationRequester userIdentificationRequester) {
        this.userIdentificationRequester = userIdentificationRequester;
    }

    public VCSGisUserIdentificationRequester getUserIdentificationRequester() {
        return this.userIdentificationRequester;
    }

    public void setAuthenticateRequestFactory(Factory<VCSGisAuthenticateRequest> authenticateRequestFactory) {
        this.authenticateRequestFactory = authenticateRequestFactory;
    }

    public Factory<VCSGisAuthenticateRequest> getAuthenticateRequestFactory() {
        return this.authenticateRequestFactory;
    }

    public void setIdentityControllertFactory(Factory<VCSGisIdentityController> IdentityControllerFactory) {
        this.identityControllerFactory = IdentityControllerFactory;
    }

    public Factory<VCSGisIdentityController> getIdentityControllerFactory() {
        return this.identityControllerFactory;
    }

    public VCSGisTopologyPlanStatus createTopologyPlanStatus(String topologyPlanCode, String hashCode, boolean passed) {
        return new VCSGisTopologyPlanStatusImpl(topologyPlanCode, hashCode, passed);
    }

    public Class<? extends HttpServlet> getServletClass(String name) {
        switch (name) {
            case "repoinfo": {
                return RepoInfoServlet.class;
            }
            case "entities": {
                return VCSGisEntitiesServlet.class;
            }
            case "listwc": {
                return VCSGisListWCServlet.class;
            }
            case "preparewc": {
                return VCSGisPrepareWCServlet.class;
            }
            case "downloadwc": {
                return VCSGisDownloadWCServlet.class;
            }
            case "commit": {
                return VCSGisCommitServlet.class;
            }
            case "checkout": {
                return VCSGisCheckoutServlet.class;
            }
            case "history": {
                return VCSGisHistoryServlet.class;
            }
            case "update": {
                return VCSGisUpdateServlet.class;
            }
            case "authenticate": {
                return VCSGisAuthenticateServlet.class;
            }
            case "users": {
                return VCSGisUsersServlet.class;
            }
            case "topologyplans": {
                return VCSGisTopologyPlansServlet.class;
            }
            case "rowcreate": {
                return VCSGisRowCreateServlet.class;
            }
            case "rowupdate": {
                return VCSGisRowUpdateServlet.class;
            }
            case "rowdelete": {
                return VCSGisRowDeleteServlet.class;
            }
            case "rowisoutofdate": {
                return VCSGisRowIsOutofdateServlet.class;
            }
            case "hooktest": {
                return HookTestServlet.class;
            }
            case "simplewfs": {
                return SimpleWFSServlet.class;
            }
            case "log": {
                return VCSGisLogServlet.class;
            }
        }
        throw new IllegalArgumentException("Servlet '" + name + "' not recognized");
    }

    public List<VCSGisPreparedWorkingCopyInformation> getPreparedWorkingCopyInformation(URL server) {
        VCSGisListWCRequest request;
        VCSGisRepository repo = this.openRepository(server);
        if (repo.execute((VCSGisRequest)(request = repo.createListWCRequest())) != 0) {
            return Collections.EMPTY_LIST;
        }
        return request.getWorkingCopiesInformation();
    }

    public List<VCSGisPreparedWorkingCopyInformation> getPreparedWorkingCopyInformation(JDBCServerExplorerParameters repositoryParameters) {
        VCSGisListWCRequest request;
        VCSGisRepositoryLocaldbImpl repo = this.openRepository(repositoryParameters);
        if (repo.execute((VCSGisRequest)(request = repo.createListWCRequest())) != 0) {
            return Collections.EMPTY_LIST;
        }
        return request.getWorkingCopiesInformation();
    }

    public int preparedWorkingCopy(URL server, String name, String label, String categories, String username, String userpass) {
        VCSGisRepository repo = this.openRepository(server);
        VCSGisPrepareWCRequest request = repo.createPrepareWCRequest();
        request.setName(name);
        request.setLabel(label);
        request.setCategories(categories);
        request.setUserName(username);
        request.setUserPass(userpass);
        int n = repo.execute((VCSGisRequest)request);
        return n;
    }

    public List<Pair<WeakReference<FeatureStore>, Integer>> getEditingStores() {
        return FeatureStoreObserver.getInEditingList();
    }

    public void forceRemoveFromEditingStores(FeatureStore store) {
    }

    public boolean isThereAnyStoreInEditing() {
        return FeatureStoreObserver.isThereAnyStoreInEditing();
    }

    public boolean IsThereConflictingStoresInEdition() {
        return FeatureStoreObserver.IsThereConflictingStoresInEdition();
    }

    public void setWriterForProtocolDebugging(Writer writer) {
        this.writerForProtocolDebugging = writer;
    }

    public Writer getWriterForProtocolDebugging() {
        if (this.writerForProtocolDebugging == null) {
            return null;
        }
        return CloseShieldWriter.wrap((Writer)this.writerForProtocolDebugging);
    }

    public synchronized void addToIdentityManager(VCSGisWorkspace workspace) {
        try {
            VCSGisIdentityManager identityManager = (VCSGisIdentityManager)ToolsLocator.getIdentityManager();
            VCSGisUser user = ((VCSGisWorkspaceImpl)workspace).getCurrentUser();
            if (user == null) {
                user = VCSGisUser.GUEST;
            }
            identityManager.setCurrentUser(workspace, user);
        }
        catch (Throwable t) {
            LOGGER.warn("Can't register workspace in the identity manager", t);
        }
    }
}

