/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.identityControllerLDAP;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang3.StringUtils;

public class LDAPUtils {
    public static LDAPContext createLDAPContext(String ldapurl, String userTemplate) {
        return new LDAPContextImpl(ldapurl, userTemplate);
    }

    public static LDAPContext createLDAPContext(String ldapurl, String userTemplate, String searchGroupsFilterTemplate) {
        return new LDAPContextImpl(ldapurl, userTemplate, searchGroupsFilterTemplate);
    }

    public static boolean authenticate(LDAPContext context, String user, String password) {
        LDAPContextImpl context1 = (LDAPContextImpl)context;
        context1.username = user;
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        props.put("java.naming.provider.url", context1.ldapurl);
        if (user.startsWith("uid=")) {
            props.put("java.naming.security.principal", user);
        } else {
            props.put("java.naming.security.principal", String.format(context1.userTemplate, user));
        }
        props.put("java.naming.security.credentials", password);
        try {
            context1.context = new InitialDirContext(props);
            return true;
        }
        catch (NamingException ex) {
            return false;
        }
    }

    public static List<String> groups(LDAPContext context, String searchGroupsName) {
        LDAPContextImpl context1 = (LDAPContextImpl)context;
        if (StringUtils.isBlank((CharSequence)searchGroupsName) || StringUtils.isBlank((CharSequence)context1.searchGroupsFilterTemplate)) {
            return Collections.EMPTY_LIST;
        }
        try {
            SearchControls ctrls = new SearchControls();
            ctrls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = context1.context.search(searchGroupsName, String.format(context1.searchGroupsFilterTemplate, context1.username), ctrls);
            String fullusername = String.format(context1.userTemplate, context1.username);
            ArrayList<String> groups = new ArrayList<String>();
            while (results.hasMore()) {
                SearchResult result = results.next();
                Attribute groupname = result.getAttributes().get("cn");
                Attribute member = result.getAttributes().get("member");
                for (int idx = 0; idx < member.size(); ++idx) {
                    if (!fullusername.equals(member.get(idx))) continue;
                    groups.add(groupname.get().toString());
                }
            }
            return groups;
        }
        catch (NamingException ex) {
            return null;
        }
    }

    private static class LDAPContextImpl
    implements LDAPContext {
        private String ldapurl;
        private String userTemplate;
        private String searchGroupsFilterTemplate;
        private InitialDirContext context;
        private String username;

        private LDAPContextImpl(String ldapurl, String userTemplate) {
            this.ldapurl = ldapurl;
            this.userTemplate = userTemplate;
        }

        private LDAPContextImpl(String ldapurl, String userTemplate, String searchGroupsFilterTemplate) {
            this(ldapurl, userTemplate);
            this.searchGroupsFilterTemplate = searchGroupsFilterTemplate;
        }

        @Override
        public String getUser() {
            return this.username;
        }
    }

    public static interface LDAPContext {
        public String getUser();
    }
}

