/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.identityControllerOIDC;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.gvsig.vcsgis.lib.SupportError;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisIdentityController;
import org.gvsig.vcsgis.lib.repository.localdb.AbstractIdentityController;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.ConfigRepoTable;

public class IdentityControllerOIDC
extends AbstractIdentityController
implements VCSGisIdentityController {
    private static final LRUMap<String, MutablePair<VCSGisUser, LocalDateTime>> users_cache = new LRUMap(100);
    String baseUrl = "http://...keycloak_url";
    String realm = "realm";
    String scope = "scope";
    String clientid = "client";
    int minutes_of_user_in_cache = 5;
    boolean extend_user_in_cache = true;
    String operations_prefix = null;
    String roles_prefix = null;
    String userid_key = "username";

    public IdentityControllerOIDC(VCSGisRepositoryLocaldbImpl repo) {
        super(repo);
        ConfigRepoTable varsTable = new ConfigRepoTable();
        Map<String, String> vars = varsTable.getVars(repo, "OIDC_BASEURL", "OIDC_REALM", "OIDC_SCOPE", "OIDC_CLIENT", "OIDC_MINUTES_OF_USER_IN_CACHE", "OIDC_EXTEND_USER_IN_CACHE", "OIDC_OPERATIONS_PREFIX", "OIDC_ROLES_PREFIX", "OIDC_USERID_KEY");
        this.baseUrl = vars.get("OIDC_BASEURL");
    }

    @Override
    protected synchronized VCSGisUser getUser(String authenticationToken, String userCode) {
        JsonObject userInfo;
        MutablePair x = (MutablePair)users_cache.get((Object)authenticationToken);
        if (x != null) {
            if (((LocalDateTime)x.getRight()).plusMinutes(this.minutes_of_user_in_cache).isAfter(LocalDateTime.now())) {
                if (this.extend_user_in_cache) {
                    x.setRight((Object)LocalDateTime.now());
                }
                return (VCSGisUser)x.getLeft();
            }
            users_cache.remove((Object)authenticationToken);
        }
        if ((userInfo = this.getUserInfo(authenticationToken)) != null) {
            VCSGisUserImpl user = new VCSGisUserImpl();
            ArrayList<String> operations = new ArrayList<String>();
            ArrayList<String> roles = new ArrayList<String>();
            JsonArray x2 = userInfo.getJsonObject("realm_access").getJsonArray("roles");
            for (JsonValue role0 : x2) {
                JsonString role = (JsonString)role0;
                if (StringUtils.isBlank((CharSequence)this.operations_prefix) || StringUtils.startsWith((CharSequence)role.getString(), (CharSequence)(this.operations_prefix + "_"))) {
                    operations.add(role.getString());
                }
                if (!StringUtils.isBlank((CharSequence)this.roles_prefix) && !StringUtils.startsWith((CharSequence)role.getString(), (CharSequence)(this.roles_prefix + "_"))) continue;
                roles.add(role.getString());
            }
            user.setIdentifier(userInfo.getString(this.userid_key, null));
            user.setAllowedOperations(StringUtils.join(operations, (String)","));
            user.setRoles(StringUtils.join(roles, (String)","));
            users_cache.put((Object)authenticationToken, (Object)new MutablePair((Object)user, (Object)LocalDateTime.now()));
            return user;
        }
        return null;
    }

    @Override
    protected int checkToken(String authenticationToken, String userCode, SupportError error) {
        if (this.getUser(authenticationToken, userCode) == null) {
            return 20;
        }
        return 0;
    }

    private JsonObject getUserInfo(String token) {
        return null;
    }
}

