/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.sql.Timestamp;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.DisposableIterableAdapter;
import org.gvsig.vcsgis.lib.EntityEditableImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.DataRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.RevisionsRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.TopologyplanRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.UsersRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCheckoutRequest;
import org.gvsig.vcsgis.lib.requests.CheckoutRequestHelper;

public class CheckoutRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisCheckoutRequest {
    public CheckoutRequestLocaldb(VCSGisRepositoryLocaldbImpl repository, String entityName) {
        super(new CheckoutRequestHelper(repository, entityName));
    }

    @Override
    public CheckoutRequestHelper helper() {
        return (CheckoutRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public Timestamp getEfectiveDate() {
        return this.helper().getEfectiveDate();
    }

    public void setEfectiveDate(Timestamp efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public void setEfectiveDate(String efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public String getRevisionCode() {
        return this.helper().getRevisionCode();
    }

    public void setRevisionCode(String revisionCode) {
        this.helper().setRevisionCode(revisionCode);
    }

    public Envelope getROI() {
        return this.helper().getROI();
    }

    public void setROI(Envelope roi) {
        this.helper().setROI(roi);
    }

    public VCSGisEntity getEntity() {
        return this.helper().getEntity();
    }

    public DisposableIterable<VCSGisRepositoryData> getData() {
        return this.helper().getData();
    }

    public String getUsersHashCode() {
        return this.helper().usersHashCode;
    }

    public String getTopologyPlansHashCode() {
        return this.helper().topologyPlansHashCode;
    }

    public int execute() {
        EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "' entity '" + this.helper().entityName + "', efectiveDate '" + Objects.toString(this.helper().efectiveDate) + "', repositoryRevisionCode '" + Objects.toString(this.helper().repositoryRevisionCode) + "'.");
        EntitiesRepoTable.EntityRepoRow entityRow = entitiesTable.getByEntityName(this.getRepository(), this.helper().entityName);
        if (entityRow == null) {
            LOGGER.warn("Process request: " + this.getRequestName() + " entity '" + this.helper().entityName + "' not found.");
            return this.error(240, "Entity '" + this.helper().entityName + "' not exists.");
        }
        if (entityRow.isLinkedTable()) {
            LOGGER.warn("Process request: " + this.getRequestName() + " entity '" + this.helper().entityName + "' is a linked table.");
            return this.error(37, "Entity '" + this.helper().entityName + "' is a linked table.");
        }
        if (!this.isAuthorized((VCSGisEntity)entityRow)) {
            return this.getLastErrorCode();
        }
        this.helper().entity = new EntityEditableImpl();
        this.helper().entity.copyfrom((VCSGisEntity)entityRow);
        DataRepoTable dataTable = this.getRepository().getDataRepoTable(this.helper().entity.getDataTableName());
        DisposableIterable<Feature> features = null;
        if (this.helper().efectiveDate != null) {
            features = dataTable.getDataOfEntityFromEfectiveDate(this.getRepository(), this.helper().entity.getDataTableName(), this.helper().entity.getEntityCode(), this.helper().efectiveDate, this.helper().roi == null ? null : this.helper().roi.getGeometry());
        } else {
            long revisionNumber = Long.MAX_VALUE;
            if (StringUtils.isNotBlank((CharSequence)this.helper().repositoryRevisionCode)) {
                RevisionsRepoTable revisionsTable = new RevisionsRepoTable();
                RevisionsRepoTable.RevisionRepoRow revisionRow = revisionsTable.getByRevisionCode(this.getRepository(), this.helper().repositoryRevisionCode);
                revisionNumber = revisionRow.getNumber();
            }
            features = dataTable.getDataOfEntityToRevisionNumber(this.getRepository(), this.helper().entity.getDataTableName(), this.helper().entity.getEntityCode(), revisionNumber, this.helper().roi == null ? null : this.helper().roi.getGeometry());
        }
        this.helper().usersHashCode = new UsersRepoTable().getHashCode(this.getRepository());
        this.helper().topologyPlansHashCode = new TopologyplanRepoTable().getHashCode(this.getRepository());
        this.helper().data = new DisposableIterableAdapter<Feature, VCSGisRepositoryData>(features, f -> new DataRepoTable.DataRepoRow(this.getRepository(), this.helper().entity.getDataTableName(), (Feature)f));
        return this.error(0);
    }
}

