/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Objects;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.EntityEditableImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.RevisionsRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisHistoryRequest;
import org.gvsig.vcsgis.lib.requests.HistoryRequestHelper;

public class HistoryRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisHistoryRequest {
    public HistoryRequestLocaldb(VCSGisRepositoryLocaldbImpl repository, String entityName) {
        super(new HistoryRequestHelper(repository, entityName));
    }

    @Override
    public HistoryRequestHelper helper() {
        return (HistoryRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public DisposableIterable<VCSGisRevision> getRevisions() {
        return this.helper().getRevisions();
    }

    public int execute() {
        Object result;
        if (!this.isAuthorized()) {
            return this.getLastErrorCode();
        }
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "' entity '" + this.helper().entityName + "', maxNumberOfRevisions '" + this.helper().maxNumberOfRevisions + "', maxRevisionNumber '" + this.helper().maxRevisionNumber + "', minRevisionNumber '" + this.helper().minRevisionNumber + "', maxDate '" + Objects.toString(this.helper().maxDate) + "', minDate '" + Objects.toString(this.helper().minDate) + "'.");
        EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
        EntitiesRepoTable.EntityRepoRow entityRow = entitiesTable.getByEntityName(this.getRepository(), this.helper().entityName);
        if (entityRow == null) {
            LOGGER.warn("REQUEST: " + this.getRequestName() + " entity '" + this.helper().entityName + "' not found.");
            return this.error(240, "Entity '" + this.helper().entityName + "' not found in the server.");
        }
        if (this.isAuthorized((VCSGisEntity)entityRow)) {
            DisposableIterable<Feature> data;
            EntityEditableImpl entity = new EntityEditableImpl((VCSGisEntity)entityRow);
            RevisionsRepoTable revisionsTable = new RevisionsRepoTable();
            if (this.helper().maxDate == null || this.helper().minDate == null) {
                data = revisionsTable.getRevisionsByRevisionNumber(this.getRepository(), entity.getEntityCode(), this.helper().maxRevisionNumber, this.helper().minRevisionNumber, this.helper().maxNumberOfRevisions);
            } else {
                if (this.helper().minDate.compareTo(this.helper().maxDate) > 0) {
                    Timestamp x = this.helper().minDate;
                    this.helper().minDate = this.helper().maxDate;
                    this.helper().maxDate = x;
                }
                data = revisionsTable.getRevisionsByDate(this.getRepository(), entity.getEntityCode(), this.helper().maxDate, this.helper().minDate, this.helper().maxNumberOfRevisions);
            }
            result = new DisposableIterable<VCSGisRevision>(){

                public Iterator<VCSGisRevision> iterator() {
                    final Iterator itFeatures = data.iterator();
                    Iterator<VCSGisRevision> it = new Iterator<VCSGisRevision>(){

                        @Override
                        public boolean hasNext() {
                            return itFeatures.hasNext();
                        }

                        @Override
                        public VCSGisRevision next() {
                            Feature f = (Feature)itFeatures.next();
                            RevisionsRepoTable.RevisionRepoRow rev = new RevisionsRepoTable.RevisionRepoRow(HistoryRequestLocaldb.this.getRepository(), f);
                            return rev;
                        }
                    };
                    return it;
                }

                public void dispose() {
                    data.dispose();
                }
            };
        } else {
            result = new DisposableIterable<VCSGisRevision>(){

                public Iterator<VCSGisRevision> iterator() {
                    Iterator<VCSGisRevision> it = new Iterator<VCSGisRevision>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public VCSGisRevision next() {
                            return null;
                        }
                    };
                    return it;
                }

                public void dispose() {
                }
            };
        }
        this.helper().revisions = result;
        return this.error(0);
    }

    public Timestamp getMinDate() {
        return this.helper().getMinDate();
    }

    public Timestamp getMaxDate() {
        return this.helper().getMaxDate();
    }

    public long getMinRevisionNumber() {
        return this.helper().getMinRevisionNumber();
    }

    public long getMaxRevisionNumber() {
        return this.helper().getMaxRevisionNumber();
    }

    public void setDateRange(Timestamp min, Timestamp max) {
        this.helper().setDateRange(min, max);
    }

    public void setRevisionNumberRange(long min, long max) {
        this.helper().setRevisionNumberRange(min, max);
    }

    public void setMaxNumberOfRevisions(int maxNumberOfRevisions) {
        this.helper().setMaxNumberOfRevisions(maxNumberOfRevisions);
    }
}

