/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.tables;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.AbstractRepoTable;

public class ConfigRepoTable
extends AbstractRepoTable {
    public static final String TABLE_NAME = "VCSGISREPO_CONFIG";
    private static final String COD_CONFIG = "COD_CONFIG";
    private static final String VAR_NAME = "CFG_NAME";
    private static final String VAR_VALUE = "CFG_VALUE";

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS repository config");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.getTags().set("dynform.height", (Object)200);
        ft.getTags().set("dynform.width", (Object)500);
        ft.add(COD_CONFIG, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false).setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>").setHidden(true);
        ft.add(VAR_NAME, 8).setSize(100).setIsIndexed(true).setAllowIndexDuplicateds(false).setLabel("Name");
        ft.add(VAR_VALUE, 8).setSize(4096).setLabel("Value");
        return ft.getNotEditableCopy();
    }

    public ConfigRepoTable() {
        super(TABLE_NAME, ConfigRepoTable.featureType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(VCSGisRepositoryLocaldbImpl repo, String name) {
        String string;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repo.getFeatureStore(TABLE_NAME, true);
            f = store.findFirst("\"CFG_NAME\"='" + name + "'");
            if (f != null) break block5;
            String string2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return string2;
        }
        try {
            String value;
            string = value = f.getString(VAR_VALUE);
        }
        catch (Exception ex) {
            String string3;
            try {
                string3 = null;
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return string3;
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return string;
    }

    public Map<String, String> getVars(VCSGisRepositoryLocaldbImpl repo, String ... names) {
        HashMap<String, String> hashMap;
        FeatureStore store = null;
        FeatureSet set = null;
        HashMap<String, String> vars = new HashMap<String, String>();
        try {
            ExpressionBuilder filter = ExpressionUtils.createExpressionBuilder();
            for (DisposableIterator name : names) {
                filter.or((ExpressionBuilder.Value)filter.eq((ExpressionBuilder.Value)filter.variable(VAR_NAME), (ExpressionBuilder.Value)filter.constant((Object)name)));
            }
            store = repo.getFeatureStore(TABLE_NAME, true);
            set = store.getFeatureSet(filter.build());
            for (Feature feature : set) {
                vars.put(feature.getString(VAR_NAME), feature.getString(VAR_VALUE));
            }
            hashMap = vars;
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't get config variables from repository", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(set);
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)set);
        DisposeUtils.disposeQuietly((Disposable)store);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(VCSGisRepositoryLocaldbImpl repo, String name, String value) {
        FeatureStore store = null;
        try {
            store = repo.getFeatureStore(TABLE_NAME, false);
            Feature f = store.findFirst("\"CFG_NAME\"='" + name + "'");
            if (f == null) {
                store.edit(2);
                EditableFeature ef = store.createNewFeature();
                ef.set(VAR_NAME, (Object)name);
                ef.set(VAR_VALUE, (Object)value);
                store.insert(ef);
                store.finishEditing();
            } else {
                EditableFeature ef = f.getEditable();
                ef.set(VAR_VALUE, (Object)value);
                store.edit();
                store.update(ef);
                store.finishEditing();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't store value for '" + name + "'.", (Throwable)ex);
        }
        finally {
            if (store != null && (store.isAppending() || store.isEditing())) {
                store.cancelEditingQuietly();
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }
}

