/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.tables;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.spi.JsonUtils;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.util.FilteredIterable;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.AbstractRepoTable;

public class DataRepoTable
extends AbstractRepoTable {
    public static final String TABLE_NAME = "VCSGISREPO_DATA";
    public static final String COD_DATA = "COD_DATA";
    public static final String COD_ENTITY = "COD_ENTITY";
    public static final String COD_REVISION = "COD_REVISION";
    public static final String DATA_REVNUMBER = "DAT_REVNUMBER";
    public static final String DATA_EFECTIVEDATE = "DAT_EFECTIVEDATE";
    public static final String DATA_OPERATION = "DAT_OPERATION";
    public static final String DATA_FEATURERELATEDCODE = "DAT_FEATURERELATEDCODE";
    public static final String DATA_GEOM = "DAT_GEOM";
    public static final String DATA_DATA = "DAT_DATA";
    public static final int DATA_SIZE = 4096;
    public static final String CHECKOUT_ALGORITHM_USESELECT = "USESELECT";
    public static final String CHECKOUT_ALGORITHM_USEAPPFILTER = "USEAPPFILTER";
    public static final String CHECKOUT_ALGORITHM_USEDBFUNCTION = "USEDBFUNCTION";

    public DataRepoTable(String dataTableName, IProjection crs) {
        super(dataTableName, DataRepoTable.featureType(crs, null));
    }

    public DisposableIterable<Feature> getDataOfRevisions(VCSGisRepositoryLocaldbImpl repository, String dataTableName, String entityCode, long revnumber1, long revnumber2) {
        FeatureStore store = null;
        DisposableFeatureSetIterable features = null;
        try {
            store = repository.openFeatureStore(dataTableName, null, true);
            FeatureQuery query = store.createFeatureQuery();
            ExpressionBuilder builder = store.createExpressionBuilder();
            String filter = builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(COD_ENTITY), (ExpressionBuilder.Value)builder.constant((Object)entityCode)), (ExpressionBuilder.Value)builder.and((ExpressionBuilder.Value)builder.ge((ExpressionBuilder.Value)builder.column(DATA_REVNUMBER), (ExpressionBuilder.Value)builder.constant((Object)revnumber1)), (ExpressionBuilder.Value)builder.le((ExpressionBuilder.Value)builder.column(DATA_REVNUMBER), (ExpressionBuilder.Value)builder.constant((Object)revnumber1)))).toString();
            query.setFilter(filter);
            query.getOrder().add(DATA_REVNUMBER, true);
            query.setPageSize(1000L);
            FeatureSet fset = store.getFeatureSet(query);
            DisposableFeatureSetIterable disposableFeatureSetIterable = features = fset.iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            DisposeUtils.disposeQuietly(features);
            throw new RuntimeException("Can't retrieve data of 'ENTITY[" + entityCode + "] between revision " + revnumber1 + " and " + revnumber2 + ".", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public DisposableIterable<Feature> getDataOfEntityFromRevisionNumber(VCSGisRepositoryLocaldbImpl repository, String dataTableName, String entityCode, long revnumber) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        block5: {
            FeatureStore store = null;
            DisposableFeatureSetIterable features = null;
            try {
                String sql = VCSGisUtils.getSqlTemplate(repository.getServerExplorer().getProviderName(), "getDataOfEntityFromRevisionNumber", revnumber, entityCode, dataTableName);
                LOGGER.info("getDataOfEntityFromRevisionNumber: sql=" + sql);
                store = repository.openFeatureStore(dataTableName, sql, true);
                FeatureQuery query = store.createFeatureQuery();
                query.setPageSize(1000L);
                query.setUseSubquery(false);
                FeatureSet fset = store.getFeatureSet(query);
                disposableFeatureSetIterable = features = fset.iterable();
                if (store == null) break block5;
            }
            catch (Exception ex) {
                try {
                    DisposeUtils.disposeQuietly(features);
                    throw new RuntimeException("Can't retrieve data of 'ENTITY[" + entityCode + "] from revision " + revnumber + ".", ex);
                }
                catch (Throwable throwable) {
                    if (store != null) {
                        DisposeUtils.dispose(store);
                    }
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)store);
        }
        return disposableFeatureSetIterable;
    }

    public DisposableIterable<Feature> getDataOfEntityToRevisionNumber(VCSGisRepositoryLocaldbImpl repository, String dataTableName, String entityCode, long revnumber, Geometry roi) {
        String string;
        block17: {
            FeatureStore store = null;
            DisposableFeatureSetIterable features = null;
            try {
                String sql = null;
                String algorithm = (String)repository.getProperty("CHECKOUT_ALGORITHM");
                algorithm = StringUtils.isBlank((CharSequence)algorithm) ? CHECKOUT_ALGORITHM_USEDBFUNCTION : algorithm.toUpperCase();
                String roi_s = null;
                if (roi != null && repository.getCRS().equals(roi.getProjection())) {
                    SQLBuilder sqlbuilder = repository.getSQLBuilder();
                    roi_s = sqlbuilder.expression().geometry(roi).toString(sqlbuilder.formatter());
                }
                switch (algorithm) {
                    case "USEDBFUNCTION": {
                        if (roi_s == null) {
                            sql = VCSGisUtils.getSqlTemplate(repository.getServerExplorer().getProviderName(), "getDataOfEntityToRevisionNumberUsingDatabaseFunction", revnumber, entityCode, dataTableName);
                        }
                        if (StringUtils.isNotBlank(sql)) {
                            store = repository.openFeatureStore(dataTableName, sql, true);
                            FeatureQuery query = store.createFeatureQuery();
                            query.setPageSize(1000L);
                            query.setQueryParameter("DONT_ADD_PRIMARY_KEY_IN_THE_ORDER", (Object)true);
                            query.setUseSubquery(false);
                            FeatureSet fset = store.getFeatureSet(query);
                            features = fset.iterable();
                            break;
                        }
                    }
                    default: {
                        sql = roi_s == null ? VCSGisUtils.getSqlTemplate(repository.getServerExplorer().getProviderName(), "getDataOfEntityToRevisionNumber", revnumber, entityCode, dataTableName) : VCSGisUtils.getSqlTemplate(repository.getServerExplorer().getProviderName(), "getDataOfEntityToRevisionNumberAndRoi", revnumber, entityCode, roi_s, dataTableName);
                        store = repository.openFeatureStore(dataTableName, sql, true);
                        FeatureQuery query = store.createFeatureQuery();
                        query.setPageSize(1000L);
                        query.setQueryParameter("DONT_ADD_PRIMARY_KEY_IN_THE_ORDER", (Object)true);
                        query.setUseSubquery(false);
                        FeatureSet fset = store.getFeatureSet(query);
                        features = fset.iterable();
                        break;
                    }
                    case "USEAPPFILTER": {
                        store = repository.openFeatureStore(dataTableName, null, true);
                        FeatureQuery query = store.createFeatureQuery();
                        query.setPageSize(1000L);
                        GeometryExpressionBuilder builder = repository.getSQLBuilder().expression();
                        String filter = roi_s == null ? builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(COD_ENTITY), (ExpressionBuilder.Value)builder.constant((Object)entityCode)), (ExpressionBuilder.Value)builder.le((ExpressionBuilder.Value)builder.column(DATA_REVNUMBER), (ExpressionBuilder.Value)builder.constant((Object)revnumber))).toString() : builder.and((ExpressionBuilder.Value)builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(COD_ENTITY), (ExpressionBuilder.Value)builder.constant((Object)entityCode)), (ExpressionBuilder.Value)builder.le((ExpressionBuilder.Value)builder.column(DATA_REVNUMBER), (ExpressionBuilder.Value)builder.constant((Object)revnumber))), (ExpressionBuilder.Value)builder.or((ExpressionBuilder.Value)builder.is_null((ExpressionBuilder.Value)builder.column(DATA_GEOM)), (ExpressionBuilder.Value)builder.ST_Intersects((ExpressionBuilder.Value)builder.column(DATA_GEOM), (ExpressionBuilder.Value)builder.geometry(roi)))).toString();
                        query.addFilter(filter);
                        query.getOrder().add(DATA_REVNUMBER, false);
                        query.retrievesAllAttributes();
                        query.setQueryParameter("DONT_ADD_PRIMARY_KEY_IN_THE_ORDER", (Object)true);
                        FeatureSet fset = store.getFeatureSet(query);
                        final HashSet deleteds = new HashSet();
                        final HashSet updatedsOrInserteds = new HashSet();
                        features = new FilteredIterable((Iterable)fset, (Predicate)new Predicate<Feature>(){

                            @Override
                            public boolean test(Feature f) {
                                String COD_DATA = f.getString(DataRepoTable.COD_DATA);
                                String DAT_FEATURERELATEDCODE = f.getString(DataRepoTable.DATA_FEATURERELATEDCODE);
                                int DAT_OPERATION = f.getInt(DataRepoTable.DATA_OPERATION);
                                if (deleteds.contains(DAT_FEATURERELATEDCODE)) {
                                    return false;
                                }
                                if (updatedsOrInserteds.contains(DAT_FEATURERELATEDCODE)) {
                                    return false;
                                }
                                switch (DAT_OPERATION) {
                                    case 0: {
                                        deleteds.add(DAT_FEATURERELATEDCODE);
                                        return false;
                                    }
                                    case 1: {
                                        updatedsOrInserteds.add(DAT_FEATURERELATEDCODE);
                                        return true;
                                    }
                                    case 2: {
                                        updatedsOrInserteds.add(DAT_FEATURERELATEDCODE);
                                        return true;
                                    }
                                }
                                AbstractRepoTable.LOGGER.warn("Codigo de operacion incorecto para COD_DATA=" + COD_DATA);
                                return false;
                            }
                        });
                    }
                }
                string = features;
                if (store == null) break block17;
            }
            catch (Exception ex) {
                try {
                    DisposeUtils.disposeQuietly(features);
                    throw new RuntimeException("Can't retrieve data of 'ENTITY[" + entityCode + "] to revision " + revnumber + ".", ex);
                }
                catch (Throwable throwable) {
                    if (store != null) {
                        DisposeUtils.dispose(store);
                    }
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)store);
        }
        return string;
    }

    public DisposableIterable<Feature> getDataOfEntityFromEfectiveDate(VCSGisRepositoryLocaldbImpl repository, String dataTableName, String entityCode, Timestamp efectiveDate, Geometry roi) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        block8: {
            FeatureStore store = null;
            DisposableFeatureSetIterable features = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat(VCSGisUtils.getSqlTemplate(repository.getServerExplorer().getProviderName(), "dateFormat", new Object[0]));
            try {
                String roi_s = null;
                if (roi != null && repository.getCRS().equals(roi.getProjection())) {
                    SQLBuilder sqlbuilder = repository.getSQLBuilder();
                    roi_s = sqlbuilder.expression().geometry(roi).toString(sqlbuilder.formatter());
                }
                if (roi == null) {
                    LOGGER.info("checkout. roi is null");
                } else {
                    LOGGER.info("checkout. roi=" + roi.convertToWKTQuietly() + ", roiproj=" + roi.getProjection() + "repoproj=" + repository.getCRS());
                }
                String sql = roi == null || !repository.getCRS().equals(roi.getProjection()) ? VCSGisUtils.getSqlTemplate(repository.getServerExplorer().getProviderName(), "getDataOfEntityFromEfectiveDate", entityCode, dateFormat.format(efectiveDate), dataTableName) : VCSGisUtils.getSqlTemplate(repository.getServerExplorer().getProviderName(), "getDataOfEntityFromEfectiveDateAndRoi", entityCode, dateFormat.format(efectiveDate), roi_s, dataTableName);
                LOGGER.debug("checkout. sql=" + sql);
                store = repository.openFeatureStore(dataTableName, sql, true);
                FeatureQuery query = store.createFeatureQuery();
                query.setPageSize(1000L);
                query.setUseSubquery(false);
                FeatureSet fset = store.getFeatureSet(query);
                disposableFeatureSetIterable = features = fset.iterable();
                if (store == null) break block8;
            }
            catch (Exception ex) {
                try {
                    DisposeUtils.disposeQuietly(features);
                    throw new RuntimeException("Can't data of 'ENTITY[" + entityCode + "] from efective date " + efectiveDate + ".", ex);
                }
                catch (Throwable throwable) {
                    if (store != null) {
                        DisposeUtils.dispose(store);
                    }
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)store);
        }
        return disposableFeatureSetIterable;
    }

    public DataRepoRow getLastDataOfRecord(VCSGisRepositoryLocaldbImpl repository, String dataTableName, String recordCode) {
        DataRepoRow dataRepoRow;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repository.openFeatureStore(dataTableName, null, true);
            FeatureQuery query = store.createFeatureQuery("DAT_FEATURERELATEDCODE = '" + recordCode + "'", DATA_REVNUMBER, false);
            query.setLimit(1L);
            f = store.findFirst(query);
            if (f != null) break block5;
            DataRepoRow dataRepoRow2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return dataRepoRow2;
        }
        try {
            DataRepoRow row;
            dataRepoRow = row = new DataRepoRow(repository, dataTableName, f);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve last revision of record '" + recordCode + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return dataRepoRow;
    }

    private void dumpData(String s, FeatureSet fset) {
        LOGGER.debug("BEGIN " + s);
        DisposableFeatureSetIterable features = fset.iterable();
        for (Feature feature : features) {
            LOGGER.debug("DATA: " + feature.toJson().toString());
        }
        LOGGER.debug("END " + s);
    }

    public static final FeatureType featureType() {
        return DataRepoTable.featureType(CRSFactory.getCRS((String)"EPSG:25830"), null);
    }

    public static final FeatureType featureType(IProjection crs, Envelope tablebbox) {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS Data");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.getTags().set("dynform.height", (Object)400);
        ft.getTags().set("dynform.width", (Object)500);
        ft.getTags().set("dynform.layoutmode", (Object)"tabs");
        ft.getTags().set("UpdateSpatialIndexAndMetadata", (Object)false);
        ft.add(COD_DATA, 8).setSize(60).setIsPrimaryKey(true).setLabel("Code");
        ft.add(COD_REVISION, 8).setForeingkey(true, false, "VCSGISREPO_REVISIONS", COD_REVISION, "FORMAT('r%d %s', REV_NUMBER, REV_OPERATIONDATE)").setSize(60).setLabel("Revision");
        ft.add(COD_ENTITY, 8).setForeingkey(true, false, "VCSGISREPO_ENTITIES", COD_ENTITY, "ENT_NAME").setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Entity");
        ft.add(DATA_OPERATION, 4).setLabel("Operation").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)2, "Insert"), new DynObjectValueItem((Object)0, "Delete"), new DynObjectValueItem((Object)1, "Update")});
        ft.add(DATA_REVNUMBER, 5).setLabel("Rev. number");
        ft.add(DATA_EFECTIVEDATE, 11).setLabel("User date");
        ft.add(DATA_FEATURERELATEDCODE, 8).setIsIndexed(true).setSize(60).setLabel("Identifier").setDescription("Identifier if the feature that represent.");
        DynField_v2 geomattr = (DynField_v2)ft.add(DATA_GEOM, 66).setGeometryType(19, 0).setSRS(crs).setIsIndexed(true).setLabel("BBox of the geometry to allow spatial queries");
        ft.add(DATA_DATA, 8).setSize(4096).setLabel("Feature data serialized in json.").setGroup("Data");
        if (tablebbox != null) {
            geomattr.getTags().set("tablebbox", (Object)tablebbox.getGeometry().convertToHexWKBQuietly());
        }
        return ft.getNotEditableCopy();
    }

    public boolean canUpdate(String relatedFeatureCode) {
        return true;
    }

    public boolean canDelete(String relatedFeatureCode) {
        return true;
    }

    public DisposableIterable<Feature> getDataOfEntityFromFeatureRelatedCode(VCSGisRepositoryLocaldbImpl repository, String dataTableName, String entityCode, String featureRelatedCode) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        block5: {
            FeatureStore store = null;
            DisposableFeatureSetIterable features = null;
            try {
                String sql = VCSGisUtils.getSqlTemplate(repository.getServerExplorer().getProviderName(), "getDataOfEntityFromFeatureRelatedCode", featureRelatedCode, entityCode, dataTableName);
                LOGGER.info("getDataOfEntityFromFeatureRelatedCode: sql=" + sql);
                store = repository.openFeatureStore(dataTableName, sql, true);
                FeatureQuery query = store.createFeatureQuery();
                query.setPageSize(1000L);
                query.setUseSubquery(false);
                FeatureSet fset = store.getFeatureSet(query);
                disposableFeatureSetIterable = features = fset.iterable();
                if (store == null) break block5;
            }
            catch (Exception ex) {
                try {
                    DisposeUtils.disposeQuietly(features);
                    throw new RuntimeException("Can't retrieve data of 'ENTITY[" + entityCode + "] from FeatureRelatedCode " + featureRelatedCode + ".", ex);
                }
                catch (Throwable throwable) {
                    if (store != null) {
                        DisposeUtils.dispose(store);
                    }
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)store);
        }
        return disposableFeatureSetIterable;
    }

    public static class DataRepoRow
    extends AbstractRepoTable.AbstractRow
    implements VCSGisRepositoryData {
        public DataRepoRow(VCSGisRepositoryLocaldbImpl repository, String dataTableName) {
            super(repository, dataTableName, DataRepoTable.COD_DATA, null);
        }

        public DataRepoRow(VCSGisRepositoryLocaldbImpl repository, String dataTableName, Feature feature) {
            super(repository, dataTableName, DataRepoTable.COD_DATA, feature);
        }

        public String getDataCode() {
            return this.getCode();
        }

        public String getRevisionCode() {
            return this.feature.getString(DataRepoTable.COD_REVISION);
        }

        public String getEntityCode() {
            return this.feature.getString(DataRepoTable.COD_ENTITY);
        }

        public int getOperation() {
            return this.feature.getInt(DataRepoTable.DATA_OPERATION);
        }

        public String getOperationLabel() {
            return VCSGisUtils.getOperationLabel(this.getOperation());
        }

        public long getRevisionNumber() {
            return this.feature.getInt(DataRepoTable.DATA_REVNUMBER);
        }

        public Timestamp getEfectiveDate() {
            return this.feature.getTimestamp(DataRepoTable.DATA_EFECTIVEDATE);
        }

        public String getFeatureRelatedCode() {
            return this.feature.getString(DataRepoTable.DATA_FEATURERELATEDCODE);
        }

        public Geometry getGeometry() {
            return this.feature.getGeometry(DataRepoTable.DATA_GEOM);
        }

        public String getData() {
            return this.feature.getString(DataRepoTable.DATA_DATA);
        }

        public void setRevisionCode(String code) {
            this.feature.set(DataRepoTable.COD_REVISION, (Object)code);
        }

        public void setEntityCode(String code) {
            this.feature.set(DataRepoTable.COD_ENTITY, (Object)code);
        }

        public void setOperation(int op) {
            this.feature.set(DataRepoTable.DATA_OPERATION, (Object)op);
        }

        public void setRevisionNumber(long revnum) {
            this.feature.set(DataRepoTable.DATA_REVNUMBER, (Object)revnum);
        }

        public void setEfectiveDate(Timestamp date) {
            this.feature.set(DataRepoTable.DATA_EFECTIVEDATE, (Object)date);
        }

        public void setIdentifier(String code) {
            this.feature.set(DataRepoTable.DATA_FEATURERELATEDCODE, (Object)code);
        }

        public void setGeometry(Geometry geom) {
            this.feature.set(DataRepoTable.DATA_GEOM, (Object)geom);
        }

        public void setValues(String jsonValues) {
            this.feature.set(DataRepoTable.DATA_DATA, (Object)jsonValues);
        }

        public JsonObject getDataAsJson() {
            try {
                String s = this.getData();
                if (s == null) {
                    return null;
                }
                JsonObject json = JsonUtils.toJsonObject((Object)s);
                return json;
            }
            catch (CoercionException ex) {
                return null;
            }
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("DataCode", this.getDataCode());
            if (StringUtils.isNotBlank((CharSequence)this.getEntityCode())) {
                builder.add("EntityCode", this.getEntityCode());
            }
            builder.add("RevisionCode", this.getRevisionCode());
            builder.add("RevisionNumber", this.getRevisionNumber());
            builder.add("EfectiveDate", this.getEfectiveDate().toString());
            builder.add("Operation", this.getOperation());
            builder.add("FeatureRelatedCode", this.getFeatureRelatedCode());
            builder.add("Data", this.getData());
            return builder;
        }
    }
}

