/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.TeeWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.requests.AbstractRequest;
import org.gvsig.vcsgis.lib.requests.RequestHelper;

public abstract class AbstractRequestClient
extends AbstractRequest
implements VCSGisRequest {
    private final String urlPath;
    private final Object syncRequest;
    private final Object syncResponse;

    public AbstractRequestClient(RequestHelper helper, String urlPath) {
        super(helper);
        this.urlPath = urlPath;
        this.syncRequest = new Object();
        this.syncResponse = new Object();
    }

    @Override
    public VCSGisRepositoryClientImpl getRepository() {
        return (VCSGisRepositoryClientImpl)super.getRepository();
    }

    public String getAuthenticationToken() {
        return this.helper().getAuthenticationToken();
    }

    public void setAuthenticationToken(String token) {
        this.helper().setAuthenticationToken(token);
    }

    public String getUserCode() {
        return this.helper().getUserCode();
    }

    public void setUserCode(String userCode) {
        this.helper().setUserCode(userCode);
    }

    public URL getRequestUrl() {
        return this.getRepository().getUrl(this.urlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitRequestProducer() throws InterruptedException {
        Object object = this.syncRequest;
        synchronized (object) {
            long timeout = this.getRepository().getRequestTimeout();
            this.syncRequest.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRequestConsumers() {
        Object object = this.syncRequest;
        synchronized (object) {
            this.syncRequest.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitResponseProducer() throws InterruptedException {
        Object object = this.syncResponse;
        synchronized (object) {
            LOGGER.debug("===: [" + this.getRequestName() + "] waitResponseProducer 1");
            long timeout = this.getRepository().getRequestTimeout();
            this.syncResponse.wait(timeout);
            LOGGER.debug("===: [" + this.getRequestName() + "] waitResponseProducer 2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResponseConsumers() {
        Object object = this.syncResponse;
        synchronized (object) {
            LOGGER.debug("===: [" + this.getRequestName() + "] notifyResponseConsumers");
            this.syncResponse.notifyAll();
        }
    }

    public InputStream getRequestAsInputStream() throws IOException, InterruptedException {
        LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream");
        MutableObject exceptionOfProducer = new MutableObject(null);
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        Thread task = new Thread(() -> {
            try {
                LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream requestProducer");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                Writer debugWriter = VCSGisLocator.getVCSGisManager().getWriterForProtocolDebugging();
                if (debugWriter != null) {
                    writer = new TeeWriter(new Writer[]{writer, debugWriter});
                }
                this.requestProducer(writer);
            }
            catch (Exception ex) {
                exceptionOfProducer.setValue((Object)ex);
                throw new VCSGisRuntimeException(9, "Can't build request (" + this.getRequestName() + ")", (Throwable)ex);
            }
            finally {
                LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream notifyRequestConsumers");
                this.notifyRequestConsumers();
                try {
                    LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream flush");
                    out.flush();
                }
                catch (Exception exception) {}
                LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream close");
                IOUtils.closeQuietly((OutputStream)out);
                LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream ok");
            }
        }, this.getRequestName() + "RequestProducer");
        LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream task.start");
        task.start();
        LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream waitRequestProducer");
        this.waitRequestProducer();
        if (exceptionOfProducer.getValue() != null) {
            LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream error", (Throwable)exceptionOfProducer.getValue());
            throw new VCSGisRuntimeException(10, "Can't create request from data (" + this.getRequestName() + ").", (Throwable)exceptionOfProducer.getValue());
        }
        LOGGER.debug("===: [" + this.getRequestName() + "] getRequestAsInputStream ok");
        return in;
    }

    protected String getLines(BufferedReader reader, int maxLines) throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = reader.readLine();
        for (int n = 0; line != null && n < maxLines; ++n) {
            builder.append(line);
            builder.append("\n");
            line = reader.readLine();
        }
        reader.close();
        if (line != null) {
            builder.append("...\n");
        }
        return builder.toString();
    }

    public int consumeResponse(InputStream responseContents) throws IOException, InterruptedException {
        LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse 1");
        BufferedReader responseReader = new BufferedReader(new InputStreamReader(responseContents, StandardCharsets.UTF_8), 4096);
        responseReader.mark(1024);
        String line = responseReader.readLine();
        if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"<html>")) {
            responseReader.reset();
            String message = this.getLines(responseReader, 20);
            IOUtils.closeQuietly((Reader)responseReader);
            throw new VCSGisRuntimeException(12, "Response format not supported.\n" + message);
        }
        responseReader.reset();
        MutableObject exceptionOfProducer = new MutableObject(null);
        Thread task = new Thread(() -> {
            try {
                LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse responseConsumer");
                this.responseConsumer(responseReader);
            }
            catch (Exception ex) {
                LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse EXCEPTION:");
                exceptionOfProducer.setValue((Object)ex);
                throw new VCSGisRuntimeException(12, "Can't consume response (" + this.getRequestName() + ")", (Throwable)ex);
            }
            finally {
                LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse notifyResponseConsumers");
                this.notifyResponseConsumers();
                IOUtils.closeQuietly((Reader)responseReader);
                LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse ok");
            }
        }, this.getRequestName() + "ConsumeResponse");
        LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse task.start");
        task.start();
        LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse waitResponseProducer");
        this.waitResponseProducer();
        if (exceptionOfProducer.getValue() != null) {
            LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse error", (Throwable)exceptionOfProducer.getValue());
            throw new VCSGisRuntimeException(12, "Can't consume response (" + this.getRequestName() + ").", (Throwable)exceptionOfProducer.getValue());
        }
        LOGGER.debug("===: [" + this.getRequestName() + "] consumeResponse ok");
        return this.getLastErrorCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        LOGGER.debug("===: [" + this.getRequestName() + "] execute");
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.createDefault();
            URL url = this.getRequestUrl();
            String url_s = this.getRequestUrl().toString();
            Writer debugWriter = VCSGisLocator.getVCSGisManager().getWriterForProtocolDebugging();
            if (debugWriter != null) {
                debugWriter.append("\nREQUEST POST ");
                debugWriter.append(url_s);
                debugWriter.append("\n");
            }
            HttpPost httpPost = new HttpPost(url_s);
            LOGGER.debug("===: [" + this.getRequestName() + "] execute 2");
            InputStreamEntity requestEntity = new InputStreamEntity(this.getRequestAsInputStream(), ContentType.APPLICATION_JSON);
            LOGGER.debug("===: [" + this.getRequestName() + "] execute 3");
            requestEntity.setChunked(true);
            httpPost.setEntity((HttpEntity)requestEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            LOGGER.debug("===: [" + this.getRequestName() + "] execute 4 responseConsumer");
            InputStreamLogged in = new InputStreamLogged(response, httpClient);
            if (this.consumeResponse(in) != 0) {
                int n = this.getLastErrorCode();
                return n;
            }
            LOGGER.debug("===: [" + this.getRequestName() + "] execute 6 ok");
            int n = this.error(0);
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't execute '" + this.getRequestName() + " from '" + this.getRepository().getLabel() + "'.", (Throwable)ex);
            int n = this.error(7, "Can't execute '" + this.getRequestName() + " from '" + this.getRepository().getLabel() + "'. " + ex.getMessage());
            return n;
        }
        finally {
            LOGGER.debug("===: [" + this.getRequestName() + "] execute 7 ok");
            LOGGER.debug("===: [" + this.getRequestName() + "] execute 8 ok");
            LOGGER.debug("===: [" + this.getRequestName() + "] execute 9 ok");
        }
    }

    public abstract void requestProducer(Writer var1);

    public abstract void responseConsumer(BufferedReader var1);

    public class InputStreamLogged
    extends InputStream {
        private final InputStream delegated;
        private final CloseableHttpResponse response;
        private final CloseableHttpClient httpClient;

        public InputStreamLogged(CloseableHttpResponse response, CloseableHttpClient httpClient) throws IOException {
            this.delegated = response.getEntity().getContent();
            this.response = response;
            this.httpClient = httpClient;
        }

        @Override
        public int read() throws IOException {
            return this.delegated.read();
        }

        @Override
        public void close() throws IOException {
            this.delegated.close();
            IOUtils.closeQuietly((Closeable)this.response);
            IOUtils.closeQuietly((Closeable)this.httpClient);
        }

        @Override
        public int available() throws IOException {
            return this.delegated.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegated.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.delegated.markSupported();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegated.skip(n);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegated.reset();
        }
    }
}

