/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowIsOutofdateRequest;
import org.gvsig.vcsgis.lib.requests.RowIsOutofdateRequestHelper;

public class RowIsOutofdateRequestClient
extends AbstractRequestClient
implements VCSGisRowIsOutofdateRequest {
    public RowIsOutofdateRequestClient(VCSGisRepositoryClientImpl repository, String entityName, String localRevisionCode, String recordCode) {
        super(new RowIsOutofdateRequestHelper(repository, entityName, localRevisionCode, recordCode), "rowisoutofdate");
    }

    @Override
    public RowIsOutofdateRequestHelper helper() {
        return (RowIsOutofdateRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public String getLocalRevisionCode() {
        return this.helper().getLocalRevisionCode();
    }

    public String getRecordCode() {
        return this.helper().getRecordCode();
    }

    public boolean isOutdated() {
        return this.helper().isOutdated();
    }

    @Override
    public void requestProducer(Writer out) {
        try {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("EntityName", this.getEntityName());
            builder.add("LocalRevisionCode", this.getLocalRevisionCode());
            builder.add("RecordCode", this.getRecordCode());
            this.notifyRequestConsumers();
            IOUtils.write((String)builder.toString(), (Writer)out);
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getRequestName() + " request.", (Throwable)ex);
            this.error(600, "Can't produce Json data for " + this.getRequestName() + " request. " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Override
    public void responseConsumer(BufferedReader dataReader) {
        JsonReader reader = Json.createReader((Reader)dataReader);
        JsonObject jsonResponse = reader.readObject();
        JsonObject parameters = jsonResponse.getJsonObject("Parameters");
        this.error(parameters.getInt("StatusCode", 0), parameters.getString("StatusMessage", null));
        this.helper().entityName = parameters.getString("EntityName", null);
        this.helper().localRevisionCode = parameters.getString("LocalRevisionCode", null);
        this.helper().recordCode = parameters.getString("RecordCode", null);
        this.helper().outdated = parameters.getBoolean("outdated", true);
        this.notifyResponseConsumers();
    }
}

