/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.requests;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import org.gvsig.vcsgis.lib.BaseSupportError;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.requests.RequestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestHelper
extends BaseSupportError
implements RequestHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractRequestHelper.class);
    private final VCSGisRepository repository;
    private final String requestName;
    private final String code;
    private boolean enableStatus;
    private String authenticationToken;
    private String userCode;

    public AbstractRequestHelper(VCSGisRepository repository, String requestName) {
        this.repository = repository;
        this.requestName = requestName;
        this.code = this.repository.createUniqueCode();
        this.enableStatus = true;
    }

    public String getCode() {
        return this.code;
    }

    public String getRequestName() {
        return this.requestName;
    }

    @Override
    public VCSGisRepository getRepository() {
        return this.repository;
    }

    public void dispose() {
    }

    @Override
    public Timestamp now() {
        return Timestamp.from(LocalDateTime.now().toInstant(ZoneOffset.UTC));
    }

    public int execute() {
        return this.error(0);
    }

    public void setEnabledStatus(boolean enable) {
        this.enableStatus = enable;
    }

    public boolean isEnabledStatus() {
        return this.enableStatus;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public void setAuthenticationToken(String token) {
        this.authenticationToken = token;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setAuthenticationTokenAndUser(Map<String, String> params) {
        throw new RuntimeException("method not available");
    }
}

