/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.requests;

import java.sql.Timestamp;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCheckoutRequest;
import org.gvsig.vcsgis.lib.requests.AbstractRequestHelper;

public class CheckoutRequestHelper
extends AbstractRequestHelper
implements VCSGisCheckoutRequest {
    private static final String REQUEST_NAME = "Checkout";
    public String entityName;
    public String repositoryRevisionCode;
    public Timestamp efectiveDate;
    public Envelope roi;
    public VCSGisEntityEditable entity;
    public DisposableIterable<VCSGisRepositoryData> data;
    public String usersHashCode;
    public String topologyPlansHashCode;

    public CheckoutRequestHelper(VCSGisRepository repository, String entityName) {
        super(repository, REQUEST_NAME);
        this.entityName = entityName;
        this.entity = null;
        this.data = null;
    }

    public Timestamp getEfectiveDate() {
        return this.efectiveDate;
    }

    public void setEfectiveDate(Timestamp efectiveDate) {
        this.efectiveDate = efectiveDate;
    }

    public void setEfectiveDate(String efectiveDate) {
        Timestamp tms;
        this.efectiveDate = tms = (Timestamp)DataTypeUtils.toTimestamp((Object)efectiveDate, null);
    }

    public String getRevisionCode() {
        return this.repositoryRevisionCode;
    }

    public void setRevisionCode(String revisionCode) {
        this.repositoryRevisionCode = revisionCode;
    }

    public Envelope getROI() {
        return this.roi;
    }

    public void setROI(Envelope roi) {
        this.roi = roi;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public DisposableIterable<VCSGisRepositoryData> getData() {
        if (this.data == null) {
            throw new IllegalStateException("The request needs to be executed before calling this method.");
        }
        return this.data;
    }

    public VCSGisEntity getEntity() {
        if (this.data == null) {
            throw new IllegalStateException("The request needs to be executed before calling this method.");
        }
        return this.entity;
    }

    public String getUsersHashCode() {
        return this.usersHashCode;
    }

    public String getTopologyPlansHashCode() {
        return this.topologyPlansHashCode;
    }

    @Override
    public void dispose() {
        super.dispose();
        DisposeUtils.disposeQuietly(this.data);
        this.data = null;
        this.entity = null;
        this.entityName = null;
        this.roi = null;
    }
}

