/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.localdb.requests.PrepareWCRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisPrepareWCRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class PrepareWCHandler
extends AbstractVCSGisServertHandler {
    public PrepareWCHandler(VCSGisRepository repository) {
        super(repository, "PrepareWCHandler");
    }

    private String getValue(Map<String, String> params, JsonObject json, String name) {
        String value = params.get(name);
        if (json != null) {
            value = json.getString(name, value);
        }
        return value;
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        VCSGisPrepareWCRequest request = this.getRepository().createPrepareWCRequest();
        request.setAuthenticationTokenAndUser(params);
        JsonObject jsonParameters = null;
        try {
            JsonReader reader = Json.createReader((Reader)request_contents);
            JsonObject jsonRequest = reader.readObject();
            jsonParameters = jsonRequest.getJsonObject("Parameters");
        }
        catch (JsonException jsonException) {
            // empty catch block
        }
        request.setName(this.getValue(params, jsonParameters, "name"));
        request.setLabel(this.getValue(params, jsonParameters, "label"));
        request.setCategories(this.getValue(params, jsonParameters, "categories"));
        request.setUserName(this.getValue(params, jsonParameters, "username"));
        request.setUserPass(this.getValue(params, jsonParameters, "userpass"));
        if (request instanceof PrepareWCRequestLocaldb) {
            ((PrepareWCRequestLocaldb)request).setRemoteHost(params.get("$RemoteHost"));
        }
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  1");
        VCSGisPrepareWCRequest request = (VCSGisPrepareWCRequest)req;
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  3");
        JsonObjectBuilder jsonResponse = Json.createObjectBuilder();
        JsonObjectBuilder jsonParams = Json.createObjectBuilder();
        jsonParams.add("StatusCode", 0);
        jsonParams.addNull("StatusMessage");
        jsonResponse.add("Parameters", (javax.json.JsonObjectBuilder)jsonParams);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  5 notifyResponseConsumers");
        this.notifyResponseConsumers();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  6 write json");
        IOUtils.write((String)jsonResponse.toString(), (Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  7 flush");
        response_contents.flush();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  8 close");
        IOUtils.closeQuietly((Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  9 return");
    }
}

