/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.servlets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonObject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.CloseShieldWriter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.HooksRepoTable;
import org.gvsig.vcsgis.lib.server.VCSGisServerController;
import org.gvsig.vcsgis.lib.server.VCSGisServerHandler;
import org.gvsig.vcsgis.lib.server.VCSGisServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVCSGisServlet
extends HttpServlet {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractVCSGisServlet.class);
    public static final String CONFIG_CACHED_REPOSITORY_IN_CONTEXT = "CACHED_REPOSITORY_IN_CONTEXT";
    public static final String CONFIG_CALLBACK_METHOD = "CALLBACK_METHOD";
    private static boolean Libraries_initialized = false;

    protected void initLibraries() {
        if (!Libraries_initialized) {
            new DefaultLibrariesInitializer().fullInitialize();
            Libraries_initialized = true;
        }
    }

    protected String getContextID() {
        String contextPath = this.getServletContext().getContextPath();
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            return "default";
        }
        contextPath = StringUtils.removeStart((String)contextPath, (String)"/");
        contextPath = StringUtils.replace((String)contextPath, (String)"/", (String)"_");
        return contextPath;
    }

    protected JsonObject getConfiguration() {
        JsonObject theConfig = VCSGisServerUtils.getConfiguration();
        if (theConfig == null) {
            URL config_url = this.getConfigurationURL();
            VCSGisServerUtils.setConfiguration((URL)config_url);
            theConfig = VCSGisServerUtils.getConfiguration();
        }
        return theConfig;
    }

    protected URL getConfigurationURL() {
        URL config_url = VCSGisServerUtils.getConfigurationURL((String)this.getContextID(), (String)this.getServletContext().getRealPath("/"), t -> {
            try {
                return this.getServletContext().getResource(t);
            }
            catch (MalformedURLException ex) {
                return null;
            }
        });
        return config_url;
    }

    protected VCSGisRepository createRepository() {
        VCSGisRepositoryLocaldbImpl repository = (VCSGisRepositoryLocaldbImpl)((Object)this.getServletContext().getAttribute("VCSGisRepository"));
        if (repository == null) {
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            JsonObject config = this.getConfiguration();
            JDBCServerExplorerParameters connectionParameters = VCSGisServerUtils.getConnectionParameters((JsonObject)config);
            repository = (VCSGisRepositoryLocaldbImpl)manager.openRepository(connectionParameters);
            repository.setProperty("config", config);
            HooksRepoTable.WatchersNotifier watchersNotifier = (HooksRepoTable.WatchersNotifier)this.getServletContext().getAttribute("VCSGisWatchersNotifier");
            if (watchersNotifier == null) {
                String callbackMethod = config.getString(CONFIG_CALLBACK_METHOD, null);
                if (StringUtils.isNotBlank((CharSequence)callbackMethod)) {
                    watchersNotifier = HooksRepoTable.createWatchersNotifier(callbackMethod, repository);
                    this.getServletContext().setAttribute("VCSGisWatchersNotifier", (Object)watchersNotifier);
                } else {
                    LOGGER.warn("Can't config watchersNotifier. See CALLBACK_METHOD property in config file!!!!!!!!!");
                }
            }
            repository.setWatchersNotifier(watchersNotifier);
            if (BooleanUtils.toBoolean((String)config.getString(CONFIG_CACHED_REPOSITORY_IN_CONTEXT, "false"))) {
                this.getServletContext().setAttribute("VCSGisRepository", (Object)repository);
                DisposeUtils.bind((Disposable)repository);
            }
        }
        return repository;
    }

    protected VCSGisServerController createVCSGisServerController() {
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisRepository repository = this.createRepository();
        VCSGisServerController serverController = manager.createServerController(repository);
        DisposeUtils.disposeQuietly((Disposable)repository);
        return serverController;
    }

    protected abstract VCSGisServerHandler createHandler(VCSGisServerController var1);

    protected void message(String msg) {
        VCSGisServerUtils.console_writeln((String)msg);
    }

    protected Map<String, String> getRequestParameters(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            params.put(name, request.getParameter(name));
        }
        params.put("$RequestURL", request.getRequestURL().toString());
        params.put("$RemoteAddr", request.getRemoteAddr());
        params.put("$RemoteHost", request.getRemoteHost());
        String authorization = request.getHeader("Authorization");
        if (StringUtils.startsWithIgnoreCase((CharSequence)"Bearer ", (CharSequence)authorization)) {
            params.put("auth", StringUtils.substring((String)authorization, (int)7));
        }
        return params;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        VCSGisServerController vcsgisserver = null;
        try {
            this.initLibraries();
            this.message(request.getMethod() + " " + request.getRequestURL());
            JsonObject conf = this.getConfiguration();
            H2SpatialUtils.set_enable_server((boolean)false);
            boolean enable_h2_server = conf.getBoolean("h2_server_enable", false);
            if (enable_h2_server && !H2SpatialUtils.is_server_started()) {
                H2SpatialUtils.set_enable_server((boolean)true);
                int port = conf.getInt("h2_server_port", -1);
                if (port != -1) {
                    H2SpatialUtils.set_enable_server((boolean)enable_h2_server);
                }
            }
            Map<String, String> params = this.getRequestParameters(request);
            vcsgisserver = this.createVCSGisServerController();
            VCSGisServerHandler handler = this.createHandler(vcsgisserver);
            Object input = request.getInputStream();
            if (LOGGER.isDebugEnabled()) {
                input = new InputStreamWrapper(((Object)((Object)this)).getClass().getSimpleName(), (InputStream)input);
            }
            response.setContentType(handler.getContentType());
            response.setCharacterEncoding("utf-8");
            Object writer = CloseShieldWriter.wrap((Writer)response.getWriter());
            Writer debugWriter = VCSGisLocator.getVCSGisManager().getWriterForProtocolDebugging();
            if (debugWriter != null) {
                String header = "\nRESPONSE " + request.getMethod() + " " + request.getRequestURL() + "\n";
                writer = new DebugWriter((Writer)writer, debugWriter, header);
            }
            handler.handle(VCSGisServerUtils.getConsoleWriter(), params, (InputStream)input, (Writer)writer);
            response.setStatus(200);
            if (LOGGER.isDebugEnabled()) {
                ((InputStreamWrapper)input).flush();
            }
        }
        catch (Exception ex) {
            try {
                this.message(ex.toString());
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(vcsgisserver);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)vcsgisserver);
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final InputStream delegated;
        private final String label;
        private final ByteArrayOutputStream buffer;

        public InputStreamWrapper(String label, InputStream delegated) {
            this.label = label;
            this.delegated = delegated;
            this.buffer = new ByteArrayOutputStream();
        }

        @Override
        public int read() throws IOException {
            int ch = this.delegated.read();
            this.buffer.write(ch);
            if (this.buffer.size() > 100) {
                this.flush();
            }
            return ch;
        }

        @Override
        public void close() throws IOException {
            this.delegated.close();
            this.flush();
        }

        @Override
        public int available() throws IOException {
            return this.delegated.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegated.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.delegated.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegated.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegated.skip(n);
        }

        public void flush() {
            LOGGER.debug("REQUEST " + this.label + ": \n" + this.buffer.toString());
            this.buffer.reset();
        }
    }

    private static class DebugWriter
    extends Writer {
        private final Writer toclient;
        private final Writer toDebugFile;
        private boolean firstWrite;
        private final String debugHeader;

        public DebugWriter(Writer toclient, Writer toDebugFile, String debugHeader) {
            this.toDebugFile = toDebugFile;
            this.toclient = toclient;
            this.firstWrite = true;
            this.debugHeader = debugHeader;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.toclient.write(cbuf, off, len);
            if (this.firstWrite) {
                this.toDebugFile.write(this.debugHeader);
                this.firstWrite = false;
            }
            this.toDebugFile.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.toclient.flush();
            this.toDebugFile.flush();
        }

        @Override
        public void close() throws IOException {
            this.toclient.close();
            this.toDebugFile.close();
        }
    }
}

