/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.swing.impl.copyxml2db;

import java.awt.Color;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.PersonalDatabaseServerExplorerFactory;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.xml2db.lib.api.Xml2dbLocator;
import org.gvsig.xml2db.lib.api.Xml2dbManager;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLInfo;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLTableInfo;
import org.gvsig.xml2db.swing.Xml2dbPanel;
import org.gvsig.xml2db.swing.impl.Task;
import org.gvsig.xml2db.swing.impl.Xml2dbSwingCommons;
import org.gvsig.xml2db.swing.impl.copyxml2db.CopyXml2dbPanelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyXml2dbPanel
extends CopyXml2dbPanelView
implements Xml2dbPanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CopyXml2dbPanel.class);
    private PickerController<Locale> pickerLocale;
    private Dialog dialog;
    private FilePickerController pickerXMLFile;
    private FilePickerController pickerDbfile;
    private ProjectionPickerController pickerProjection;
    private CharsetPickerController pickerCharset;
    private TaskStatusController taskStatusController;
    private Task lastTask;
    private XMLInfo xmlinfo;

    public CopyXml2dbPanel() {
        this.createComponents();
    }

    private void createComponents() {
        this.lastTask = Task.FAKE_TASK;
        this.xmlinfo = null;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.taskStatusController = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(this.lblStatusCaption, this.lblStatusMsg, this.pbStatus);
        this.taskStatusController.setVisible(false);
        this.translate();
        this.pickerXMLFile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtXMLFile, this.btnXMLFile, null, "Xml2db_xmlFile", null, true);
        this.pickerXMLFile.addChangeListener(e -> this.doChangeXMLfile());
        this.pickerCharset = toolsSwingManager.createCharsetPickerController(null, this.cboCharset);
        this.btnDetectCharset.addActionListener(e -> this.doDetectCharset());
        this.pickerProjection = dataSwingManager.createProjectionPickerController(this.txtProjection, this.btnProjection);
        this.btnDetectProjection.addActionListener(e -> this.doDetectProjection());
        this.cboDatabaseType.setModel(Xml2dbSwingCommons.getPersonalDatabaseServerExplorersComboModel());
        this.pickerDbfile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtDatabaseFile, this.btnDataBaseFile);
        this.pickerDbfile.addChangeListener(e -> this.doChangeDBfile());
        this.pickerCharset.set((Object)Charset.defaultCharset());
        this.chkRegisterConnection.setSelected(true);
        this.chkConnectToRepository.setSelected(true);
        this.chkOverwriteDatabase.setSelected(false);
        this.chkOverwriteDatabase.addChangeListener(e -> this.updateStateComponents());
        this.cboCharset.setSelectedIndex(-1);
        this.pickerLocale = toolsSwingManager.createLocalePickerController(this.cboLocale);
        this.pickerLocale.set((Object)Locale.getDefault());
        toolsSwingManager.addClearButton((JTextComponent)this.txtPrefixesForTables);
        SwingUtilities.invokeLater(() -> this.updateStateComponents());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)80, (int)17, (int)100);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblCharset);
        toolsSwingManager.translate(this.lblRepositoryName);
        toolsSwingManager.translate(this.lblFileXML);
        toolsSwingManager.translate(this.lblDatabaseFile);
        toolsSwingManager.translate(this.lblProjection);
        toolsSwingManager.translate(this.lblRegisterConnection);
        toolsSwingManager.translate(this.lblConnectToRepository);
        toolsSwingManager.translate(this.lblOverwriteDatabase);
        toolsSwingManager.translate(this.lblLocale);
        toolsSwingManager.translate((AbstractButton)this.btnDetectProjection);
        toolsSwingManager.translate((AbstractButton)this.btnDetectCharset);
        toolsSwingManager.translate(this.lblPrefixesForTables);
        toolsSwingManager.translate(this.lblDatabaseType);
    }

    private boolean isProcessing() {
        return this.lastTask.isProcessing();
    }

    private void updateStateComponents() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateStateComponents);
            return;
        }
        if (this.isProcessing()) {
            this.pickerXMLFile.setEnabled(false);
            this.pickerCharset.setEnabled(false);
            this.pickerProjection.setEnabled(false);
            this.btnDetectCharset.setEnabled(false);
            this.btnDetectProjection.setEnabled(false);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        PersonalDatabaseServerExplorerFactory explorerFactory = this.getExplorerFactory();
        this.pickerXMLFile.setEnabled(true);
        this.pickerCharset.setEnabled(true);
        this.pickerProjection.setEnabled(true);
        I18nManager i18n = ToolsLocator.getI18nManager();
        File xmlfile = (File)this.pickerXMLFile.get();
        if (xmlfile == null || !xmlfile.exists()) {
            this.btnDetectCharset.setEnabled(false);
            this.btnDetectProjection.setEnabled(false);
            if (xmlfile == null) {
                this.message(i18n.getTranslation("_XML_file_is_required"), 2);
            } else {
                this.message(i18n.getTranslation("_XML_file_not_exists"), 2);
            }
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        this.btnDetectCharset.setEnabled(true);
        this.btnDetectProjection.setEnabled(true);
        File dbfile = (File)this.pickerDbfile.get();
        if (dbfile == null) {
            this.message(i18n.getTranslation("_Database_file_is_required"), 2);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        if (explorerFactory.existsdb(dbfile) && !this.chkOverwriteDatabase.isSelected()) {
            this.message(i18n.getTranslation("_Database_file_already_exists"), 2);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.txtRepositoryName.getText())) {
            this.message(i18n.getTranslation("_Repository_name_is_required"), 2);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, true);
        }
        if (this.lastTask.needToShowTheStatus()) {
            this.taskStatusController.setVisible(true);
        } else {
            this.message(null);
            this.taskStatusController.setVisible(false);
        }
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void performAction() {
        this.doCopy();
    }

    private void doCopy() {
        final File xmlfile = (File)this.pickerXMLFile.get();
        if (xmlfile == null || !xmlfile.exists()) {
            return;
        }
        final IProjection userproj = (IProjection)this.pickerProjection.get();
        final Charset charset = (Charset)this.pickerCharset.get();
        final File dbfile = (File)this.pickerDbfile.get();
        if (dbfile == null || dbfile.exists()) {
            return;
        }
        String s = this.txtRepositoryName.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            s = FilenameUtils.getBaseName((String)dbfile.getName());
        }
        final String repoName = s;
        final boolean registerConnection = this.chkRegisterConnection.isSelected();
        final boolean connectToRepository = this.chkConnectToRepository.isSelected();
        final PersonalDatabaseServerExplorerFactory explorerFactory = this.getExplorerFactory();
        final Xml2dbManager manager = Xml2dbLocator.getXml2dbManager();
        final I18nManager i18n = ToolsLocator.getI18nManager();
        if (explorerFactory.existsdb(dbfile) && !this.chkOverwriteDatabase.isSelected()) {
            this.message(i18n.getTranslation("_Database_file_already_exists"), 2);
            return;
        }
        final String tablesPrefix = (String)StringUtils.defaultIfBlank((CharSequence)this.txtPrefixesForTables.getText(), null);
        final Locale locale = (Locale)this.pickerLocale.get();
        this.lastTask = new Task("Xml2db_copy", i18n.getTranslation("_Copy_xml_to_database"), this::updateStateComponents, this.taskStatusController){

            @Override
            protected void task(SimpleTaskStatus taskStatus) throws Throwable {
                try {
                    JDBCServerExplorerParameters params;
                    XMLInfo xmlinfo;
                    if (explorerFactory.existsdb(dbfile)) {
                        taskStatus.message(i18n.getTranslation("_Removing_existing_database"));
                        explorerFactory.serverStop();
                        explorerFactory.removedb(dbfile);
                        explorerFactory.serverStart(new Object[0]);
                    }
                    if ((xmlinfo = manager.extractStructure(xmlfile, charset, userproj, locale, tablesPrefix, taskStatus)) == null) {
                        throw new RuntimeException("Can't process xml file");
                    }
                    if (userproj == null) {
                        if (xmlinfo.getSrid() == null) {
                            if (xmlinfo.hasGeometries()) {
                                throw new RuntimeException("_Projection_is_required");
                            }
                        } else {
                            CopyXml2dbPanel.this.pickerProjection.set((Object)xmlinfo.getSrid());
                        }
                    }
                    if (xmlinfo.getCharset() != null && charset == null) {
                        CopyXml2dbPanel.this.pickerCharset.set((Object)xmlinfo.getCharset());
                    }
                    if ((params = manager.createDatabase(explorerFactory.getName(), dbfile, xmlinfo, taskStatus)) == null) {
                        throw new RuntimeException("Can't copy xml to database");
                    }
                    if (registerConnection) {
                        CopyXml2dbPanel.this.addToConnectionPool(params, repoName);
                    }
                    manager.copyXml2Db(xmlfile, xmlinfo.getCharset(), params, tablesPrefix, taskStatus);
                    if (connectToRepository) {
                        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
                        dataSwingManager.connectToDatabaseWorkspace(params);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't copy xml to database", (Throwable)ex);
                    throw ex;
                }
            }

            @Override
            protected void postTask() {
            }
        };
        this.lastTask.start();
    }

    public void addToConnectionPool(JDBCServerExplorerParameters params, String id) {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.getDataServerExplorerPool().add(id, (DataServerExplorerParameters)params);
    }

    private void doChangeXMLfile() {
        File dbfile;
        File xmlfile = (File)this.pickerXMLFile.get();
        if (xmlfile != null && (dbfile = (File)this.pickerDbfile.get()) == null) {
            dbfile = new File(FilenameUtils.removeExtension((String)xmlfile.getAbsolutePath()));
            this.pickerDbfile.set((Object)dbfile);
            this.txtRepositoryName.setText(FilenameUtils.getBaseName((String)xmlfile.getName()));
        }
        this.updateStateComponents();
    }

    private void doChangeDBfile() {
        String repoName;
        File dbfile = (File)this.pickerDbfile.get();
        if (dbfile != null && StringUtils.isBlank((CharSequence)(repoName = this.txtRepositoryName.getText()))) {
            this.txtRepositoryName.setText(FilenameUtils.getBaseName((String)dbfile.getName()));
        }
        this.updateStateComponents();
    }

    private void doDetectCharset() {
        Xml2dbManager manager = Xml2dbLocator.getXml2dbManager();
        this.pickerCharset.set((Object)manager.detectCharset((File)this.pickerXMLFile.get()));
    }

    private void doDetectProjection() {
        final Xml2dbManager manager = Xml2dbLocator.getXml2dbManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        Task task = new Task("Xml2db_detectProjection", i18n.getTranslation("_Detecting_projection"), this::updateStateComponents, this.taskStatusController){

            @Override
            protected void task(SimpleTaskStatus taskStatus) throws Throwable {
                try {
                    CopyXml2dbPanel.this.pickerProjection.set((Object)manager.detectProjection((File)CopyXml2dbPanel.this.pickerXMLFile.get(), taskStatus));
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't detect projection", (Throwable)ex);
                    throw ex;
                }
            }
        };
        task.start();
    }

    private void message(String msg) {
        this.message(msg, 1);
    }

    private void message(String msg, int type) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.message(msg, type));
            return;
        }
        if (StringUtils.isBlank((CharSequence)msg)) {
            this.lblStatusMsg.setText("");
            return;
        }
        String s = msg;
        if (type == 2) {
            s = Xml2dbSwingCommons.getHTMLColorTag(Color.RED.darker(), msg);
        }
        this.lblStatusMsg.setText(s);
        this.lblStatusMsg.setVisible(true);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    private PersonalDatabaseServerExplorerFactory getExplorerFactory() {
        LabeledValue item = (LabeledValue)this.cboDatabaseType.getSelectedItem();
        if (item == null) {
            return null;
        }
        return (PersonalDatabaseServerExplorerFactory)item.getValue();
    }

    private static class XMLInfoListModel
    extends AbstractListModel<LabeledValue<XMLTableInfo>> {
        private final XMLInfo xmlinfo;
        private final List<LabeledValue<XMLTableInfo>> tables;

        public XMLInfoListModel() {
            this(null);
        }

        public XMLInfoListModel(XMLInfo xmlinfo) {
            this.xmlinfo = xmlinfo;
            if (xmlinfo != null) {
                this.tables = new ArrayList<LabeledValue<XMLTableInfo>>(xmlinfo.size());
                for (XMLTableInfo tableInfo : xmlinfo) {
                    this.tables.add((LabeledValue<XMLTableInfo>)new LabeledValueImpl(tableInfo.getName(), (Object)tableInfo));
                }
            } else {
                this.tables = null;
            }
        }

        @Override
        public LabeledValue<XMLTableInfo> getElementAt(int index) {
            if (this.tables == null) {
                return null;
            }
            return this.tables.get(index);
        }

        @Override
        public int getSize() {
            if (this.tables == null) {
                return 0;
            }
            return this.tables.size();
        }
    }
}

