/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.swing.impl.importxml2db;

import java.awt.Color;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.xml2db.lib.api.Xml2dbLocator;
import org.gvsig.xml2db.lib.api.Xml2dbManager;
import org.gvsig.xml2db.swing.Xml2dbPanel;
import org.gvsig.xml2db.swing.impl.Task;
import org.gvsig.xml2db.swing.impl.Xml2dbSwingCommons;
import org.gvsig.xml2db.swing.impl.createdbfromxml.CreatedbFromXmlPanel;
import org.gvsig.xml2db.swing.impl.importxml2db.ImportXML2dbPanelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportXML2dbPanel
extends ImportXML2dbPanelView
implements Xml2dbPanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CreatedbFromXmlPanel.class);
    private Dialog dialog;
    private FilePickerController pickerXMLFile;
    private PickerController<JDBCServerExplorerParameters> pickerConnection;
    private TaskStatusController taskStatusController;
    private Task lastTask;
    private CharsetPickerController pickerCharset;

    public ImportXML2dbPanel() {
        this.createComponents();
    }

    private void createComponents() {
        this.lastTask = Task.FAKE_TASK;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.taskStatusController = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(this.lblStatusCaption, this.lblStatusMsg, this.pbStatus);
        this.taskStatusController.setVisible(false);
        this.translate();
        this.pickerXMLFile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtXMLFile, this.btnXMLFile, null, "Xml2db_xmlFile", null, true);
        this.pickerXMLFile.addChangeListener(e -> this.updateStateComponents());
        this.pickerCharset = toolsSwingManager.createCharsetPickerController(null, this.cboCharset);
        this.pickerCharset.set(null);
        this.btnDetectCharset.addActionListener(e -> this.doDetectCharset());
        this.pickerConnection = dataSwingManager.createJDBCConnectionPickerController(this.cboConnection, this.btnConnection);
        this.pickerConnection.addChangeListener(e -> this.updateStateComponents());
        this.chkConnectToRepository.setSelected(true);
        this.txtPrefixesForTables.addActionListener(e -> this.updateStateComponents());
        toolsSwingManager.addClearButton((JTextComponent)this.txtPrefixesForTables);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)8, (int)80, (int)10, (int)100);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblDatabase);
        toolsSwingManager.translate(this.lblFileXML);
        toolsSwingManager.translate(this.lblCharset);
        toolsSwingManager.translate(this.lblConnectToRepository);
        toolsSwingManager.translate((AbstractButton)this.btnDetectCharset);
        toolsSwingManager.translate(this.lblPrefixesForTables);
    }

    private void updateStateComponents() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateStateComponents);
            return;
        }
        this.message(null);
        if (this.isProcessing()) {
            this.pickerXMLFile.setEnabled(false);
            this.pickerCharset.setEnabled(false);
            this.pickerConnection.setEnabled(false);
            this.btnDetectCharset.setEnabled(false);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        this.pickerXMLFile.setEnabled(true);
        this.pickerCharset.setEnabled(true);
        this.pickerConnection.setEnabled(true);
        I18nManager i18n = ToolsLocator.getI18nManager();
        File xmlfile = (File)this.pickerXMLFile.get();
        if (xmlfile == null || !xmlfile.exists()) {
            this.btnDetectCharset.setEnabled(false);
            if (xmlfile == null) {
                this.message(i18n.getTranslation("_XML_file_is_required"), 2);
            } else {
                this.message(i18n.getTranslation("_XML_file_not_exists"), 2);
            }
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        this.btnDetectCharset.setEnabled(true);
        JDBCServerExplorerParameters conn = (JDBCServerExplorerParameters)this.pickerConnection.get();
        if (conn == null) {
            this.message(i18n.getTranslation("_A_database_connection_is_required"), 2);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, true);
        }
        this.taskStatusController.setVisible(this.lastTask.needToShowTheStatus());
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void performAction() {
        this.doImportXML();
    }

    private void doImportXML() {
        final Xml2dbManager manager = Xml2dbLocator.getXml2dbManager();
        final File xmlfile = (File)this.pickerXMLFile.get();
        if (xmlfile == null || !xmlfile.exists()) {
            return;
        }
        final JDBCServerExplorerParameters dbparams = (JDBCServerExplorerParameters)this.pickerConnection.get();
        if (dbparams == null) {
            return;
        }
        final Charset charset = (Charset)this.pickerCharset.get();
        final boolean connectToRepository = this.chkConnectToRepository.isSelected();
        final String tablesPrefix = (String)StringUtils.defaultIfBlank((CharSequence)this.txtPrefixesForTables.getText(), null);
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.lastTask = new Task("Xml2db_copyXmml2Db", i18n.getTranslation("_Copying_XML_data"), this::updateStateComponents, this.taskStatusController){

            @Override
            protected void task(SimpleTaskStatus taskStatus) throws Throwable {
                try {
                    manager.copyXml2Db(xmlfile, charset, dbparams, tablesPrefix, taskStatus);
                    if (connectToRepository) {
                        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
                        dataSwingManager.connectToDatabaseWorkspace(dbparams);
                    }
                    taskStatus.terminate();
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't import xml", (Throwable)ex);
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18n.getTranslation("_Problems_processing_XML_file") + "\n\n" + ex.getLocalizedMessage(), i18n.getTranslation("_Xml2db_Import_xml_data_to_a_existing_database"), 2);
                    throw ex;
                }
            }
        };
        this.lastTask.start();
    }

    private void message(String msg) {
        this.message(msg, 1);
    }

    private void message(String msg, int type) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            this.lblStatusMsg.setText("");
            return;
        }
        if (type == 2) {
            msg = Xml2dbSwingCommons.getHTMLColorTag(Color.RED.darker(), msg);
        }
        this.lblStatusMsg.setText(msg);
        this.lblStatusMsg.setVisible(true);
    }

    private boolean isProcessing() {
        return this.lastTask.isProcessing();
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    private void doDetectCharset() {
        Xml2dbManager manager = Xml2dbLocator.getXml2dbManager();
        this.pickerCharset.set((Object)manager.detectCharset((File)this.pickerXMLFile.get()));
    }
}

