/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Dimension;
import javax.swing.JComponent;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.newlayer.NewLayerLocator;
import org.gvsig.newlayer.NewLayerManager;
import org.gvsig.newlayer.NewLayerService;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class NewTableExtension
extends Extension {
    public void initialize() {
    }

    public void postInitialize() {
        super.postInitialize();
    }

    public void execute(String actionCommand) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        final ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (view != null) {
            NewLayerManager manager = NewLayerLocator.getManager();
            NewLayerService service = manager.createNewLayerService();
            service.addNewLayerServiceListener((NewLayerService.NewLayerServiceListener)new NewLayerService.NewLayerServiceAdapter(){

                public void postCreateTable(NewLayerService service) {
                    if (!service.isAddTableToProject()) {
                        return;
                    }
                    try {
                        DataStoreParameters storeParameters = service.getOpenStoreParameters();
                        DataManager dataManager = DALLocator.getDataManager();
                        FeatureStore store = (FeatureStore)dataManager.openStore(storeParameters.getProviderName(), storeParameters);
                        String name = FeatureStore.getLabel((FeatureStore)store);
                        ProjectManager projectManager = application.getProjectManager();
                        TableDocument doc = (TableDocument)projectManager.createDocument(TableManager.TYPENAME, name);
                        doc.setStore(store);
                        Project project = application.getCurrentProject();
                        project.addDocument((Document)doc);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            NewLayerWizard wizard = manager.createNewLayerWizard(service);
            wizard.setAddTableToProjectTitle(i18n.getTranslation("_Add_table"));
            wizard.setAddTableToProjectLabel(i18n.getTranslation("_Add_table_to_project"));
            Dimension screensize = ToolsSwingUtils.getCurrentScreenSize();
            ToolsSwingUtils.ensureHeightWitdh((JComponent)wizard, (int)(3 * (screensize.height / 4)), (int)(2 * (screensize.width / 4)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
            WindowManager windowMgr = ToolsSwingLocator.getWindowManager();
            windowMgr.showWindow((JComponent)wizard, i18n.getTranslation("_New_table_wizard"), WindowManager.MODE.WINDOW);
        }
    }

    public boolean isEnabled() {
        return this.isVisible();
    }

    public boolean isVisible() {
        return true;
    }
}

