/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowGraphicsLayerTable
extends Extension
implements PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ShowGraphicsLayerTable.class);
    private ApplicationManager appManager = ApplicationLocator.getManager();

    public boolean isEnabled() {
        return this.getCurrentViewDocument() != null;
    }

    private ViewDocument getCurrentViewDocument() {
        return (ViewDocument)this.appManager.getActiveDocument(ViewManager.TYPENAME);
    }

    public boolean isVisible() {
        try {
            ViewDocument document = this.getCurrentViewDocument();
            if (document == null) {
                return false;
            }
            GraphicLayer graphicsLayer = document.getMapContext().getGraphicsLayer();
            TableManager tableManager = this.getTableManager();
            TableDocument tableDocument = tableManager.getTableDocument((VectorLayer)graphicsLayer);
            return tableDocument != null || document.getMapContext().getGraphicsLayer().getFeatureStore().getFeatureCount() > 0L;
        }
        catch (DataException e) {
            LOG.error("Error checking if the current document is a view and has data in the graphics layer", (Throwable)e);
            return false;
        }
    }

    public void execute(String action) {
        ViewDocument document = this.getCurrentViewDocument();
        GraphicLayer graphicsLayer = document.getMapContext().getGraphicsLayer();
        ProjectManager projectManager = this.getProjectManager();
        TableManager tableManager = this.getTableManager();
        TableDocument tableDocument = tableManager.getTableDocument((VectorLayer)graphicsLayer);
        FeatureStore fs = graphicsLayer.getFeatureStore();
        if (tableDocument == null) {
            tableDocument = (TableDocument)projectManager.createDocument(TableManager.TYPENAME, PluginServices.getText((Object)this, (String)"Tabla_de_Atributos") + ": " + graphicsLayer.getName());
            tableDocument.setStore(fs);
            tableDocument.setAssociatedLayer((VectorLayer)graphicsLayer);
            projectManager.getCurrentProject().add((Document)tableDocument);
        }
        tableDocument.setModified(true);
        FeatureTableDocumentPanel featureTableDocumentPanel = (FeatureTableDocumentPanel)tableManager.getMainWindow((Document)tableDocument);
        this.appManager.getUIManager().addWindow((IWindow)featureTableDocumentPanel);
    }

    private ProjectManager getProjectManager() {
        return ProjectManager.getInstance();
    }

    private TableManager getTableManager() {
        TableManager tableManager = (TableManager)this.getProjectManager().getDocumentManager(TableManager.TYPENAME);
        return tableManager;
    }

    public void initialize() {
        this.registerIcons();
    }

    public void postInitialize() {
        this.getProjectManager().getCurrentProject().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-show-attributes-table", (Object)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("delDocument".equals(evt.getPropertyName()) && evt.getOldValue() != null && evt.getOldValue() instanceof ViewDocument) {
            ViewDocument viewDocument = (ViewDocument)evt.getOldValue();
            this.getTableManager().removeTableDocument((VectorLayer)viewDocument.getMapContext().getGraphicsLayer());
        }
    }
}

