/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.table.gui.CreateNewAttributePanel;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.StoreUpdateFeatureTypeException;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.FeatureTable;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTableModel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOperations {
    private static final Logger logger = LoggerFactory.getLogger(TableOperations.class);
    public static final int MAX_FIELD_LENGTH = 254;
    private static TableOperations fto = null;
    private FeatureTableDocumentPanel tablePanel = null;
    private FeatureStore featureStore;

    public static TableOperations getInstance() {
        if (fto == null) {
            fto = new TableOperations();
        }
        return fto;
    }

    public void setTablePanel(FeatureTableDocumentPanel tp) {
        this.tablePanel = tp;
        this.featureStore = tp.getModel().getStore();
    }

    public void copyFeatures() throws DataException {
        this.copy();
    }

    public boolean hasSelection() {
        return !ToolsSwingLocator.getToolsSwingManager().isClipboardEmpty();
    }

    public void pasteFeatures() throws DataException {
        try {
            EditableFeature feature;
            if (this.featureStore == null) {
                return;
            }
            List features = DALLocator.getDataManager().getFeaturesFromClipboard(this.featureStore, null);
            if (CollectionUtils.isEmpty((Collection)features)) {
                return;
            }
            Iterator iterator = features.iterator();
            while (iterator.hasNext() && this.insertFeature(feature = (EditableFeature)iterator.next())) {
            }
        }
        catch (Exception e) {
            logger.warn("Can't paste from clipboard.", (Throwable)e);
        }
    }

    private void copy() throws DataException {
        DALLocator.getDataManager().putFeaturesInClipboard((FeatureSet)this.featureStore.getFeatureSelection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFeatures() throws DataException {
        ConfigurableFeatureTableModel _ftm = this.tablePanel.getTablePanel().getTableModel();
        List<TableModelListener> tmll = this.removeTableModelListeners((FeatureTableModel)_ftm);
        DisposableIterator feat_iter = null;
        Feature feat = null;
        try {
            FeatureSelection selection = this.featureStore.createFeatureSelection();
            selection.select((FeatureSet)this.featureStore.getSelection());
            feat_iter = selection.fastIterator();
            while (feat_iter.hasNext()) {
                feat = (Feature)feat_iter.next();
                if (this.deleteFeature(feat)) continue;
                return;
            }
        }
        finally {
            if (feat_iter != null) {
                feat_iter.dispose();
            }
            this.addTableModelListeners((FeatureTableModel)_ftm, tmll);
        }
    }

    private void addTableModelListeners(FeatureTableModel _model, List<TableModelListener> _list) {
        Iterator<TableModelListener> iter = _list.iterator();
        while (iter.hasNext()) {
            _model.addTableModelListener(iter.next());
        }
        _model.fireTableDataChanged();
    }

    private List<TableModelListener> removeTableModelListeners(FeatureTableModel ftm) {
        TableModelListener[] ll = (TableModelListener[])ftm.getListeners(TableModelListener.class);
        ArrayList<TableModelListener> resp = new ArrayList<TableModelListener>();
        int n = ll.length;
        for (int i = 0; i < n; ++i) {
            resp.add(ll[i]);
            ftm.removeTableModelListener(ll[i]);
        }
        return resp;
    }

    public void insertNewFeature() throws DataException {
        EditableFeature feature = this.featureStore.createNewFeature();
        this.insertFeature(feature);
    }

    private boolean insertFeature(EditableFeature feature) throws DataException {
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_INSERT_FEATURE", (Object)this.tablePanel.getDocument(), (DataStore)this.featureStore, (Feature)feature);
        if (notification.isCanceled()) {
            return false;
        }
        if (notification.shouldValidateTheFeature() && !editingNotificationManager.validateFeature((Feature)feature)) {
            return false;
        }
        this.featureStore.insert(feature);
        editingNotificationManager.notifyObservers((Object)this, "AFTER_INSERT_FEATURE", (Object)this.tablePanel.getDocument(), (DataStore)this.featureStore, (Feature)feature);
        return true;
    }

    private boolean deleteFeature(Feature feature) throws DataException {
        EditingNotificationManager editingNotification = DALSwingLocator.getEditingNotificationManager();
        EditingNotification notification = editingNotification.notifyObservers((Object)this, "BEFORE_REMOVE_FEATURE", (Object)this.tablePanel.getDocument(), (DataStore)this.featureStore, feature);
        if (notification.isCanceled()) {
            return false;
        }
        this.featureStore.delete(feature);
        editingNotification.notifyObservers((Object)this, "AFTER_REMOVE_FEATURE", (Object)this.tablePanel.getDocument(), (DataStore)this.featureStore, feature);
        return true;
    }

    private boolean updateFeatureType(EditableFeatureType featureType) throws DataException {
        EditingNotificationManager editingNotification = DALSwingLocator.getEditingNotificationManager();
        EditingNotification notification = editingNotification.notifyObservers((Object)this, "BEFORE_UPDATE_FEATURE_TYPE", (Object)this.tablePanel.getDocument(), (DataStore)this.featureStore, featureType);
        if (notification.isCanceled()) {
            return false;
        }
        this.featureStore.update(featureType);
        editingNotification.notifyObservers((Object)this, "AFTER_UPDATE_FEATURE_TYPE", (Object)this.tablePanel.getDocument(), (DataStore)this.featureStore, featureType);
        return true;
    }

    public void deleteAttributes(FeatureTable table) throws DataException {
        FeatureQueryOrder order;
        FeatureAttributeDescriptor[] selecteds = table.getSelectedColumnsAttributeDescriptor();
        FeatureQuery query = this.tablePanel.getTablePanel().getFeatureQuery();
        if (query != null && (order = query.getOrder()) != null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            FeatureAttributeDescriptor[] featureAttributeDescriptorArray = selecteds;
            int n = featureAttributeDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                FeatureAttributeDescriptor selected = featureAttributeDescriptorArray[i];
                if (!order.contains(selected.getName())) continue;
                int n2 = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(i18n.getTranslation("_You_are_trying_to_remove_the_column_XcolumnNameX_that_is_being_sorted_by_Do_you_wish_to_continue", new String[]{selected.getName()}), i18n.getTranslation("_Delete_column"), 2, 3, "_You_are_trying_to_remove_the_column_XcolumnNameX_that_is_being_sorted_by_Do_you_wish_to_continue");
                if (n2 != 0) {
                    return;
                }
                try {
                    order.remove(order.getIndex(selected.getName()));
                    continue;
                }
                catch (Throwable t) {
                    logger.warn("Can't remove order", t);
                }
            }
        }
        EditableFeatureType eft = this.featureStore.getDefaultFeatureType().getEditable();
        for (FeatureAttributeDescriptor selected : selecteds) {
            eft.remove(selected.getName());
        }
        this.featureStore.update(eft);
    }

    public void insertAttributes(FeatureTable table) throws DataException {
        EditableFeatureType eft = this.featureStore.getDefaultFeatureType().getEditable();
        ArrayList<String> tmpfnames = new ArrayList<String>();
        int size = eft.size();
        for (int i = 0; i < size; ++i) {
            FeatureAttributeDescriptor ad = eft.get(i);
            tmpfnames.add(ad.getName());
        }
        CreateNewAttributePanel panelNewField = new CreateNewAttributePanel(this.featureStore);
        panelNewField.setCurrentFieldNames(tmpfnames.toArray(new String[0]));
        DataManager dataManager = DALLocator.getDataManager();
        FeatureStoreProviderFactory factory = (FeatureStoreProviderFactory)dataManager.getStoreProviderFactory(this.featureStore.getProviderName());
        panelNewField.setMaxAttributeNameSize(factory.getMaxAttributeNameSize());
        panelNewField.setOkAction(new NewFieldActionListener(panelNewField, eft));
        ApplicationLocator.getManager().getUIManager().addWindow((IWindow)panelNewField);
        this.featureStore.update(eft);
    }

    public void renameAttributes(FeatureTable table) throws DataException {
        FeatureQueryOrder order;
        FeatureAttributeDescriptor[] selecteds = table.getSelectedColumnsAttributeDescriptor();
        I18nManager i18n = ToolsLocator.getI18nManager();
        FeatureQuery query = this.tablePanel.getTablePanel().getFeatureQuery();
        if (query != null && (order = query.getOrder()) != null) {
            for (FeatureAttributeDescriptor selected : selecteds) {
                if (!order.contains(selected.getName())) continue;
                int n = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(i18n.getTranslation("_You_are_trying_to_rename_the_column_XcolumnNameX_that_is_being_sorted_by_Do_you_wish_to_continue", new String[]{selected.getName()}), i18n.getTranslation("_Rename_column"), 2, 3, "_You_are_trying_to_rename_the_column_XcolumnNameX_that_is_being_sorted_by_Do_you_wish_to_continue");
                if (n != 0) {
                    return;
                }
                try {
                    order.remove(order.getIndex(selected.getName()));
                }
                catch (Throwable t) {
                    logger.warn("Can't remove order", t);
                }
            }
        }
        FeatureType _ft = this.featureStore.getDefaultFeatureType();
        int maxAttributeNameSize = this.getMaxAttributeSize();
        for (int i = selecteds.length - 1; i >= 0; --i) {
            String newName = "";
            while (newName != null && (newName.isEmpty() || this.checkFieldAlreadyExists(_ft, newName)) || maxAttributeNameSize > -1 && StringUtils.length((CharSequence)newName) > maxAttributeNameSize) {
                ThreadSafeDialogsManager dialogs;
                newName = JOptionPane.showInputDialog((Component)PluginServices.getMDIManager().getActiveWindow(), PluginServices.getText((Object)this, (String)"_Please_insert_new_field_name"), selecteds[i].getName());
                if (newName == null) continue;
                if (newName.length() == 0) {
                    dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18n.getTranslation("_Attribute_name_must_not_by_empty"), null, i18n.getTranslation("_Warning"), 2);
                }
                if (maxAttributeNameSize > -1 && StringUtils.length((CharSequence)newName) > maxAttributeNameSize) {
                    dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18n.getTranslation("_Attribute_name_is_too_long") + "\n" + i18n.getTranslation("_max_size_allowed_for_this_table_is_{0}", new String[]{String.valueOf(maxAttributeNameSize)}), null, i18n.getTranslation("_Warning"), 2);
                }
                if (!this.checkFieldAlreadyExists(_ft, newName)) continue;
                dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("field_already_exists"), null, i18n.getTranslation("_Warning"), 2);
            }
            if (newName == null) continue;
            TableOperations.renameAttribute(this.featureStore, selecteds[i].getName(), newName);
        }
    }

    private boolean checkFieldAlreadyExists(FeatureType ft, String name) {
        FeatureAttributeDescriptor attr = ft.getAttributeDescriptor(name);
        return attr != null && attr.getName().equals(name);
    }

    private int getMaxAttributeSize() {
        if (this.featureStore == null) {
            return -1;
        }
        DataStoreProviderFactory providerFactory = this.featureStore.getProviderFactory();
        if (providerFactory == null) {
            return -1;
        }
        return ((FeatureStoreProviderFactory)providerFactory).getMaxAttributeNameSize();
    }

    private static boolean renameAttribute(FeatureStore fs, String name, String newName) {
        EditableFeatureType eft = null;
        FeatureType dft = null;
        try {
            dft = fs.getDefaultFeatureType();
            eft = dft instanceof EditableFeatureType ? (EditableFeatureType)dft : dft.getEditable();
            EditableFeatureAttributeDescriptor efad = (EditableFeatureAttributeDescriptor)eft.getAttributeDescriptor(name);
            efad.setName(newName);
            fs.update(eft);
        }
        catch (DataException de) {
            Component root_comp = ApplicationLocator.getManager().getRootComponent();
            JOptionPane.showMessageDialog(root_comp, Messages.getText((String)"_Unable_to_rename_attribute") + ": " + de.getMessage(), Messages.getText((String)"_Unable_to_rename_attribute"), 0);
            return false;
        }
        return true;
    }

    public static void renameColumn(FeatureStore fs, String oldname, String newname) throws DataException {
        FeatureType _ft = fs.getDefaultFeatureType();
        if (_ft.getIndex(newname) != -1) {
            throw new StoreUpdateFeatureTypeException((Throwable)new Exception("Attribute name already existed."), fs.getName());
        }
        TableOperations.renameAttribute(fs, oldname, newname);
    }

    public class NewFieldActionListener
    implements ActionListener {
        private CreateNewAttributePanel panel = null;
        private EditableFeatureType eft = null;

        public NewFieldActionListener(CreateNewAttributePanel p, EditableFeatureType t) {
            this.eft = t;
            this.panel = p;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                EditableFeatureAttributeDescriptor ead = this.panel.loadFieldDescription(this.eft);
                if (ead == null) {
                    return;
                }
                if (ead.getType() == 8 && ead.getSize() > 254) {
                    NotificationManager.showMessageInfo((String)(PluginServices.getText((Object)this, (String)"max_length_is") + ":" + 254), null);
                    ead.setSize(254);
                }
                PluginServices.getMDIManager().closeWindow((IWindow)this.panel);
            }
            catch (ParseException e2) {
                NotificationManager.addError((Throwable)e2);
            }
        }
    }
}

