/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table.gui;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowTransform;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.gui.IDocumentWindow;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.FeatureTypesTablePanel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.notification.ColumnHeaderSelectionChangeNotification;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTableDocumentPanel
extends FeatureTypesTablePanel
implements IDocumentWindow,
IWindowTransform,
Observer,
Component {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureTableDocumentPanel.class);
    private static final long serialVersionUID = -1003263265311764630L;
    private static final int DEFAULT_HEIGHT = 450;
    private static final int DEFAULT_WIDTH = 700;
    private boolean isPalette = false;
    private WindowInfo windowInfo = null;
    private TableDocument model = null;
    private boolean selectionIsEmpty = true;

    public FeatureTableDocumentPanel(Document document) throws DataException {
        super(((TableDocument)document).getFeatureStoreModel());
        this.model = (TableDocument)document;
        this.initialize();
        try {
            FeatureType featureType = this.model.getFeatureStore().getDefaultFeatureType();
            for (FeatureAttributeDescriptor descriptor : featureType) {
                this.getTableModel().setFormattingPattern(descriptor.getName(), this.model.getFormattingPattern(descriptor.getName()));
            }
        }
        catch (DataException ex) {
            LOG.warn("Can't initialize columns formating patters", (Throwable)ex);
        }
    }

    public FeatureStore getFeatureStore() {
        return this.getTablePanel().getFeatureStore();
    }

    public JComponent asJComponent() {
        return this;
    }

    public WindowInfo getWindowInfo() {
        if (this.windowInfo == null) {
            this.windowInfo = new WindowInfo(7);
            if (this.model == null) {
                this.windowInfo.setTitle(ToolsLocator.getI18nManager().getTranslation("Table"));
            } else {
                String storeName;
                ApplicationManager application = ApplicationLocator.getApplicationManager();
                String string = storeName = this.model.getFeatureStore() == null ? null : this.model.getFeatureStore().getName();
                if (this.model.getAssociatedLayer() != null) {
                    this.windowInfo.setTitle(application.makeTitle("Tabla_de_Atributos", this.model.getName(), storeName));
                } else {
                    this.windowInfo.setTitle(application.makeTitle("Table", this.model.getName(), storeName));
                }
            }
            this.windowInfo.setWidth(700);
            this.windowInfo.setHeight(450);
        }
        return this.windowInfo;
    }

    public Object getWindowModel() {
        return this.model;
    }

    public void toPalette() {
        this.isPalette = true;
        this.windowInfo.toPalette(true);
        this.windowInfo.setClosed(false);
        PluginServices.getMDIManager().changeWindowInfo((IWindow)this, this.getWindowInfo());
    }

    public void restore() {
        this.isPalette = false;
        this.windowInfo.toPalette(false);
        this.windowInfo.setClosed(false);
        PluginServices.getMDIManager().changeWindowInfo((IWindow)this, this.getWindowInfo());
    }

    public boolean isPalette() {
        return this.isPalette;
    }

    public TableDocument getModel() {
        return this.model;
    }

    public void update(Observable observable, Object notification) {
        FeatureStoreNotification event;
        if ("after_SelectionChange_DataStore".equals(notification)) {
            try {
                if (this.selectionIsEmpty != this.getFeatureSelection().isEmpty()) {
                    this.selectionIsEmpty = !this.selectionIsEmpty;
                    this.enableControls(notification);
                }
            }
            catch (DataException e) {
                LOG.error("Error getting the current selection", (Throwable)e);
            }
        } else if (notification instanceof ColumnHeaderSelectionChangeNotification) {
            this.enableControls(notification);
        } else if (notification instanceof FeatureStoreNotification && "after_SelectionChange_DataStore".equals((event = (FeatureStoreNotification)notification).getType())) {
            try {
                if (this.selectionIsEmpty != this.getFeatureSelection().isEmpty()) {
                    this.selectionIsEmpty = !this.selectionIsEmpty;
                    this.enableControls(notification);
                }
            }
            catch (DataException e) {
                LOG.error("Error getting the current selection", (Throwable)e);
            }
        }
    }

    private void enableControls(Object notification) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginServices.getMainFrame().enableControls();
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Error calling enableControls() after notification: " + notification, (Throwable)e);
        }
    }

    private void initialize() throws DataException {
        this.getTablePanel().getTable().addObserver((Observer)this);
        this.getTableModel().getFeatureStore().addObserver((Observer)this);
    }

    private FeatureSelection getFeatureSelection() throws DataException {
        return this.getTableModel().getFeatureStore().getFeatureSelection();
    }

    public Object getWindowProfile() {
        return WindowInfo.EDITOR_PROFILE;
    }

    public WindowLayout getWindowLayout() {
        return null;
    }

    public void setWindowLayout(WindowLayout layout) {
    }

    public void setDocument(Document document) {
    }

    public Document getDocument() {
        return this.model;
    }

    public void windowActivated() {
    }

    public void windowClosed() {
    }

    public FeatureAttributeDescriptor[] getSelectedColumnsDescriptors() {
        try {
            return this.getTablePanel().getTable().getSelectedColumnsAttributeDescriptor();
        }
        catch (DataException ex) {
            return null;
        }
    }
}

