/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import org.gvsig.andami.LocaleManager;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.gui.GeneralTablePropertiesPageLayout;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTableConfigurationPanel;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralTablePropertiesPage
extends GeneralTablePropertiesPageLayout
implements PropertiesPage {
    private static final Logger logger = LoggerFactory.getLogger(GeneralTablePropertiesPage.class);
    private static final long serialVersionUID = -8639908797829738997L;
    private final TableDocument tableDocument;
    private FeatureTableConfigurationPanel columnsConfigurationPanel = null;
    private LocaleManager localeManager;

    public GeneralTablePropertiesPage(TableDocument tableDocument) {
        this.tableDocument = tableDocument;
        this.localeManager = PluginsLocator.getLocaleManager();
        this.initComponents();
        try {
            FeatureType featureType = tableDocument.getFeatureStore().getDefaultFeatureType();
            for (FeatureAttributeDescriptor descriptor : featureType) {
                this.columnsConfigurationPanel.setFormattingPattern(descriptor.getName(), tableDocument.getFormattingPattern(descriptor.getName()));
            }
        }
        catch (DataException ex) {
            logger.warn("Can't initialize columns formating patters", (Throwable)ex);
        }
    }

    public void setData(Object data) {
    }

    private void initComponents() {
        this.txtName.setText(this.tableDocument.getName());
        this.txtDate.setText(this.tableDocument.getCreationDate());
        this.txtOwner.setText(this.tableDocument.getOwner());
        this.txtComments.setText(this.tableDocument.getComment());
        this.pnlColumns.setLayout(new BorderLayout());
        this.pnlColumns.add((Component)this.getColumnsConfigurationPanel(), "Center");
        Set localeSet = this.localeManager.getInstalledLocales();
        for (Locale item : localeSet) {
            this.cboLocaleOfData.addItem(new LocaleComboBoxItem(item));
        }
        Locale localeOfData = this.tableDocument.getFeatureStoreModel().getCurrentFeatureTableModel().getLocaleOfData();
        if (localeOfData != null) {
            this.cboLocaleOfData.setSelectedItem(new LocaleComboBoxItem(localeOfData));
        }
        if (this.tableDocument.getFeatureStore() != null) {
            this.txtDataSource.setText(this.tableDocument.getFeatureStore().getFullName());
        }
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblName.setText(i18nManager.getTranslation("Nombre_XcolonX"));
        this.lblDate.setText(i18nManager.getTranslation("creation_date_XcolonX"));
        this.lblOwner.setText(i18nManager.getTranslation("owner_XcolonX"));
        this.lblLocaleOfData.setText(i18nManager.getTranslation("locale_XcolonX"));
        this.lblComments.setText(i18nManager.getTranslation("comentarios_XcolonX"));
        this.lblColumns.setText(i18nManager.getTranslation("_Column_information_XcolonX"));
        this.lblDataSource.setText(i18nManager.getTranslation("Data_source"));
    }

    public void accept() {
    }

    private Locale getLocaleOfData() {
        LocaleComboBoxItem item = (LocaleComboBoxItem)this.cboLocaleOfData.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getLocale();
    }

    private FeatureTableConfigurationPanel getColumnsConfigurationPanel() {
        if (this.columnsConfigurationPanel == null) {
            this.columnsConfigurationPanel = new FeatureTableConfigurationPanel(this.tableDocument.getFeatureStoreModel().getCurrentFeatureTableModel());
        }
        return this.columnsConfigurationPanel;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("General");
    }

    public int getPriority() {
        return 1000;
    }

    public JComponent asJComponent() {
        return this;
    }

    public boolean whenAccept() {
        return this.whenApply();
    }

    public boolean whenApply() {
        this.tableDocument.setName(this.txtName.getText());
        this.tableDocument.setCreationDate(this.txtDate.getText());
        this.tableDocument.setOwner(this.txtOwner.getText());
        this.tableDocument.setComment(this.txtComments.getText());
        this.tableDocument.getFeatureStoreModel().getCurrentFeatureTableModel().setLocaleOfData(this.getLocaleOfData());
        this.getColumnsConfigurationPanel().accept();
        try {
            FeatureType featureType = this.tableDocument.getFeatureStore().getDefaultFeatureType();
            for (FeatureAttributeDescriptor descriptor : featureType) {
                this.tableDocument.setFormattingPattern(descriptor.getName(), this.columnsConfigurationPanel.getFormattingPattern(descriptor.getName()));
            }
        }
        catch (DataException ex) {
            logger.warn("Can't set columns formating patters in the table document", (Throwable)ex);
        }
        return true;
    }

    public boolean whenCancel() {
        return true;
    }

    private class LocaleComboBoxItem {
        private Locale locale;

        public LocaleComboBoxItem(Locale locale) {
            this.locale = locale;
        }

        public String toString() {
            return GeneralTablePropertiesPage.this.localeManager.getLocaleDisplayName(this.locale);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocaleComboBoxItem)) {
                return false;
            }
            LocaleComboBoxItem item = (LocaleComboBoxItem)o;
            return this.locale.equals(item.getLocale());
        }
    }
}

