/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.buffer.impl.histogram;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class StatisticsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5110298183227533382L;
    private Statistics statistics;
    private List<Integer> selectedBands;
    public static final int COLUMNS = 9;
    public static final int COLUMN_NUMBER = 0;
    public static final int COLUMN_LENGTH = 1;
    public static final int COLUMN_MAX = 2;
    public static final int COLUMN_SECOND_MAX = 3;
    public static final int COLUMN_MIN = 4;
    public static final int COLUMN_SECOND_MIN = 5;
    public static final int COLUMN_MEAN = 6;
    public static final int COLUMN_MEDIAN = 7;
    public static final int COLUMN_VARIANCE = 8;

    public StatisticsTableModel(Statistics statistics, List<Integer> selectedBands) {
        this.statistics = statistics;
        this.selectedBands = selectedBands;
    }

    @Override
    public int getRowCount() {
        if (this.statistics == null) {
            return 0;
        }
        return this.selectedBands.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.selectedBands.get(rowIndex);
            }
            case 1: {
                if (this.statistics == null || this.selectedBands == null || this.selectedBands.size() == 0) {
                    return 0;
                }
                return this.statistics.getNumberOfValues()[this.selectedBands.get(rowIndex)];
            }
            case 2: {
                if (this.statistics == null) {
                    return null;
                }
                return this.statistics.getMax()[this.selectedBands.get(rowIndex)];
            }
            case 3: {
                if (this.statistics == null) {
                    return null;
                }
                return this.statistics.getSecondMax()[this.selectedBands.get(rowIndex)];
            }
            case 4: {
                if (this.statistics == null) {
                    return null;
                }
                return this.statistics.getMin()[this.selectedBands.get(rowIndex)];
            }
            case 5: {
                if (this.statistics == null) {
                    return null;
                }
                return this.statistics.getSecondMin()[this.selectedBands.get(rowIndex)];
            }
            case 6: {
                if (this.statistics == null) {
                    return null;
                }
                return this.statistics.getMean()[this.selectedBands.get(rowIndex)];
            }
            case 7: {
                if (this.statistics == null) {
                    return null;
                }
                return this.statistics.getMedian()[this.selectedBands.get(rowIndex)];
            }
            case 8: {
                if (this.statistics == null) {
                    return null;
                }
                return this.statistics.getVariance()[this.selectedBands.get(rowIndex)];
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        switch (column) {
            case 0: {
                return i18nManager.getTranslation("_number");
            }
            case 1: {
                return i18nManager.getTranslation("_number_of_values");
            }
            case 2: {
                return i18nManager.getTranslation("_maximum");
            }
            case 3: {
                return i18nManager.getTranslation("_second_maximum");
            }
            case 4: {
                return i18nManager.getTranslation("_minimum");
            }
            case 5: {
                return i18nManager.getTranslation("_second_minimum");
            }
            case 6: {
                return i18nManager.getTranslation("_mean");
            }
            case 7: {
                return i18nManager.getTranslation("_median");
            }
            case 8: {
                return i18nManager.getTranslation("_variance");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

