/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.buffer.impl.statistics;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JComponent;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.swing.buffer.impl.statistics.StatisticsPanelView;
import org.gvsig.raster.swing.buffer.statistics.StatisticsPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.impl.DefaultActionListenerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsPanelController
extends StatisticsPanelView
implements StatisticsPanel {
    private static final long serialVersionUID = -8356595978140294871L;
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsPanelController.class);
    private ActionListenerSupport listenerSupport;

    public StatisticsPanelController() {
        this.translate();
        this.btnRecalculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsPanelController.this.doRecalculate(e);
            }
        });
        this.listenerSupport = new DefaultActionListenerSupport();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.txtStatistics.setToolTipText(i18nManager.getTranslation(this.txtStatistics.getToolTipText()));
        this.btnRecalculate.setText(i18nManager.getTranslation(this.btnRecalculate.getText()));
        this.btnRecalculate.setToolTipText(i18nManager.getTranslation(this.btnRecalculate.getToolTipText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    public void set(Statistics statistics) {
        this.txtStatistics.setText(statistics.toHTMLString());
    }

    public JComponent asJComponent() {
        return this;
    }

    private void doRecalculate(ActionEvent e) {
        this.fireActionEvent(new ActionEvent(this, e.getID(), e.getActionCommand()));
    }

    private String dataTypeString(int dataType) {
        switch (dataType) {
            case 0: {
                return "Byte";
            }
            case 1: {
                return "Unsigned short";
            }
            case 2: {
                return "Short";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Double";
            }
        }
        throw new IllegalArgumentException();
    }

    public void addActionListener(ActionListener listener) {
        this.listenerSupport.addActionListener(listener);
        this.btnRecalculate.setEnabled(true);
    }

    public ActionListener[] getActionListeners() {
        return this.listenerSupport.getActionListeners();
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerSupport.removeActionListener(listener);
        if (this.listenerSupport.getActionListeners().length == 0) {
            this.btnRecalculate.setEnabled(false);
        }
    }

    public void removeAllActionListener() {
        this.listenerSupport.removeAllActionListener();
        this.btnRecalculate.setEnabled(false);
    }

    public void fireActionEvent(ActionEvent event) {
        ActionListener[] listeners;
        EventObject e = null;
        for (ActionListener actionListener : listeners = this.listenerSupport.getActionListeners()) {
            if (e != null) continue;
            String actionCommand = event.getActionCommand();
            if (actionCommand == null && e.getSource() == this.btnRecalculate) {
                actionCommand = this.btnRecalculate.getActionCommand();
            }
            e = new ActionEvent(this, 1001, actionCommand);
            actionListener.actionPerformed((ActionEvent)e);
        }
    }

    public boolean hasActionListeners() {
        return this.listenerSupport.hasActionListeners();
    }
}

