/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.process.IncrementableTask;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;

public class BufferInterpolation
implements IncrementableTask {
    private Buffer buffer = null;
    private double percent = 0.0;

    public BufferInterpolation(Buffer buf) {
        this.buffer = buf;
    }

    public Buffer adjustRasterNearestNeighbourInterpolation(int w, int h) throws ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double stepX = (double)w / (double)this.buffer.getWidth();
        double stepY = (double)h / (double)this.buffer.getHeight();
        Buffer rasterBuf = DefaultRasterManager.getInstance().createBuffer(this.buffer.getDataType(), w, h, this.buffer.getBandCount(), true);
        int[] bands = new int[rasterBuf.getBandCount()];
        for (int iBand = 0; iBand < rasterBuf.getBandCount(); ++iBand) {
            bands[iBand] = iBand;
        }
        this.percent = 0.0;
        double multip = 100.0 / (double)(this.buffer.getHeight() * bands.length);
        switch (this.buffer.getDataType()) {
            case 0: {
                for (int iBand = 0; iBand < bands.length; ++iBand) {
                    int iCol;
                    int iRow;
                    if (w <= this.buffer.getWidth()) {
                        for (iRow = 0; iRow < this.buffer.getHeight(); ++iRow) {
                            for (iCol = 0; iCol < this.buffer.getWidth(); ++iCol) {
                                rasterBuf.setElem((int)((double)iRow * stepY), (int)((double)iCol * stepX), bands[iBand], this.buffer.getElemByte(iRow, iCol, iBand));
                            }
                            this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                            if (task.getEvent() == null) continue;
                            task.manageEvent(task.getEvent());
                        }
                        continue;
                    }
                    for (iRow = 0; iRow < h; ++iRow) {
                        for (iCol = 0; iCol < w; ++iCol) {
                            rasterBuf.setElem(iRow, iCol, bands[iBand], this.buffer.getElemByte((int)((double)iRow / stepY), (int)((double)iCol / stepX), iBand));
                        }
                        this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 5: {
                for (int iBand = 0; iBand < bands.length; ++iBand) {
                    int iCol;
                    int iRow;
                    if (w <= this.buffer.getWidth()) {
                        for (iRow = 0; iRow < this.buffer.getHeight(); ++iRow) {
                            for (iCol = 0; iCol < this.buffer.getWidth(); ++iCol) {
                                rasterBuf.setElem((int)((double)iRow * stepY), (int)((double)iCol * stepX), bands[iBand], this.buffer.getElemDouble(iRow, iCol, iBand));
                            }
                            this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                            if (task.getEvent() == null) continue;
                            task.manageEvent(task.getEvent());
                        }
                        continue;
                    }
                    for (iRow = 0; iRow < h; ++iRow) {
                        for (iCol = 0; iCol < w; ++iCol) {
                            rasterBuf.setElem(iRow, iCol, bands[iBand], this.buffer.getElemDouble((int)((double)iRow / stepY), (int)((double)iCol / stepX), iBand));
                        }
                        this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 4: {
                for (int iBand = 0; iBand < bands.length; ++iBand) {
                    int iCol;
                    int iRow;
                    if (w <= this.buffer.getWidth()) {
                        for (iRow = 0; iRow < this.buffer.getHeight(); ++iRow) {
                            for (iCol = 0; iCol < this.buffer.getWidth(); ++iCol) {
                                rasterBuf.setElem((int)((double)iRow * stepY), (int)((double)iCol * stepX), bands[iBand], this.buffer.getElemFloat(iRow, iCol, iBand));
                            }
                            this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                            if (task.getEvent() == null) continue;
                            task.manageEvent(task.getEvent());
                        }
                        continue;
                    }
                    for (iRow = 0; iRow < h; ++iRow) {
                        for (iCol = 0; iCol < w; ++iCol) {
                            rasterBuf.setElem(iRow, iCol, bands[iBand], this.buffer.getElemFloat((int)((double)iRow / stepY), (int)((double)iCol / stepX), iBand));
                        }
                        this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 3: {
                for (int iBand = 0; iBand < bands.length; ++iBand) {
                    int iCol;
                    int iRow;
                    if (w <= this.buffer.getWidth()) {
                        for (iRow = 0; iRow < this.buffer.getHeight(); ++iRow) {
                            for (iCol = 0; iCol < this.buffer.getWidth(); ++iCol) {
                                rasterBuf.setElem((int)((double)iRow * stepY), (int)((double)iCol * stepX), bands[iBand], this.buffer.getElemInt(iRow, iCol, iBand));
                            }
                            this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                            if (task.getEvent() == null) continue;
                            task.manageEvent(task.getEvent());
                        }
                        continue;
                    }
                    for (iRow = 0; iRow < h; ++iRow) {
                        for (iCol = 0; iCol < w; ++iCol) {
                            rasterBuf.setElem(iRow, iCol, bands[iBand], this.buffer.getElemInt((int)((double)iRow / stepY), (int)((double)iCol / stepX), iBand));
                        }
                        this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                for (int iBand = 0; iBand < bands.length; ++iBand) {
                    int iCol;
                    int iRow;
                    if (w <= this.buffer.getWidth()) {
                        for (iRow = 0; iRow < this.buffer.getHeight(); ++iRow) {
                            for (iCol = 0; iCol < this.buffer.getWidth(); ++iCol) {
                                rasterBuf.setElem((int)((double)iRow * stepY), (int)((double)iCol * stepX), bands[iBand], this.buffer.getElemShort(iRow, iCol, iBand));
                            }
                            this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                            if (task.getEvent() == null) continue;
                            task.manageEvent(task.getEvent());
                        }
                        continue;
                    }
                    for (iRow = 0; iRow < h; ++iRow) {
                        for (iCol = 0; iCol < w; ++iCol) {
                            rasterBuf.setElem(iRow, iCol, bands[iBand], this.buffer.getElemShort((int)((double)iRow / stepY), (int)((double)iCol / stepX), iBand));
                        }
                        this.percent = (double)(iBand * this.buffer.getHeight() + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
        }
        return rasterBuf;
    }

    public Buffer adjustRasterBilinearInterpolation(int w, int h) throws ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double pxSizeX = (double)this.buffer.getWidth() / (double)w;
        double pxSizeY = (double)this.buffer.getHeight() / (double)h;
        Buffer rasterBuf = DefaultRasterManager.getInstance().createBuffer(this.buffer.getDataType(), w, h, this.buffer.getBandCount(), true);
        double dx = 0.0;
        double dy = 0.0;
        this.percent = 0.0;
        double multip = 100.0 / (double)(h * this.buffer.getBandCount());
        block17: for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            double posY = pxSizeY / 2.0;
            switch (this.buffer.getDataType()) {
                case 0: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelByte((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, (byte)((byte)this.getBilinearValue(dx, dy, kernel2) & 0xFF));
                            }
                            catch (ArrayIndexOutOfBoundsException kernel2) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 2: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelShort((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, (short)((short)this.getBilinearValue(dx, dy, kernel2) & 0xFFFF));
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 3: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelInt((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, (int)this.getBilinearValue(dx, dy, kernel2) & 0xFF);
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 4: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelFloat((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, (float)this.getBilinearValue(dx, dy, kernel2));
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 5: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelDouble((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, this.getBilinearValue(dx, dy, kernel2));
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
            }
        }
        return rasterBuf;
    }

    public Buffer adjustRasterInverseDistanceInterpolation(int w, int h) throws ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double pxSizeX = (double)this.buffer.getWidth() / (double)w;
        double pxSizeY = (double)this.buffer.getHeight() / (double)h;
        Buffer rasterBuf = DefaultRasterManager.getInstance().createBuffer(this.buffer.getDataType(), w, h, this.buffer.getBandCount(), true);
        double dx = 0.0;
        double dy = 0.0;
        this.percent = 0.0;
        double multip = 100.0 / (double)(h * this.buffer.getBandCount());
        block17: for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            double posY = pxSizeX / 2.0;
            switch (this.buffer.getDataType()) {
                case 0: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelByte((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, (byte)((byte)this.getInverseDistanceValue(dx, dy, kernel2) & 0xFF));
                            }
                            catch (ArrayIndexOutOfBoundsException kernel2) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 2: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelShort((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, (short)((short)this.getInverseDistanceValue(dx, dy, kernel2) & 0xFFFF));
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 3: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelInt((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, (int)this.getInverseDistanceValue(dx, dy, kernel2) & 0xFF);
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 4: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelFloat((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, (float)this.getInverseDistanceValue(dx, dy, kernel2));
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 5: {
                    double[] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.getKernelDouble((int)posX, (int)posY, iBand);
                                rasterBuf.setElem(iRow, iCol, iBand, this.getInverseDistanceValue(dx, dy, kernel2));
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
            }
        }
        return rasterBuf;
    }

    public Buffer adjustRasterBSplineInterpolation(int w, int h) throws ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double pxSizeX = (double)this.buffer.getWidth() / (double)w;
        double pxSizeY = (double)this.buffer.getHeight() / (double)h;
        Buffer rasterBuf = DefaultRasterManager.getInstance().createBuffer(this.buffer.getDataType(), w, h, this.buffer.getBandCount(), true);
        double dx = 0.0;
        double dy = 0.0;
        this.percent = 0.0;
        double multip = 100.0 / (double)(h * this.buffer.getBandCount());
        block17: for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            double posY = pxSizeY / 2.0;
            switch (this.buffer.getDataType()) {
                case 0: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelByte((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, (byte)((byte)this.getBilinearValue(dx, dy, k) & 0xFF));
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, (byte)((byte)this.getBSplineValue(dx, dy, kernel2) & 0xFF));
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException kernel2) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 2: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelShort((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, (short)((short)this.getBilinearValue(dx, dy, k) & 0xFFFF));
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, (short)((short)this.getBSplineValue(dx, dy, kernel2) & 0xFFFF));
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 3: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelInt((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, (int)this.getBilinearValue(dx, dy, k) & 0xFFFFFFFF);
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, (int)this.getBSplineValue(dx, dy, kernel2) & 0xFFFFFFFF);
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 4: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelFloat((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, (float)this.getBilinearValue(dx, dy, k));
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, (float)this.getBSplineValue(dx, dy, kernel2));
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 5: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelDouble((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, this.getBilinearValue(dx, dy, k));
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, this.getBSplineValue(dx, dy, kernel2));
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
            }
        }
        return rasterBuf;
    }

    public Buffer adjustRasterBicubicSplineInterpolation(int w, int h) throws ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double pxSizeX = (double)this.buffer.getWidth() / (double)w;
        double pxSizeY = (double)this.buffer.getHeight() / (double)h;
        Buffer rasterBuf = DefaultRasterManager.getInstance().createBuffer(this.buffer.getDataType(), w, h, this.buffer.getBandCount(), true);
        double dx = 0.0;
        double dy = 0.0;
        this.percent = 0.0;
        double multip = 100.0 / (double)(h * this.buffer.getBandCount());
        block17: for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            double posY = pxSizeY / 2.0;
            switch (this.buffer.getDataType()) {
                case 0: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelByte((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, (byte)((byte)this.getBilinearValue(dx, dy, k) & 0xFF));
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, (byte)((byte)this.getBicubicSplineValue(dx, dy, kernel2) & 0xFF));
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException kernel2) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 2: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelShort((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, (short)((short)this.getBilinearValue(dx, dy, k) & 0xFFFF));
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, (short)((short)this.getBicubicSplineValue(dx, dy, kernel2) & 0xFFFF));
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 3: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelInt((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, (int)this.getBilinearValue(dx, dy, k) & 0xFFFFFFFF);
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, (int)this.getBicubicSplineValue(dx, dy, kernel2) & 0xFFFFFFFF);
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 4: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelFloat((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, (float)this.getBilinearValue(dx, dy, k));
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, (float)this.getBicubicSplineValue(dx, dy, kernel2));
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException kernel) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
                case 5: {
                    double[] k;
                    double[][] kernel2;
                    int iCol;
                    double posX;
                    int iRow;
                    for (iRow = 0; iRow < h; ++iRow) {
                        dy = posY - (double)((int)posY);
                        posX = pxSizeX / 2.0;
                        for (iCol = 0; iCol < w; ++iCol) {
                            dx = posX - (double)((int)posX);
                            try {
                                kernel2 = this.get4x4Submatrix((int)posX, (int)posY, iBand);
                                if (kernel2 == null) {
                                    k = this.getKernelDouble((int)posX, (int)posY, iBand);
                                    rasterBuf.setElem(iRow, iCol, iBand, this.getBilinearValue(dx, dy, k));
                                } else {
                                    rasterBuf.setElem(iRow, iCol, iBand, this.getBicubicSplineValue(dx, dy, kernel2));
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            posX += pxSizeX;
                        }
                        posY += pxSizeY;
                        this.percent = (double)(iBand * h + iRow) * multip;
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                    continue block17;
                }
            }
        }
        return rasterBuf;
    }

    private double getBicubicSplineValue(double dx, double dy, double[][] kernel) {
        double b3;
        double b2;
        double b1;
        double a3;
        double a2;
        double a0;
        double[] c = new double[4];
        for (int i = 0; i < 4; ++i) {
            a0 = kernel[0][i] - kernel[1][i];
            a2 = kernel[2][i] - kernel[1][i];
            a3 = kernel[3][i] - kernel[1][i];
            b1 = -a0 / 3.0 + a2 - a3 / 6.0;
            b2 = a0 / 2.0 + a2 / 2.0;
            b3 = -a0 / 6.0 - a2 / 2.0 + a3 / 6.0;
            c[i] = kernel[1][i] + b1 * dx + b2 * (dx * dx) + b3 * (dx * dx * dx);
        }
        a0 = c[0] - c[1];
        a2 = c[2] - c[1];
        a3 = c[3] - c[1];
        b1 = -a0 / 3.0 + a2 - a3 / 6.0;
        b2 = a0 / 2.0 + a2 / 2.0;
        b3 = -a0 / 6.0 - a2 / 2.0 + a3 / 6.0;
        return c[1] + b1 * dy + b2 * (dy * dy) + b3 * (dy * dy * dy);
    }

    private double getBSplineValue(double dx, double dy, double[][] kernel) {
        int i = 0;
        int ix = 0;
        int iy = 0;
        double px = 0.0;
        double py = 0.0;
        double z = 0.0;
        double[] Rx = new double[4];
        double[] Ry = new double[4];
        i = 0;
        px = -1.0 - dx;
        py = -1.0 - dy;
        while (i < 4) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            Rx[i] = 0.0;
            Ry[i] = 0.0;
            z = px + 2.0;
            if (d8 > 0.0) {
                int n = i;
                Rx[n] = Rx[n] + z * z * z;
            }
            z = px + 1.0;
            if (d7 > 0.0) {
                int n = i;
                Rx[n] = Rx[n] + -4.0 * z * z * z;
            }
            z = px + 0.0;
            if (d6 > 0.0) {
                int n = i;
                Rx[n] = Rx[n] + 6.0 * z * z * z;
            }
            z = px - 1.0;
            if (d5 > 0.0) {
                int n = i;
                Rx[n] = Rx[n] + -4.0 * z * z * z;
            }
            z = py + 2.0;
            if (d4 > 0.0) {
                int n = i;
                Ry[n] = Ry[n] + z * z * z;
            }
            z = py + 1.0;
            if (d3 > 0.0) {
                int n = i;
                Ry[n] = Ry[n] + -4.0 * z * z * z;
            }
            z = py + 0.0;
            if (d2 > 0.0) {
                int n = i;
                Ry[n] = Ry[n] + 6.0 * z * z * z;
            }
            z = py - 1.0;
            if (d > 0.0) {
                int n = i;
                Ry[n] = Ry[n] + -4.0 * z * z * z;
            }
            int n = i;
            Rx[n] = Rx[n] / 6.0;
            int n2 = i++;
            Ry[n2] = Ry[n2] / 6.0;
            px += 1.0;
            py += 1.0;
        }
        z = 0.0;
        for (iy = 0; iy < 4; ++iy) {
            for (ix = 0; ix < 4; ++ix) {
                z += kernel[ix][iy] * Rx[ix] * Ry[iy];
            }
        }
        return z;
    }

    private double getBilinearValue(double dx, double dy, double[] kernel) {
        double z = 0.0;
        double n = 0.0;
        double d = (1.0 - dx) * (1.0 - dy);
        z += d * kernel[0];
        n += d;
        d = dx * (1.0 - dy);
        z += d * kernel[1];
        n += d;
        d = (1.0 - dx) * dy;
        z += d * kernel[2];
        n += d;
        d = dx * dy;
        z += d * kernel[3];
        n += d;
        double b = 0.0;
        if (n > 0.0) {
            b = z / n;
        }
        return b;
    }

    private double getInverseDistanceValue(double dx, double dy, double[] kernel) {
        double z = 0.0;
        double n = 0.0;
        double t = Math.sqrt(dx * dx + dy * dy);
        double d = 1.0 / (t == 0.0 ? 0.5 : t);
        z += d * kernel[0];
        n += d;
        t = Math.sqrt((1.0 - dx) * (1.0 - dx) + dy * dy);
        d = 1.0 / (t == 0.0 ? 0.5 : t);
        z += d * kernel[1];
        n += d;
        t = Math.sqrt(dx * dx + (1.0 - dy) * (1.0 - dy));
        d = 1.0 / (t == 0.0 ? 0.5 : t);
        z += d * kernel[2];
        n += d;
        t = Math.sqrt((1.0 - dx) * (1.0 - dx) + (1.0 - dy) * (1.0 - dy));
        d = 1.0 / (t == 0.0 ? 0.5 : t);
        z += d * kernel[3];
        n += d;
        double b = 0.0;
        if (n > 0.0) {
            b = z / n;
        }
        return b;
    }

    private double[][] get4x4Submatrix(int x, int y, int band) {
        double[][] z_xy = new double[4][4];
        int iy = 0;
        int py = y - 1;
        while (iy < 4) {
            int ix = 0;
            int px = x - 1;
            while (ix < 4) {
                if (!this.buffer.isInside(px, py)) {
                    return null;
                }
                switch (this.buffer.getDataType()) {
                    case 0: {
                        z_xy[ix][iy] = this.buffer.getElemByte(py, px, band) & 0xFF;
                        break;
                    }
                    case 2: {
                        z_xy[ix][iy] = this.buffer.getElemShort(py, px, band) & 0xFFFF;
                        break;
                    }
                    case 3: {
                        z_xy[ix][iy] = this.buffer.getElemInt(py, px, band) & 0xFFFFFFFF;
                        break;
                    }
                    case 4: {
                        z_xy[ix][iy] = this.buffer.getElemFloat(py, px, band);
                        break;
                    }
                    case 5: {
                        z_xy[ix][iy] = this.buffer.getElemDouble(py, px, band);
                    }
                }
                ++ix;
                ++px;
            }
            ++iy;
            ++py;
        }
        return z_xy;
    }

    private double[] getKernelByte(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemByte(y, x, band) & 0xFF;
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemByte(y, nextX, band) & 0xFF;
        d[2] = this.buffer.getElemByte(nextY, x, band) & 0xFF;
        d[3] = this.buffer.getElemByte(nextY, nextX, band) & 0xFF;
        return d;
    }

    private double[] getKernelShort(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemShort(y, x, band) & 0xFFFF;
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemShort(y, nextX, band) & 0xFFFF;
        d[2] = this.buffer.getElemShort(nextY, x, band) & 0xFFFF;
        d[3] = this.buffer.getElemShort(nextY, nextX, band) & 0xFFFF;
        return d;
    }

    private double[] getKernelInt(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemInt(y, x, band) & 0xFFFFFFFF;
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemInt(y, nextX, band) & 0xFFFFFFFF;
        d[2] = this.buffer.getElemInt(nextY, x, band) & 0xFFFFFFFF;
        d[3] = this.buffer.getElemInt(nextY, nextX, band) & 0xFFFFFFFF;
        return d;
    }

    private double[] getKernelFloat(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemFloat(y, x, band);
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemFloat(y, nextX, band);
        d[2] = this.buffer.getElemFloat(nextY, x, band);
        d[3] = this.buffer.getElemFloat(nextY, nextX, band);
        return d;
    }

    private double[] getKernelDouble(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemDouble(y, x, band);
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemDouble(y, nextX, band);
        d[2] = this.buffer.getElemDouble(nextY, x, band);
        d[3] = this.buffer.getElemDouble(nextY, nextX, band);
        return d;
    }

    public int getPercent() {
        return Math.min((int)this.percent, 100);
    }

    public String getLog() {
        return null;
    }

    public boolean isCancelable() {
        return true;
    }

    public boolean isPausable() {
        return false;
    }

    public void setPercent(int value) {
        this.percent = value;
    }
}

