/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import org.gvsig.fmap.dal.coverage.RasterLibrary;

public class CacheStruct {
    private long cacheSize = RasterLibrary.cacheSize;
    private double pageSize = RasterLibrary.pageSize;
    private int pagsPerGroup = RasterLibrary.pagsPerGroup;
    private int[] possibleHeights = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
    private int hPag = 1;
    private int offset = 1;
    private int nPags = 0;
    private int nPageBandBuffers = 0;
    private int nGroups = 0;
    private int bitsPag = 0;
    private int nTotalPags = 0;
    private long cacheSizePerBand = 0L;
    private long pageSizePerBand = 0L;
    private int dataType = 0;

    public CacheStruct(int nBands, int dataType, int dataSourceWidth, int dataSourceHeight) {
        this.init(nBands, dataType, dataSourceWidth, dataSourceHeight);
    }

    public CacheStruct() {
    }

    public CacheStruct(int nBands, int dataType, int dataSourceWidth, int dataSourceHeight, long cacheSize, long pageSize) {
        this.cacheSize = cacheSize;
        this.pageSize = pageSize;
        this.init(nBands, dataType, dataSourceWidth, dataSourceHeight);
    }

    private void init(int nBands, int dataType, int dataSourceWidth, int dataSourceHeight) {
        this.nPageBandBuffers = nBands;
        this.dataType = dataType;
        this.cacheSize *= 0x100000L;
        this.pageSize *= 1048576.0;
        this.cacheSizePerBand = this.cacheSize / (long)nBands;
        this.pageSizePerBand = (long)(this.pageSize / (double)nBands);
        int dataSizePerBand = 0;
        if (dataType == 0) {
            dataSizePerBand = 1;
        } else if (dataType == 2 | dataType == 1) {
            dataSizePerBand = 2;
        } else if (dataType == 3) {
            dataSizePerBand = 4;
        } else if (dataType == 4) {
            dataSizePerBand = 4;
        } else if (dataType == 5) {
            dataSizePerBand = 8;
        }
        for (int i = this.possibleHeights.length - 1; i >= 0; --i) {
            long size = (long)dataSourceWidth * (long)this.possibleHeights[i] * (long)dataSizePerBand;
            if (size > this.pageSizePerBand) continue;
            this.hPag = this.possibleHeights[i];
            break;
        }
        this.pageSizePerBand = dataSourceWidth * this.hPag * dataSizePerBand;
        this.nPags = (int)(this.cacheSizePerBand / this.pageSizePerBand);
        while (this.nPags % this.pagsPerGroup != 0) {
            ++this.nPags;
        }
        this.cacheSizePerBand = this.pageSizePerBand * (long)this.nPags;
        this.nGroups = this.nPags / this.pagsPerGroup;
        int h = this.hPag;
        while (h > 1) {
            h >>= 1;
            ++this.bitsPag;
        }
        this.nTotalPags = dataSourceHeight / this.hPag;
        if (dataSourceHeight % this.hPag != 0) {
            ++this.nTotalPags;
        }
        this.offset = this.hPag - 1;
        this.cacheSize = this.cacheSizePerBand * (long)nBands;
        this.pageSize = this.pageSizePerBand * (long)nBands;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public int getHPag() {
        return this.hPag;
    }

    public void setHPag(int hPag) {
        this.hPag = hPag;
    }

    public int getNBands() {
        return this.nPageBandBuffers;
    }

    public void setNBands(int nBands) {
        this.nPageBandBuffers = nBands;
    }

    public int getNPags() {
        return this.nPags;
    }

    public void setNPags(int nPags) {
        this.nPags = nPags;
    }

    public long getPagSize() {
        return (long)this.pageSize;
    }

    public int getPagsPerGroup() {
        return this.pagsPerGroup;
    }

    public int getNGroups() {
        return this.nGroups;
    }

    public void setNGroups(int nGroups) {
        this.nGroups = nGroups;
    }

    public int getNTotalPags() {
        return this.nTotalPags;
    }

    public void setNTotalPags(int nPags) {
        this.nTotalPags = nPags;
    }

    public int getBitsPag() {
        return this.bitsPag;
    }

    public void setBitsPag(int bitsPag) {
        this.bitsPag = bitsPag;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long getCacheSizePerBand() {
        return this.cacheSizePerBand;
    }

    public void setCacheSizePerBand(long cacheSizePerBand) {
        this.cacheSizePerBand = cacheSizePerBand;
    }

    public long getPagSizePerBand() {
        return this.pageSizePerBand;
    }

    public void setPagSizePerBand(long pagSizePerBand) {
        this.pageSizePerBand = pagSizePerBand;
    }

    public void show() {
        System.out.println("Cache (total size):" + this.cacheSize);
        System.out.println("Page (total size):" + this.pageSize);
        System.out.println("Cache (size per band):" + this.cacheSizePerBand);
        System.out.println("Page (size per band):" + this.pageSizePerBand);
        System.out.println("Number of Pags del raster:" + this.nTotalPags);
        System.out.println("Number of Pags de cache:" + this.nPags);
        System.out.println("Number of Bands:" + this.nPageBandBuffers);
        System.out.println("Number of Groups:" + this.nGroups);
        System.out.println("Pages per group:" + this.pagsPerGroup);
        System.out.println("bits per pag:" + this.bitsPag);
        System.out.println("Page Height (in lines):" + this.hPag);
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }
}

